package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the ENTITY_KEYWORDS category specify keywords
 *  relevant to the molecular entities. Note that this list of
 *  keywords is separate from the list that is used for the
 *  STRUCT_BIOL data items and is intended to provide only the
 *  information that one would know about the molecular entity *if
 *  one did not know its structure*. Hence polypeptides are simply
 *  polypeptides, not cytokines or beta-alpha-barrels, and
 *  polyribonucleic acids are simply poly-RNA, not transfer-
 *  RNA.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entity_keywordsCategory>
 *  <PDBx:entity_keywords entity_id="2">
 *  <PDBx:text>natural product, inhibitor, reduced peptide</PDBx:text>
 *  </PDBx:entity_keywords>
 *  </PDBx:entity_keywordsCategory>
 * </pre>
 */
public class Entity_keywords extends org.pdb.beans.Entity_keywords implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "entity_keywords";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Entity_keywords()
	{
	}

	/** Full constructor */
	public Entity_keywords(
		Datablock datablock,
		java.lang.String entity_id,
		java.lang.String pdbx_ec,
		java.lang.String pdbx_fragment,
		java.lang.String pdbx_mutation,
		java.lang.String text)
	{
		this.datablock = datablock;
		this.entity_id = entity_id;
		this.pdbx_ec = pdbx_ec;
		this.pdbx_fragment = pdbx_fragment;
		this.pdbx_mutation = pdbx_mutation;
		this.text = text;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Entity_keywords");
		sb.append("\n");
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (pdbx_ec != null)
		{
			sb.append("pdbx_ec = ");
			sb.append(pdbx_ec);
			sb.append('\n');
		}
		if (pdbx_fragment != null)
		{
			sb.append("pdbx_fragment = ");
			sb.append(pdbx_fragment);
			sb.append('\n');
		}
		if (pdbx_mutation != null)
		{
			sb.append("pdbx_mutation = ");
			sb.append(pdbx_mutation);
			sb.append('\n');
		}
		if (text != null)
		{
			sb.append("text = ");
			sb.append(text);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		entity_id = null;
		pdbx_ec = null;
		pdbx_fragment = null;
		pdbx_mutation = null;
		text = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Entity_keywords)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:entity_keywords>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (pdbx_ec != null) ow.write(indent + " <PDBx:pdbx_ec>" + pdbx_ec + "</PDBx:pdbx_ec>\n");
			if (pdbx_fragment != null) ow.write(indent + " <PDBx:pdbx_fragment>" + pdbx_fragment + "</PDBx:pdbx_fragment>\n");
			if (pdbx_mutation != null) ow.write(indent + " <PDBx:pdbx_mutation>" + pdbx_mutation + "</PDBx:pdbx_mutation>\n");
			if (text != null) ow.write(indent + " <PDBx:text>" + text + "</PDBx:text>\n");
			ow.write(indent + "</PDBx:entity_keywords>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
