package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the ENTITY_LINK category give details about
 *  the links between entities.
 */
public class Entity_link extends org.pdb.beans.Entity_link implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "entity_link";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Entity_link()
	{
	}

	/** Full constructor */
	public Entity_link(
		Datablock datablock,
		java.lang.String details,
		java.lang.String entity_id_1,
		java.lang.String entity_id_2,
		java.lang.Integer entity_seq_num_1,
		java.lang.Integer entity_seq_num_2,
		java.lang.String link_id)
	{
		this.datablock = datablock;
		this.details = details;
		this.entity_id_1 = entity_id_1;
		this.entity_id_2 = entity_id_2;
		this.entity_seq_num_1 = entity_seq_num_1;
		this.entity_seq_num_2 = entity_seq_num_2;
		this.link_id = link_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Entity_link");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entity_id_1 != null)
		{
			sb.append("entity_id_1 = ");
			sb.append(entity_id_1);
			sb.append('\n');
		}
		if (entity_id_2 != null)
		{
			sb.append("entity_id_2 = ");
			sb.append(entity_id_2);
			sb.append('\n');
		}
		if (entity_seq_num_1 != null)
		{
			sb.append("entity_seq_num_1 = ");
			sb.append(entity_seq_num_1);
			sb.append('\n');
		}
		if (entity_seq_num_2 != null)
		{
			sb.append("entity_seq_num_2 = ");
			sb.append(entity_seq_num_2);
			sb.append('\n');
		}
		if (link_id != null)
		{
			sb.append("link_id = ");
			sb.append(link_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		entity_id_1 = null;
		entity_id_2 = null;
		entity_seq_num_1 = null;
		entity_seq_num_2 = null;
		link_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Entity_link)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:entity_link>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entity_id_1 != null) ow.write(indent + " <PDBx:entity_id_1>" + entity_id_1 + "</PDBx:entity_id_1>\n");
			if (entity_id_2 != null) ow.write(indent + " <PDBx:entity_id_2>" + entity_id_2 + "</PDBx:entity_id_2>\n");
			if (entity_seq_num_1 != null) ow.write(indent + " <PDBx:entity_seq_num_1>" + entity_seq_num_1 + "</PDBx:entity_seq_num_1>\n");
			if (entity_seq_num_2 != null) ow.write(indent + " <PDBx:entity_seq_num_2>" + entity_seq_num_2 + "</PDBx:entity_seq_num_2>\n");
			if (link_id != null) ow.write(indent + " <PDBx:link_id>" + link_id + "</PDBx:link_id>\n");
			ow.write(indent + "</PDBx:entity_link>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
