package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the ENTITY_SRC_GEN category record details of
 *  the source from which the entity was obtained in cases
 *  where the source was genetically manipulated.  The
 *  following are treated separately:  items pertaining to the tissue
 *  from which the gene was obtained, items pertaining to the host
 *  organism for gene expression and items pertaining to the actual
 *  producing organism (plasmid).
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entity_src_genCategory>
 *  <PDBx:entity_src_gen entity_id="1">
 *  <PDBx:gene_src_common_name>HIV-1</PDBx:gene_src_common_name>
 *  <PDBx:gene_src_strain>NY-5</PDBx:gene_src_strain>
 *  <PDBx:host_org_common_name>bacteria</PDBx:host_org_common_name>
 *  <PDBx:host_org_genus>Escherichia</PDBx:host_org_genus>
 *  <PDBx:host_org_species>coli</PDBx:host_org_species>
 *  <PDBx:plasmid_name>pB322</PDBx:plasmid_name>
 *  </PDBx:entity_src_gen>
 *  </PDBx:entity_src_genCategory>
 * </pre>
 */
public class Entity_src_gen extends org.pdb.beans.Entity_src_gen implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "entity_src_gen";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Entity_src_gen()
	{
	}

	/** Full constructor */
	public Entity_src_gen(
		Datablock datablock,
		java.lang.String entity_id,
		java.lang.String expression_system_id,
		java.lang.String gene_src_common_name,
		java.lang.String gene_src_details,
		java.lang.String gene_src_dev_stage,
		java.lang.String gene_src_genus,
		java.lang.String gene_src_species,
		java.lang.String gene_src_strain,
		java.lang.String gene_src_tissue,
		java.lang.String gene_src_tissue_fraction,
		java.lang.String host_org_common_name,
		java.lang.String host_org_details,
		java.lang.String host_org_genus,
		java.lang.String host_org_species,
		java.lang.String host_org_strain,
		java.lang.String pdbx_description,
		java.lang.String pdbx_gene_src_atcc,
		java.lang.String pdbx_gene_src_cell,
		java.lang.String pdbx_gene_src_cell_line,
		java.lang.String pdbx_gene_src_cellular_location,
		java.lang.String pdbx_gene_src_fragment,
		java.lang.String pdbx_gene_src_gene,
		java.lang.String pdbx_gene_src_ncbi_taxonomy_id,
		java.lang.String pdbx_gene_src_organ,
		java.lang.String pdbx_gene_src_organelle,
		java.lang.String pdbx_gene_src_plasmid,
		java.lang.String pdbx_gene_src_plasmid_name,
		java.lang.String pdbx_gene_src_scientific_name,
		java.lang.String pdbx_gene_src_variant,
		java.lang.String pdbx_host_org_atcc,
		java.lang.String pdbx_host_org_cell,
		java.lang.String pdbx_host_org_cell_line,
		java.lang.String pdbx_host_org_cellular_location,
		java.lang.String pdbx_host_org_culture_collection,
		java.lang.String pdbx_host_org_gene,
		java.lang.String pdbx_host_org_ncbi_taxonomy_id,
		java.lang.String pdbx_host_org_organ,
		java.lang.String pdbx_host_org_organelle,
		java.lang.String pdbx_host_org_scientific_name,
		java.lang.String pdbx_host_org_strain,
		java.lang.String pdbx_host_org_tissue,
		java.lang.String pdbx_host_org_tissue_fraction,
		java.lang.String pdbx_host_org_variant,
		java.lang.String pdbx_host_org_vector,
		java.lang.String pdbx_host_org_vector_type,
		java.lang.String plasmid_details,
		java.lang.String plasmid_name,
		java.lang.String start_construct_id)
	{
		this.datablock = datablock;
		this.entity_id = entity_id;
		this.expression_system_id = expression_system_id;
		this.gene_src_common_name = gene_src_common_name;
		this.gene_src_details = gene_src_details;
		this.gene_src_dev_stage = gene_src_dev_stage;
		this.gene_src_genus = gene_src_genus;
		this.gene_src_species = gene_src_species;
		this.gene_src_strain = gene_src_strain;
		this.gene_src_tissue = gene_src_tissue;
		this.gene_src_tissue_fraction = gene_src_tissue_fraction;
		this.host_org_common_name = host_org_common_name;
		this.host_org_details = host_org_details;
		this.host_org_genus = host_org_genus;
		this.host_org_species = host_org_species;
		this.host_org_strain = host_org_strain;
		this.pdbx_description = pdbx_description;
		this.pdbx_gene_src_atcc = pdbx_gene_src_atcc;
		this.pdbx_gene_src_cell = pdbx_gene_src_cell;
		this.pdbx_gene_src_cell_line = pdbx_gene_src_cell_line;
		this.pdbx_gene_src_cellular_location = pdbx_gene_src_cellular_location;
		this.pdbx_gene_src_fragment = pdbx_gene_src_fragment;
		this.pdbx_gene_src_gene = pdbx_gene_src_gene;
		this.pdbx_gene_src_ncbi_taxonomy_id = pdbx_gene_src_ncbi_taxonomy_id;
		this.pdbx_gene_src_organ = pdbx_gene_src_organ;
		this.pdbx_gene_src_organelle = pdbx_gene_src_organelle;
		this.pdbx_gene_src_plasmid = pdbx_gene_src_plasmid;
		this.pdbx_gene_src_plasmid_name = pdbx_gene_src_plasmid_name;
		this.pdbx_gene_src_scientific_name = pdbx_gene_src_scientific_name;
		this.pdbx_gene_src_variant = pdbx_gene_src_variant;
		this.pdbx_host_org_atcc = pdbx_host_org_atcc;
		this.pdbx_host_org_cell = pdbx_host_org_cell;
		this.pdbx_host_org_cell_line = pdbx_host_org_cell_line;
		this.pdbx_host_org_cellular_location = pdbx_host_org_cellular_location;
		this.pdbx_host_org_culture_collection = pdbx_host_org_culture_collection;
		this.pdbx_host_org_gene = pdbx_host_org_gene;
		this.pdbx_host_org_ncbi_taxonomy_id = pdbx_host_org_ncbi_taxonomy_id;
		this.pdbx_host_org_organ = pdbx_host_org_organ;
		this.pdbx_host_org_organelle = pdbx_host_org_organelle;
		this.pdbx_host_org_scientific_name = pdbx_host_org_scientific_name;
		this.pdbx_host_org_strain = pdbx_host_org_strain;
		this.pdbx_host_org_tissue = pdbx_host_org_tissue;
		this.pdbx_host_org_tissue_fraction = pdbx_host_org_tissue_fraction;
		this.pdbx_host_org_variant = pdbx_host_org_variant;
		this.pdbx_host_org_vector = pdbx_host_org_vector;
		this.pdbx_host_org_vector_type = pdbx_host_org_vector_type;
		this.plasmid_details = plasmid_details;
		this.plasmid_name = plasmid_name;
		this.start_construct_id = start_construct_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Entity_src_gen");
		sb.append("\n");
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (expression_system_id != null)
		{
			sb.append("expression_system_id = ");
			sb.append(expression_system_id);
			sb.append('\n');
		}
		if (gene_src_common_name != null)
		{
			sb.append("gene_src_common_name = ");
			sb.append(gene_src_common_name);
			sb.append('\n');
		}
		if (gene_src_details != null)
		{
			sb.append("gene_src_details = ");
			sb.append(gene_src_details);
			sb.append('\n');
		}
		if (gene_src_dev_stage != null)
		{
			sb.append("gene_src_dev_stage = ");
			sb.append(gene_src_dev_stage);
			sb.append('\n');
		}
		if (gene_src_genus != null)
		{
			sb.append("gene_src_genus = ");
			sb.append(gene_src_genus);
			sb.append('\n');
		}
		if (gene_src_species != null)
		{
			sb.append("gene_src_species = ");
			sb.append(gene_src_species);
			sb.append('\n');
		}
		if (gene_src_strain != null)
		{
			sb.append("gene_src_strain = ");
			sb.append(gene_src_strain);
			sb.append('\n');
		}
		if (gene_src_tissue != null)
		{
			sb.append("gene_src_tissue = ");
			sb.append(gene_src_tissue);
			sb.append('\n');
		}
		if (gene_src_tissue_fraction != null)
		{
			sb.append("gene_src_tissue_fraction = ");
			sb.append(gene_src_tissue_fraction);
			sb.append('\n');
		}
		if (host_org_common_name != null)
		{
			sb.append("host_org_common_name = ");
			sb.append(host_org_common_name);
			sb.append('\n');
		}
		if (host_org_details != null)
		{
			sb.append("host_org_details = ");
			sb.append(host_org_details);
			sb.append('\n');
		}
		if (host_org_genus != null)
		{
			sb.append("host_org_genus = ");
			sb.append(host_org_genus);
			sb.append('\n');
		}
		if (host_org_species != null)
		{
			sb.append("host_org_species = ");
			sb.append(host_org_species);
			sb.append('\n');
		}
		if (host_org_strain != null)
		{
			sb.append("host_org_strain = ");
			sb.append(host_org_strain);
			sb.append('\n');
		}
		if (pdbx_description != null)
		{
			sb.append("pdbx_description = ");
			sb.append(pdbx_description);
			sb.append('\n');
		}
		if (pdbx_gene_src_atcc != null)
		{
			sb.append("pdbx_gene_src_atcc = ");
			sb.append(pdbx_gene_src_atcc);
			sb.append('\n');
		}
		if (pdbx_gene_src_cell != null)
		{
			sb.append("pdbx_gene_src_cell = ");
			sb.append(pdbx_gene_src_cell);
			sb.append('\n');
		}
		if (pdbx_gene_src_cell_line != null)
		{
			sb.append("pdbx_gene_src_cell_line = ");
			sb.append(pdbx_gene_src_cell_line);
			sb.append('\n');
		}
		if (pdbx_gene_src_cellular_location != null)
		{
			sb.append("pdbx_gene_src_cellular_location = ");
			sb.append(pdbx_gene_src_cellular_location);
			sb.append('\n');
		}
		if (pdbx_gene_src_fragment != null)
		{
			sb.append("pdbx_gene_src_fragment = ");
			sb.append(pdbx_gene_src_fragment);
			sb.append('\n');
		}
		if (pdbx_gene_src_gene != null)
		{
			sb.append("pdbx_gene_src_gene = ");
			sb.append(pdbx_gene_src_gene);
			sb.append('\n');
		}
		if (pdbx_gene_src_ncbi_taxonomy_id != null)
		{
			sb.append("pdbx_gene_src_ncbi_taxonomy_id = ");
			sb.append(pdbx_gene_src_ncbi_taxonomy_id);
			sb.append('\n');
		}
		if (pdbx_gene_src_organ != null)
		{
			sb.append("pdbx_gene_src_organ = ");
			sb.append(pdbx_gene_src_organ);
			sb.append('\n');
		}
		if (pdbx_gene_src_organelle != null)
		{
			sb.append("pdbx_gene_src_organelle = ");
			sb.append(pdbx_gene_src_organelle);
			sb.append('\n');
		}
		if (pdbx_gene_src_plasmid != null)
		{
			sb.append("pdbx_gene_src_plasmid = ");
			sb.append(pdbx_gene_src_plasmid);
			sb.append('\n');
		}
		if (pdbx_gene_src_plasmid_name != null)
		{
			sb.append("pdbx_gene_src_plasmid_name = ");
			sb.append(pdbx_gene_src_plasmid_name);
			sb.append('\n');
		}
		if (pdbx_gene_src_scientific_name != null)
		{
			sb.append("pdbx_gene_src_scientific_name = ");
			sb.append(pdbx_gene_src_scientific_name);
			sb.append('\n');
		}
		if (pdbx_gene_src_variant != null)
		{
			sb.append("pdbx_gene_src_variant = ");
			sb.append(pdbx_gene_src_variant);
			sb.append('\n');
		}
		if (pdbx_host_org_atcc != null)
		{
			sb.append("pdbx_host_org_atcc = ");
			sb.append(pdbx_host_org_atcc);
			sb.append('\n');
		}
		if (pdbx_host_org_cell != null)
		{
			sb.append("pdbx_host_org_cell = ");
			sb.append(pdbx_host_org_cell);
			sb.append('\n');
		}
		if (pdbx_host_org_cell_line != null)
		{
			sb.append("pdbx_host_org_cell_line = ");
			sb.append(pdbx_host_org_cell_line);
			sb.append('\n');
		}
		if (pdbx_host_org_cellular_location != null)
		{
			sb.append("pdbx_host_org_cellular_location = ");
			sb.append(pdbx_host_org_cellular_location);
			sb.append('\n');
		}
		if (pdbx_host_org_culture_collection != null)
		{
			sb.append("pdbx_host_org_culture_collection = ");
			sb.append(pdbx_host_org_culture_collection);
			sb.append('\n');
		}
		if (pdbx_host_org_gene != null)
		{
			sb.append("pdbx_host_org_gene = ");
			sb.append(pdbx_host_org_gene);
			sb.append('\n');
		}
		if (pdbx_host_org_ncbi_taxonomy_id != null)
		{
			sb.append("pdbx_host_org_ncbi_taxonomy_id = ");
			sb.append(pdbx_host_org_ncbi_taxonomy_id);
			sb.append('\n');
		}
		if (pdbx_host_org_organ != null)
		{
			sb.append("pdbx_host_org_organ = ");
			sb.append(pdbx_host_org_organ);
			sb.append('\n');
		}
		if (pdbx_host_org_organelle != null)
		{
			sb.append("pdbx_host_org_organelle = ");
			sb.append(pdbx_host_org_organelle);
			sb.append('\n');
		}
		if (pdbx_host_org_scientific_name != null)
		{
			sb.append("pdbx_host_org_scientific_name = ");
			sb.append(pdbx_host_org_scientific_name);
			sb.append('\n');
		}
		if (pdbx_host_org_strain != null)
		{
			sb.append("pdbx_host_org_strain = ");
			sb.append(pdbx_host_org_strain);
			sb.append('\n');
		}
		if (pdbx_host_org_tissue != null)
		{
			sb.append("pdbx_host_org_tissue = ");
			sb.append(pdbx_host_org_tissue);
			sb.append('\n');
		}
		if (pdbx_host_org_tissue_fraction != null)
		{
			sb.append("pdbx_host_org_tissue_fraction = ");
			sb.append(pdbx_host_org_tissue_fraction);
			sb.append('\n');
		}
		if (pdbx_host_org_variant != null)
		{
			sb.append("pdbx_host_org_variant = ");
			sb.append(pdbx_host_org_variant);
			sb.append('\n');
		}
		if (pdbx_host_org_vector != null)
		{
			sb.append("pdbx_host_org_vector = ");
			sb.append(pdbx_host_org_vector);
			sb.append('\n');
		}
		if (pdbx_host_org_vector_type != null)
		{
			sb.append("pdbx_host_org_vector_type = ");
			sb.append(pdbx_host_org_vector_type);
			sb.append('\n');
		}
		if (plasmid_details != null)
		{
			sb.append("plasmid_details = ");
			sb.append(plasmid_details);
			sb.append('\n');
		}
		if (plasmid_name != null)
		{
			sb.append("plasmid_name = ");
			sb.append(plasmid_name);
			sb.append('\n');
		}
		if (start_construct_id != null)
		{
			sb.append("start_construct_id = ");
			sb.append(start_construct_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		entity_id = null;
		expression_system_id = null;
		gene_src_common_name = null;
		gene_src_details = null;
		gene_src_dev_stage = null;
		gene_src_genus = null;
		gene_src_species = null;
		gene_src_strain = null;
		gene_src_tissue = null;
		gene_src_tissue_fraction = null;
		host_org_common_name = null;
		host_org_details = null;
		host_org_genus = null;
		host_org_species = null;
		host_org_strain = null;
		pdbx_description = null;
		pdbx_gene_src_atcc = null;
		pdbx_gene_src_cell = null;
		pdbx_gene_src_cell_line = null;
		pdbx_gene_src_cellular_location = null;
		pdbx_gene_src_fragment = null;
		pdbx_gene_src_gene = null;
		pdbx_gene_src_ncbi_taxonomy_id = null;
		pdbx_gene_src_organ = null;
		pdbx_gene_src_organelle = null;
		pdbx_gene_src_plasmid = null;
		pdbx_gene_src_plasmid_name = null;
		pdbx_gene_src_scientific_name = null;
		pdbx_gene_src_variant = null;
		pdbx_host_org_atcc = null;
		pdbx_host_org_cell = null;
		pdbx_host_org_cell_line = null;
		pdbx_host_org_cellular_location = null;
		pdbx_host_org_culture_collection = null;
		pdbx_host_org_gene = null;
		pdbx_host_org_ncbi_taxonomy_id = null;
		pdbx_host_org_organ = null;
		pdbx_host_org_organelle = null;
		pdbx_host_org_scientific_name = null;
		pdbx_host_org_strain = null;
		pdbx_host_org_tissue = null;
		pdbx_host_org_tissue_fraction = null;
		pdbx_host_org_variant = null;
		pdbx_host_org_vector = null;
		pdbx_host_org_vector_type = null;
		plasmid_details = null;
		plasmid_name = null;
		start_construct_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Entity_src_gen)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:entity_src_gen>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (expression_system_id != null) ow.write(indent + " <PDBx:expression_system_id>" + expression_system_id + "</PDBx:expression_system_id>\n");
			if (gene_src_common_name != null) ow.write(indent + " <PDBx:gene_src_common_name>" + gene_src_common_name + "</PDBx:gene_src_common_name>\n");
			if (gene_src_details != null) ow.write(indent + " <PDBx:gene_src_details>" + gene_src_details + "</PDBx:gene_src_details>\n");
			if (gene_src_dev_stage != null) ow.write(indent + " <PDBx:gene_src_dev_stage>" + gene_src_dev_stage + "</PDBx:gene_src_dev_stage>\n");
			if (gene_src_genus != null) ow.write(indent + " <PDBx:gene_src_genus>" + gene_src_genus + "</PDBx:gene_src_genus>\n");
			if (gene_src_species != null) ow.write(indent + " <PDBx:gene_src_species>" + gene_src_species + "</PDBx:gene_src_species>\n");
			if (gene_src_strain != null) ow.write(indent + " <PDBx:gene_src_strain>" + gene_src_strain + "</PDBx:gene_src_strain>\n");
			if (gene_src_tissue != null) ow.write(indent + " <PDBx:gene_src_tissue>" + gene_src_tissue + "</PDBx:gene_src_tissue>\n");
			if (gene_src_tissue_fraction != null) ow.write(indent + " <PDBx:gene_src_tissue_fraction>" + gene_src_tissue_fraction + "</PDBx:gene_src_tissue_fraction>\n");
			if (host_org_common_name != null) ow.write(indent + " <PDBx:host_org_common_name>" + host_org_common_name + "</PDBx:host_org_common_name>\n");
			if (host_org_details != null) ow.write(indent + " <PDBx:host_org_details>" + host_org_details + "</PDBx:host_org_details>\n");
			if (host_org_genus != null) ow.write(indent + " <PDBx:host_org_genus>" + host_org_genus + "</PDBx:host_org_genus>\n");
			if (host_org_species != null) ow.write(indent + " <PDBx:host_org_species>" + host_org_species + "</PDBx:host_org_species>\n");
			if (host_org_strain != null) ow.write(indent + " <PDBx:host_org_strain>" + host_org_strain + "</PDBx:host_org_strain>\n");
			if (pdbx_description != null) ow.write(indent + " <PDBx:pdbx_description>" + pdbx_description + "</PDBx:pdbx_description>\n");
			if (pdbx_gene_src_atcc != null) ow.write(indent + " <PDBx:pdbx_gene_src_atcc>" + pdbx_gene_src_atcc + "</PDBx:pdbx_gene_src_atcc>\n");
			if (pdbx_gene_src_cell != null) ow.write(indent + " <PDBx:pdbx_gene_src_cell>" + pdbx_gene_src_cell + "</PDBx:pdbx_gene_src_cell>\n");
			if (pdbx_gene_src_cell_line != null) ow.write(indent + " <PDBx:pdbx_gene_src_cell_line>" + pdbx_gene_src_cell_line + "</PDBx:pdbx_gene_src_cell_line>\n");
			if (pdbx_gene_src_cellular_location != null) ow.write(indent + " <PDBx:pdbx_gene_src_cellular_location>" + pdbx_gene_src_cellular_location + "</PDBx:pdbx_gene_src_cellular_location>\n");
			if (pdbx_gene_src_fragment != null) ow.write(indent + " <PDBx:pdbx_gene_src_fragment>" + pdbx_gene_src_fragment + "</PDBx:pdbx_gene_src_fragment>\n");
			if (pdbx_gene_src_gene != null) ow.write(indent + " <PDBx:pdbx_gene_src_gene>" + pdbx_gene_src_gene + "</PDBx:pdbx_gene_src_gene>\n");
			if (pdbx_gene_src_ncbi_taxonomy_id != null) ow.write(indent + " <PDBx:pdbx_gene_src_ncbi_taxonomy_id>" + pdbx_gene_src_ncbi_taxonomy_id + "</PDBx:pdbx_gene_src_ncbi_taxonomy_id>\n");
			if (pdbx_gene_src_organ != null) ow.write(indent + " <PDBx:pdbx_gene_src_organ>" + pdbx_gene_src_organ + "</PDBx:pdbx_gene_src_organ>\n");
			if (pdbx_gene_src_organelle != null) ow.write(indent + " <PDBx:pdbx_gene_src_organelle>" + pdbx_gene_src_organelle + "</PDBx:pdbx_gene_src_organelle>\n");
			if (pdbx_gene_src_plasmid != null) ow.write(indent + " <PDBx:pdbx_gene_src_plasmid>" + pdbx_gene_src_plasmid + "</PDBx:pdbx_gene_src_plasmid>\n");
			if (pdbx_gene_src_plasmid_name != null) ow.write(indent + " <PDBx:pdbx_gene_src_plasmid_name>" + pdbx_gene_src_plasmid_name + "</PDBx:pdbx_gene_src_plasmid_name>\n");
			if (pdbx_gene_src_scientific_name != null) ow.write(indent + " <PDBx:pdbx_gene_src_scientific_name>" + pdbx_gene_src_scientific_name + "</PDBx:pdbx_gene_src_scientific_name>\n");
			if (pdbx_gene_src_variant != null) ow.write(indent + " <PDBx:pdbx_gene_src_variant>" + pdbx_gene_src_variant + "</PDBx:pdbx_gene_src_variant>\n");
			if (pdbx_host_org_atcc != null) ow.write(indent + " <PDBx:pdbx_host_org_atcc>" + pdbx_host_org_atcc + "</PDBx:pdbx_host_org_atcc>\n");
			if (pdbx_host_org_cell != null) ow.write(indent + " <PDBx:pdbx_host_org_cell>" + pdbx_host_org_cell + "</PDBx:pdbx_host_org_cell>\n");
			if (pdbx_host_org_cell_line != null) ow.write(indent + " <PDBx:pdbx_host_org_cell_line>" + pdbx_host_org_cell_line + "</PDBx:pdbx_host_org_cell_line>\n");
			if (pdbx_host_org_cellular_location != null) ow.write(indent + " <PDBx:pdbx_host_org_cellular_location>" + pdbx_host_org_cellular_location + "</PDBx:pdbx_host_org_cellular_location>\n");
			if (pdbx_host_org_culture_collection != null) ow.write(indent + " <PDBx:pdbx_host_org_culture_collection>" + pdbx_host_org_culture_collection + "</PDBx:pdbx_host_org_culture_collection>\n");
			if (pdbx_host_org_gene != null) ow.write(indent + " <PDBx:pdbx_host_org_gene>" + pdbx_host_org_gene + "</PDBx:pdbx_host_org_gene>\n");
			if (pdbx_host_org_ncbi_taxonomy_id != null) ow.write(indent + " <PDBx:pdbx_host_org_ncbi_taxonomy_id>" + pdbx_host_org_ncbi_taxonomy_id + "</PDBx:pdbx_host_org_ncbi_taxonomy_id>\n");
			if (pdbx_host_org_organ != null) ow.write(indent + " <PDBx:pdbx_host_org_organ>" + pdbx_host_org_organ + "</PDBx:pdbx_host_org_organ>\n");
			if (pdbx_host_org_organelle != null) ow.write(indent + " <PDBx:pdbx_host_org_organelle>" + pdbx_host_org_organelle + "</PDBx:pdbx_host_org_organelle>\n");
			if (pdbx_host_org_scientific_name != null) ow.write(indent + " <PDBx:pdbx_host_org_scientific_name>" + pdbx_host_org_scientific_name + "</PDBx:pdbx_host_org_scientific_name>\n");
			if (pdbx_host_org_strain != null) ow.write(indent + " <PDBx:pdbx_host_org_strain>" + pdbx_host_org_strain + "</PDBx:pdbx_host_org_strain>\n");
			if (pdbx_host_org_tissue != null) ow.write(indent + " <PDBx:pdbx_host_org_tissue>" + pdbx_host_org_tissue + "</PDBx:pdbx_host_org_tissue>\n");
			if (pdbx_host_org_tissue_fraction != null) ow.write(indent + " <PDBx:pdbx_host_org_tissue_fraction>" + pdbx_host_org_tissue_fraction + "</PDBx:pdbx_host_org_tissue_fraction>\n");
			if (pdbx_host_org_variant != null) ow.write(indent + " <PDBx:pdbx_host_org_variant>" + pdbx_host_org_variant + "</PDBx:pdbx_host_org_variant>\n");
			if (pdbx_host_org_vector != null) ow.write(indent + " <PDBx:pdbx_host_org_vector>" + pdbx_host_org_vector + "</PDBx:pdbx_host_org_vector>\n");
			if (pdbx_host_org_vector_type != null) ow.write(indent + " <PDBx:pdbx_host_org_vector_type>" + pdbx_host_org_vector_type + "</PDBx:pdbx_host_org_vector_type>\n");
			if (plasmid_details != null) ow.write(indent + " <PDBx:plasmid_details>" + plasmid_details + "</PDBx:plasmid_details>\n");
			if (plasmid_name != null) ow.write(indent + " <PDBx:plasmid_name>" + plasmid_name + "</PDBx:plasmid_name>\n");
			if (start_construct_id != null) ow.write(indent + " <PDBx:start_construct_id>" + start_construct_id + "</PDBx:start_construct_id>\n");
			ow.write(indent + "</PDBx:entity_src_gen>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
