package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EXPTL_CRYSTAL category record the results of
 *  experimental measurements on the crystal or crystals used,
 *  such as shape, size or density.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for Yb(S-C5H4N)2(THF)4.
 *  <PDBx:exptl_crystalCategory>
 *  <PDBx:exptl_crystal id="xst2l">
 *  <PDBx:colour>pale yellow</PDBx:colour>
 *  <PDBx:density_diffrn>1.113</PDBx:density_diffrn>
 *  <PDBx:density_Matthews>1.01</PDBx:density_Matthews>
 *  <PDBx:density_meas>1.11</PDBx:density_meas>
 *  <PDBx:density_meas_temp>294.5</PDBx:density_meas_temp>
 *  <PDBx:density_method>neutral buoyancy</PDBx:density_method>
 *  <PDBx:density_percent_sol>0.15</PDBx:density_percent_sol>
 *  <PDBx:description>hexagonal rod, uncut</PDBx:description>
 *  <PDBx:F_000>202</PDBx:F_000>
 *  <PDBx:preparation> hanging drop, crystal soaked in 10&#37; ethylene glycol for
 *  10 h, then placed in nylon loop at data collection time</PDBx:preparation>
 *  <PDBx:size_max>0.30</PDBx:size_max>
 *  <PDBx:size_mid>0.20</PDBx:size_mid>
 *  <PDBx:size_min>0.05</PDBx:size_min>
 *  <PDBx:size_rad>0.025</PDBx:size_rad>
 *  </PDBx:exptl_crystal>
 *  </PDBx:exptl_crystalCategory>
 *  
 *  
 *  Example 2 - using separate items to define upper and lower
 *  limits for a value.
 *  <PDBx:exptl_crystalCategory>
 *  <PDBx:exptl_crystal>
 *  <PDBx:density_meas_gt>2.5</PDBx:density_meas_gt>
 *  <PDBx:density_meas_lt>5.0</PDBx:density_meas_lt>
 *  </PDBx:exptl_crystal>
 *  </PDBx:exptl_crystalCategory>
 *  
 *  
 *  Example 3 - here the density was measured at some
 *  unspecified temperature below room temperature.
 *  <PDBx:exptl_crystalCategory>
 *  <PDBx:exptl_crystal>
 *  <PDBx:density_meas_temp_lt>300.</PDBx:density_meas_temp_lt>
 *  </PDBx:exptl_crystal>
 *  </PDBx:exptl_crystalCategory>
 * </pre>
 */
public class Exptl_crystal extends org.pdb.beans.Exptl_crystal implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "exptl_crystal";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Exptl_crystal()
	{
	}

	/** Full constructor */
	public Exptl_crystal(
		Datablock datablock,
		java.lang.Integer F_000,
		java.lang.String colour,
		java.lang.String colour_lustre,
		java.lang.String colour_modifier,
		java.lang.String colour_primary,
		java.lang.Float density_Matthews,
		java.lang.Float density_diffrn,
		java.lang.Float density_meas,
		java.lang.Float density_meas_esd,
		java.lang.Float density_meas_gt,
		java.lang.Float density_meas_lt,
		java.lang.Float density_meas_temp,
		java.lang.Float density_meas_temp_esd,
		java.lang.Float density_meas_temp_gt,
		java.lang.Float density_meas_temp_lt,
		java.lang.String density_method,
		java.lang.Float density_percent_sol,
		java.lang.String description,
		java.lang.String id_,
		java.lang.String pdbx_crystal_image_format,
		java.lang.String pdbx_crystal_image_url,
		java.lang.String preparation,
		java.lang.Float size_max,
		java.lang.Float size_mid,
		java.lang.Float size_min,
		java.lang.Float size_rad)
	{
		this.datablock = datablock;
		this.F_000 = F_000;
		this.colour = colour;
		this.colour_lustre = colour_lustre;
		this.colour_modifier = colour_modifier;
		this.colour_primary = colour_primary;
		this.density_Matthews = density_Matthews;
		this.density_diffrn = density_diffrn;
		this.density_meas = density_meas;
		this.density_meas_esd = density_meas_esd;
		this.density_meas_gt = density_meas_gt;
		this.density_meas_lt = density_meas_lt;
		this.density_meas_temp = density_meas_temp;
		this.density_meas_temp_esd = density_meas_temp_esd;
		this.density_meas_temp_gt = density_meas_temp_gt;
		this.density_meas_temp_lt = density_meas_temp_lt;
		this.density_method = density_method;
		this.density_percent_sol = density_percent_sol;
		this.description = description;
		this.id_ = id_;
		this.pdbx_crystal_image_format = pdbx_crystal_image_format;
		this.pdbx_crystal_image_url = pdbx_crystal_image_url;
		this.preparation = preparation;
		this.size_max = size_max;
		this.size_mid = size_mid;
		this.size_min = size_min;
		this.size_rad = size_rad;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Exptl_crystal");
		sb.append("\n");
		if (F_000 != null)
		{
			sb.append("F_000 = ");
			sb.append(F_000);
			sb.append('\n');
		}
		if (colour != null)
		{
			sb.append("colour = ");
			sb.append(colour);
			sb.append('\n');
		}
		if (colour_lustre != null)
		{
			sb.append("colour_lustre = ");
			sb.append(colour_lustre);
			sb.append('\n');
		}
		if (colour_modifier != null)
		{
			sb.append("colour_modifier = ");
			sb.append(colour_modifier);
			sb.append('\n');
		}
		if (colour_primary != null)
		{
			sb.append("colour_primary = ");
			sb.append(colour_primary);
			sb.append('\n');
		}
		if (density_Matthews != null)
		{
			sb.append("density_Matthews = ");
			sb.append(density_Matthews);
			sb.append('\n');
		}
		if (density_diffrn != null)
		{
			sb.append("density_diffrn = ");
			sb.append(density_diffrn);
			sb.append('\n');
		}
		if (density_meas != null)
		{
			sb.append("density_meas = ");
			sb.append(density_meas);
			sb.append('\n');
		}
		if (density_meas_esd != null)
		{
			sb.append("density_meas_esd = ");
			sb.append(density_meas_esd);
			sb.append('\n');
		}
		if (density_meas_gt != null)
		{
			sb.append("density_meas_gt = ");
			sb.append(density_meas_gt);
			sb.append('\n');
		}
		if (density_meas_lt != null)
		{
			sb.append("density_meas_lt = ");
			sb.append(density_meas_lt);
			sb.append('\n');
		}
		if (density_meas_temp != null)
		{
			sb.append("density_meas_temp = ");
			sb.append(density_meas_temp);
			sb.append('\n');
		}
		if (density_meas_temp_esd != null)
		{
			sb.append("density_meas_temp_esd = ");
			sb.append(density_meas_temp_esd);
			sb.append('\n');
		}
		if (density_meas_temp_gt != null)
		{
			sb.append("density_meas_temp_gt = ");
			sb.append(density_meas_temp_gt);
			sb.append('\n');
		}
		if (density_meas_temp_lt != null)
		{
			sb.append("density_meas_temp_lt = ");
			sb.append(density_meas_temp_lt);
			sb.append('\n');
		}
		if (density_method != null)
		{
			sb.append("density_method = ");
			sb.append(density_method);
			sb.append('\n');
		}
		if (density_percent_sol != null)
		{
			sb.append("density_percent_sol = ");
			sb.append(density_percent_sol);
			sb.append('\n');
		}
		if (description != null)
		{
			sb.append("description = ");
			sb.append(description);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (pdbx_crystal_image_format != null)
		{
			sb.append("pdbx_crystal_image_format = ");
			sb.append(pdbx_crystal_image_format);
			sb.append('\n');
		}
		if (pdbx_crystal_image_url != null)
		{
			sb.append("pdbx_crystal_image_url = ");
			sb.append(pdbx_crystal_image_url);
			sb.append('\n');
		}
		if (preparation != null)
		{
			sb.append("preparation = ");
			sb.append(preparation);
			sb.append('\n');
		}
		if (size_max != null)
		{
			sb.append("size_max = ");
			sb.append(size_max);
			sb.append('\n');
		}
		if (size_mid != null)
		{
			sb.append("size_mid = ");
			sb.append(size_mid);
			sb.append('\n');
		}
		if (size_min != null)
		{
			sb.append("size_min = ");
			sb.append(size_min);
			sb.append('\n');
		}
		if (size_rad != null)
		{
			sb.append("size_rad = ");
			sb.append(size_rad);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		F_000 = null;
		colour = null;
		colour_lustre = null;
		colour_modifier = null;
		colour_primary = null;
		density_Matthews = null;
		density_diffrn = null;
		density_meas = null;
		density_meas_esd = null;
		density_meas_gt = null;
		density_meas_lt = null;
		density_meas_temp = null;
		density_meas_temp_esd = null;
		density_meas_temp_gt = null;
		density_meas_temp_lt = null;
		density_method = null;
		density_percent_sol = null;
		description = null;
		id_ = null;
		pdbx_crystal_image_format = null;
		pdbx_crystal_image_url = null;
		preparation = null;
		size_max = null;
		size_mid = null;
		size_min = null;
		size_rad = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Exptl_crystal)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:exptl_crystal>\n");
			if (F_000 != null) ow.write(indent + " <PDBx:F_000>" + F_000 + "</PDBx:F_000>\n");
			if (colour != null) ow.write(indent + " <PDBx:colour>" + colour + "</PDBx:colour>\n");
			if (colour_lustre != null) ow.write(indent + " <PDBx:colour_lustre>" + colour_lustre + "</PDBx:colour_lustre>\n");
			if (colour_modifier != null) ow.write(indent + " <PDBx:colour_modifier>" + colour_modifier + "</PDBx:colour_modifier>\n");
			if (colour_primary != null) ow.write(indent + " <PDBx:colour_primary>" + colour_primary + "</PDBx:colour_primary>\n");
			if (density_Matthews != null) ow.write(indent + " <PDBx:density_Matthews>" + density_Matthews + "</PDBx:density_Matthews>\n");
			if (density_diffrn != null) ow.write(indent + " <PDBx:density_diffrn>" + density_diffrn + "</PDBx:density_diffrn>\n");
			if (density_meas != null) ow.write(indent + " <PDBx:density_meas>" + density_meas + "</PDBx:density_meas>\n");
			if (density_meas_esd != null) ow.write(indent + " <PDBx:density_meas_esd>" + density_meas_esd + "</PDBx:density_meas_esd>\n");
			if (density_meas_gt != null) ow.write(indent + " <PDBx:density_meas_gt>" + density_meas_gt + "</PDBx:density_meas_gt>\n");
			if (density_meas_lt != null) ow.write(indent + " <PDBx:density_meas_lt>" + density_meas_lt + "</PDBx:density_meas_lt>\n");
			if (density_meas_temp != null) ow.write(indent + " <PDBx:density_meas_temp>" + density_meas_temp + "</PDBx:density_meas_temp>\n");
			if (density_meas_temp_esd != null) ow.write(indent + " <PDBx:density_meas_temp_esd>" + density_meas_temp_esd + "</PDBx:density_meas_temp_esd>\n");
			if (density_meas_temp_gt != null) ow.write(indent + " <PDBx:density_meas_temp_gt>" + density_meas_temp_gt + "</PDBx:density_meas_temp_gt>\n");
			if (density_meas_temp_lt != null) ow.write(indent + " <PDBx:density_meas_temp_lt>" + density_meas_temp_lt + "</PDBx:density_meas_temp_lt>\n");
			if (density_method != null) ow.write(indent + " <PDBx:density_method>" + density_method + "</PDBx:density_method>\n");
			if (density_percent_sol != null) ow.write(indent + " <PDBx:density_percent_sol>" + density_percent_sol + "</PDBx:density_percent_sol>\n");
			if (description != null) ow.write(indent + " <PDBx:description>" + description + "</PDBx:description>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (pdbx_crystal_image_format != null) ow.write(indent + " <PDBx:pdbx_crystal_image_format>" + pdbx_crystal_image_format + "</PDBx:pdbx_crystal_image_format>\n");
			if (pdbx_crystal_image_url != null) ow.write(indent + " <PDBx:pdbx_crystal_image_url>" + pdbx_crystal_image_url + "</PDBx:pdbx_crystal_image_url>\n");
			if (preparation != null) ow.write(indent + " <PDBx:preparation>" + preparation + "</PDBx:preparation>\n");
			if (size_max != null) ow.write(indent + " <PDBx:size_max>" + size_max + "</PDBx:size_max>\n");
			if (size_mid != null) ow.write(indent + " <PDBx:size_mid>" + size_mid + "</PDBx:size_mid>\n");
			if (size_min != null) ow.write(indent + " <PDBx:size_min>" + size_min + "</PDBx:size_min>\n");
			if (size_rad != null) ow.write(indent + " <PDBx:size_rad>" + size_rad + "</PDBx:size_rad>\n");
			ow.write(indent + "</PDBx:exptl_crystal>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
