package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the GEOM and related (GEOM_ANGLE,
 *  GEOM_BOND, GEOM_CONTACT, GEOM_HBOND and GEOM_TORSION)
 *  categories record details about the molecular
 *  geometry as calculated from the contents of the ATOM, CELL
 *  and SYMMETRY data.
 *  
 *  Geometry data are therefore redundant, in that they can be
 *  calculated from other more fundamental quantities in the data
 *  block. However, they provide a check on the correctness of
 *  both sets of data and enable the most important geometric data
 *  to be identified for publication by setting the appropriate
 *  publication flag.
 */
public class Geom extends org.pdb.beans.Geom implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "geom";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Geom()
	{
	}

	/** Full constructor */
	public Geom(
		Datablock datablock,
		java.lang.String details,
		java.lang.String entry_id)
	{
		this.datablock = datablock;
		this.details = details;
		this.entry_id = entry_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Geom");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		entry_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Geom)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:geom>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			ow.write(indent + "</PDBx:geom>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
