package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the GEOM_BOND category record details about
 *  the bond lengths as calculated from the contents
 *  of the ATOM, CELL and SYMMETRY data.
 *  
 * <pre>
 *  Example 1 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:geom_bondCategory>
 *  <PDBx:geom_bond atom_site_id_1="O1" atom_site_id_2="C2" site_symmetry_1="1_555" site_symmetry_2="1_555">
 *  <PDBx:dist>1.342</PDBx:dist>
 *  <PDBx:dist_esd>0.004</PDBx:dist_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_bond>
 *  <PDBx:geom_bond atom_site_id_1="O1" atom_site_id_2="C5" site_symmetry_1="1_555" site_symmetry_2="1_555">
 *  <PDBx:dist>1.439</PDBx:dist>
 *  <PDBx:dist_esd>0.003</PDBx:dist_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_bond>
 *  <PDBx:geom_bond atom_site_id_1="C2" atom_site_id_2="C3" site_symmetry_1="1_555" site_symmetry_2="1_555">
 *  <PDBx:dist>1.512</PDBx:dist>
 *  <PDBx:dist_esd>0.004</PDBx:dist_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_bond>
 *  <PDBx:geom_bond atom_site_id_1="C2" atom_site_id_2="O21" site_symmetry_1="1_555" site_symmetry_2="1_555">
 *  <PDBx:dist>1.199</PDBx:dist>
 *  <PDBx:dist_esd>0.004</PDBx:dist_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_bond>
 *  <PDBx:geom_bond atom_site_id_1="C3" atom_site_id_2="N4" site_symmetry_1="1_555" site_symmetry_2="1_555">
 *  <PDBx:dist>1.465</PDBx:dist>
 *  <PDBx:dist_esd>0.003</PDBx:dist_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_bond>
 *  <PDBx:geom_bond atom_site_id_1="C3" atom_site_id_2="C31" site_symmetry_1="1_555" site_symmetry_2="1_555">
 *  <PDBx:dist>1.537</PDBx:dist>
 *  <PDBx:dist_esd>0.004</PDBx:dist_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_bond>
 *  <PDBx:geom_bond atom_site_id_1="C3" atom_site_id_2="H3" site_symmetry_1="1_555" site_symmetry_2="1_555">
 *  <PDBx:dist>1.00</PDBx:dist>
 *  <PDBx:dist_esd>0.03</PDBx:dist_esd>
 *  <PDBx:publ_flag>no</PDBx:publ_flag>
 *  </PDBx:geom_bond>
 *  <PDBx:geom_bond atom_site_id_1="N4" atom_site_id_2="C5" site_symmetry_1="1_555" site_symmetry_2="1_555">
 *  <PDBx:dist>1.472</PDBx:dist>
 *  <PDBx:dist_esd>0.003</PDBx:dist_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_bond>
 *  </PDBx:geom_bondCategory>
 * </pre>
 */
public class Geom_bond extends org.pdb.beans.Geom_bond implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "geom_bond";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Geom_bond()
	{
	}

	/** Full constructor */
	public Geom_bond(
		Datablock datablock,
		java.lang.String atom_site_auth_asym_id_1,
		java.lang.String atom_site_auth_asym_id_2,
		java.lang.String atom_site_auth_atom_id_1,
		java.lang.String atom_site_auth_atom_id_2,
		java.lang.String atom_site_auth_comp_id_1,
		java.lang.String atom_site_auth_comp_id_2,
		java.lang.String atom_site_auth_seq_id_1,
		java.lang.String atom_site_auth_seq_id_2,
		java.lang.String atom_site_id_1,
		java.lang.String atom_site_id_2,
		java.lang.String atom_site_label_alt_id_1,
		java.lang.String atom_site_label_alt_id_2,
		java.lang.String atom_site_label_asym_id_1,
		java.lang.String atom_site_label_asym_id_2,
		java.lang.String atom_site_label_atom_id_1,
		java.lang.String atom_site_label_atom_id_2,
		java.lang.String atom_site_label_comp_id_1,
		java.lang.String atom_site_label_comp_id_2,
		java.lang.Integer atom_site_label_seq_id_1,
		java.lang.Integer atom_site_label_seq_id_2,
		java.lang.Float dist,
		java.lang.Float dist_esd,
		java.lang.Integer pdbx_PDB_model_num,
		java.lang.String pdbx_atom_site_PDB_ins_code_1,
		java.lang.String pdbx_atom_site_PDB_ins_code_2,
		java.lang.String publ_flag,
		java.lang.String site_symmetry_1,
		java.lang.String site_symmetry_2,
		java.lang.Integer valence)
	{
		this.datablock = datablock;
		this.atom_site_auth_asym_id_1 = atom_site_auth_asym_id_1;
		this.atom_site_auth_asym_id_2 = atom_site_auth_asym_id_2;
		this.atom_site_auth_atom_id_1 = atom_site_auth_atom_id_1;
		this.atom_site_auth_atom_id_2 = atom_site_auth_atom_id_2;
		this.atom_site_auth_comp_id_1 = atom_site_auth_comp_id_1;
		this.atom_site_auth_comp_id_2 = atom_site_auth_comp_id_2;
		this.atom_site_auth_seq_id_1 = atom_site_auth_seq_id_1;
		this.atom_site_auth_seq_id_2 = atom_site_auth_seq_id_2;
		this.atom_site_id_1 = atom_site_id_1;
		this.atom_site_id_2 = atom_site_id_2;
		this.atom_site_label_alt_id_1 = atom_site_label_alt_id_1;
		this.atom_site_label_alt_id_2 = atom_site_label_alt_id_2;
		this.atom_site_label_asym_id_1 = atom_site_label_asym_id_1;
		this.atom_site_label_asym_id_2 = atom_site_label_asym_id_2;
		this.atom_site_label_atom_id_1 = atom_site_label_atom_id_1;
		this.atom_site_label_atom_id_2 = atom_site_label_atom_id_2;
		this.atom_site_label_comp_id_1 = atom_site_label_comp_id_1;
		this.atom_site_label_comp_id_2 = atom_site_label_comp_id_2;
		this.atom_site_label_seq_id_1 = atom_site_label_seq_id_1;
		this.atom_site_label_seq_id_2 = atom_site_label_seq_id_2;
		this.dist = dist;
		this.dist_esd = dist_esd;
		this.pdbx_PDB_model_num = pdbx_PDB_model_num;
		this.pdbx_atom_site_PDB_ins_code_1 = pdbx_atom_site_PDB_ins_code_1;
		this.pdbx_atom_site_PDB_ins_code_2 = pdbx_atom_site_PDB_ins_code_2;
		this.publ_flag = publ_flag;
		this.site_symmetry_1 = site_symmetry_1;
		this.site_symmetry_2 = site_symmetry_2;
		this.valence = valence;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Geom_bond");
		sb.append("\n");
		if (atom_site_auth_asym_id_1 != null)
		{
			sb.append("atom_site_auth_asym_id_1 = ");
			sb.append(atom_site_auth_asym_id_1);
			sb.append('\n');
		}
		if (atom_site_auth_asym_id_2 != null)
		{
			sb.append("atom_site_auth_asym_id_2 = ");
			sb.append(atom_site_auth_asym_id_2);
			sb.append('\n');
		}
		if (atom_site_auth_atom_id_1 != null)
		{
			sb.append("atom_site_auth_atom_id_1 = ");
			sb.append(atom_site_auth_atom_id_1);
			sb.append('\n');
		}
		if (atom_site_auth_atom_id_2 != null)
		{
			sb.append("atom_site_auth_atom_id_2 = ");
			sb.append(atom_site_auth_atom_id_2);
			sb.append('\n');
		}
		if (atom_site_auth_comp_id_1 != null)
		{
			sb.append("atom_site_auth_comp_id_1 = ");
			sb.append(atom_site_auth_comp_id_1);
			sb.append('\n');
		}
		if (atom_site_auth_comp_id_2 != null)
		{
			sb.append("atom_site_auth_comp_id_2 = ");
			sb.append(atom_site_auth_comp_id_2);
			sb.append('\n');
		}
		if (atom_site_auth_seq_id_1 != null)
		{
			sb.append("atom_site_auth_seq_id_1 = ");
			sb.append(atom_site_auth_seq_id_1);
			sb.append('\n');
		}
		if (atom_site_auth_seq_id_2 != null)
		{
			sb.append("atom_site_auth_seq_id_2 = ");
			sb.append(atom_site_auth_seq_id_2);
			sb.append('\n');
		}
		if (atom_site_id_1 != null)
		{
			sb.append("atom_site_id_1 = ");
			sb.append(atom_site_id_1);
			sb.append('\n');
		}
		if (atom_site_id_2 != null)
		{
			sb.append("atom_site_id_2 = ");
			sb.append(atom_site_id_2);
			sb.append('\n');
		}
		if (atom_site_label_alt_id_1 != null)
		{
			sb.append("atom_site_label_alt_id_1 = ");
			sb.append(atom_site_label_alt_id_1);
			sb.append('\n');
		}
		if (atom_site_label_alt_id_2 != null)
		{
			sb.append("atom_site_label_alt_id_2 = ");
			sb.append(atom_site_label_alt_id_2);
			sb.append('\n');
		}
		if (atom_site_label_asym_id_1 != null)
		{
			sb.append("atom_site_label_asym_id_1 = ");
			sb.append(atom_site_label_asym_id_1);
			sb.append('\n');
		}
		if (atom_site_label_asym_id_2 != null)
		{
			sb.append("atom_site_label_asym_id_2 = ");
			sb.append(atom_site_label_asym_id_2);
			sb.append('\n');
		}
		if (atom_site_label_atom_id_1 != null)
		{
			sb.append("atom_site_label_atom_id_1 = ");
			sb.append(atom_site_label_atom_id_1);
			sb.append('\n');
		}
		if (atom_site_label_atom_id_2 != null)
		{
			sb.append("atom_site_label_atom_id_2 = ");
			sb.append(atom_site_label_atom_id_2);
			sb.append('\n');
		}
		if (atom_site_label_comp_id_1 != null)
		{
			sb.append("atom_site_label_comp_id_1 = ");
			sb.append(atom_site_label_comp_id_1);
			sb.append('\n');
		}
		if (atom_site_label_comp_id_2 != null)
		{
			sb.append("atom_site_label_comp_id_2 = ");
			sb.append(atom_site_label_comp_id_2);
			sb.append('\n');
		}
		if (atom_site_label_seq_id_1 != null)
		{
			sb.append("atom_site_label_seq_id_1 = ");
			sb.append(atom_site_label_seq_id_1);
			sb.append('\n');
		}
		if (atom_site_label_seq_id_2 != null)
		{
			sb.append("atom_site_label_seq_id_2 = ");
			sb.append(atom_site_label_seq_id_2);
			sb.append('\n');
		}
		if (dist != null)
		{
			sb.append("dist = ");
			sb.append(dist);
			sb.append('\n');
		}
		if (dist_esd != null)
		{
			sb.append("dist_esd = ");
			sb.append(dist_esd);
			sb.append('\n');
		}
		if (pdbx_PDB_model_num != null)
		{
			sb.append("pdbx_PDB_model_num = ");
			sb.append(pdbx_PDB_model_num);
			sb.append('\n');
		}
		if (pdbx_atom_site_PDB_ins_code_1 != null)
		{
			sb.append("pdbx_atom_site_PDB_ins_code_1 = ");
			sb.append(pdbx_atom_site_PDB_ins_code_1);
			sb.append('\n');
		}
		if (pdbx_atom_site_PDB_ins_code_2 != null)
		{
			sb.append("pdbx_atom_site_PDB_ins_code_2 = ");
			sb.append(pdbx_atom_site_PDB_ins_code_2);
			sb.append('\n');
		}
		if (publ_flag != null)
		{
			sb.append("publ_flag = ");
			sb.append(publ_flag);
			sb.append('\n');
		}
		if (site_symmetry_1 != null)
		{
			sb.append("site_symmetry_1 = ");
			sb.append(site_symmetry_1);
			sb.append('\n');
		}
		if (site_symmetry_2 != null)
		{
			sb.append("site_symmetry_2 = ");
			sb.append(site_symmetry_2);
			sb.append('\n');
		}
		if (valence != null)
		{
			sb.append("valence = ");
			sb.append(valence);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		atom_site_auth_asym_id_1 = null;
		atom_site_auth_asym_id_2 = null;
		atom_site_auth_atom_id_1 = null;
		atom_site_auth_atom_id_2 = null;
		atom_site_auth_comp_id_1 = null;
		atom_site_auth_comp_id_2 = null;
		atom_site_auth_seq_id_1 = null;
		atom_site_auth_seq_id_2 = null;
		atom_site_id_1 = null;
		atom_site_id_2 = null;
		atom_site_label_alt_id_1 = null;
		atom_site_label_alt_id_2 = null;
		atom_site_label_asym_id_1 = null;
		atom_site_label_asym_id_2 = null;
		atom_site_label_atom_id_1 = null;
		atom_site_label_atom_id_2 = null;
		atom_site_label_comp_id_1 = null;
		atom_site_label_comp_id_2 = null;
		atom_site_label_seq_id_1 = null;
		atom_site_label_seq_id_2 = null;
		dist = null;
		dist_esd = null;
		pdbx_PDB_model_num = null;
		pdbx_atom_site_PDB_ins_code_1 = null;
		pdbx_atom_site_PDB_ins_code_2 = null;
		publ_flag = null;
		site_symmetry_1 = null;
		site_symmetry_2 = null;
		valence = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Geom_bond)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:geom_bond>\n");
			if (atom_site_auth_asym_id_1 != null) ow.write(indent + " <PDBx:atom_site_auth_asym_id_1>" + atom_site_auth_asym_id_1 + "</PDBx:atom_site_auth_asym_id_1>\n");
			if (atom_site_auth_asym_id_2 != null) ow.write(indent + " <PDBx:atom_site_auth_asym_id_2>" + atom_site_auth_asym_id_2 + "</PDBx:atom_site_auth_asym_id_2>\n");
			if (atom_site_auth_atom_id_1 != null) ow.write(indent + " <PDBx:atom_site_auth_atom_id_1>" + atom_site_auth_atom_id_1 + "</PDBx:atom_site_auth_atom_id_1>\n");
			if (atom_site_auth_atom_id_2 != null) ow.write(indent + " <PDBx:atom_site_auth_atom_id_2>" + atom_site_auth_atom_id_2 + "</PDBx:atom_site_auth_atom_id_2>\n");
			if (atom_site_auth_comp_id_1 != null) ow.write(indent + " <PDBx:atom_site_auth_comp_id_1>" + atom_site_auth_comp_id_1 + "</PDBx:atom_site_auth_comp_id_1>\n");
			if (atom_site_auth_comp_id_2 != null) ow.write(indent + " <PDBx:atom_site_auth_comp_id_2>" + atom_site_auth_comp_id_2 + "</PDBx:atom_site_auth_comp_id_2>\n");
			if (atom_site_auth_seq_id_1 != null) ow.write(indent + " <PDBx:atom_site_auth_seq_id_1>" + atom_site_auth_seq_id_1 + "</PDBx:atom_site_auth_seq_id_1>\n");
			if (atom_site_auth_seq_id_2 != null) ow.write(indent + " <PDBx:atom_site_auth_seq_id_2>" + atom_site_auth_seq_id_2 + "</PDBx:atom_site_auth_seq_id_2>\n");
			if (atom_site_id_1 != null) ow.write(indent + " <PDBx:atom_site_id_1>" + atom_site_id_1 + "</PDBx:atom_site_id_1>\n");
			if (atom_site_id_2 != null) ow.write(indent + " <PDBx:atom_site_id_2>" + atom_site_id_2 + "</PDBx:atom_site_id_2>\n");
			if (atom_site_label_alt_id_1 != null) ow.write(indent + " <PDBx:atom_site_label_alt_id_1>" + atom_site_label_alt_id_1 + "</PDBx:atom_site_label_alt_id_1>\n");
			if (atom_site_label_alt_id_2 != null) ow.write(indent + " <PDBx:atom_site_label_alt_id_2>" + atom_site_label_alt_id_2 + "</PDBx:atom_site_label_alt_id_2>\n");
			if (atom_site_label_asym_id_1 != null) ow.write(indent + " <PDBx:atom_site_label_asym_id_1>" + atom_site_label_asym_id_1 + "</PDBx:atom_site_label_asym_id_1>\n");
			if (atom_site_label_asym_id_2 != null) ow.write(indent + " <PDBx:atom_site_label_asym_id_2>" + atom_site_label_asym_id_2 + "</PDBx:atom_site_label_asym_id_2>\n");
			if (atom_site_label_atom_id_1 != null) ow.write(indent + " <PDBx:atom_site_label_atom_id_1>" + atom_site_label_atom_id_1 + "</PDBx:atom_site_label_atom_id_1>\n");
			if (atom_site_label_atom_id_2 != null) ow.write(indent + " <PDBx:atom_site_label_atom_id_2>" + atom_site_label_atom_id_2 + "</PDBx:atom_site_label_atom_id_2>\n");
			if (atom_site_label_comp_id_1 != null) ow.write(indent + " <PDBx:atom_site_label_comp_id_1>" + atom_site_label_comp_id_1 + "</PDBx:atom_site_label_comp_id_1>\n");
			if (atom_site_label_comp_id_2 != null) ow.write(indent + " <PDBx:atom_site_label_comp_id_2>" + atom_site_label_comp_id_2 + "</PDBx:atom_site_label_comp_id_2>\n");
			if (atom_site_label_seq_id_1 != null) ow.write(indent + " <PDBx:atom_site_label_seq_id_1>" + atom_site_label_seq_id_1 + "</PDBx:atom_site_label_seq_id_1>\n");
			if (atom_site_label_seq_id_2 != null) ow.write(indent + " <PDBx:atom_site_label_seq_id_2>" + atom_site_label_seq_id_2 + "</PDBx:atom_site_label_seq_id_2>\n");
			if (dist != null) ow.write(indent + " <PDBx:dist>" + dist + "</PDBx:dist>\n");
			if (dist_esd != null) ow.write(indent + " <PDBx:dist_esd>" + dist_esd + "</PDBx:dist_esd>\n");
			if (pdbx_PDB_model_num != null) ow.write(indent + " <PDBx:pdbx_PDB_model_num>" + pdbx_PDB_model_num + "</PDBx:pdbx_PDB_model_num>\n");
			if (pdbx_atom_site_PDB_ins_code_1 != null) ow.write(indent + " <PDBx:pdbx_atom_site_PDB_ins_code_1>" + pdbx_atom_site_PDB_ins_code_1 + "</PDBx:pdbx_atom_site_PDB_ins_code_1>\n");
			if (pdbx_atom_site_PDB_ins_code_2 != null) ow.write(indent + " <PDBx:pdbx_atom_site_PDB_ins_code_2>" + pdbx_atom_site_PDB_ins_code_2 + "</PDBx:pdbx_atom_site_PDB_ins_code_2>\n");
			if (publ_flag != null) ow.write(indent + " <PDBx:publ_flag>" + publ_flag + "</PDBx:publ_flag>\n");
			if (site_symmetry_1 != null) ow.write(indent + " <PDBx:site_symmetry_1>" + site_symmetry_1 + "</PDBx:site_symmetry_1>\n");
			if (site_symmetry_2 != null) ow.write(indent + " <PDBx:site_symmetry_2>" + site_symmetry_2 + "</PDBx:site_symmetry_2>\n");
			if (valence != null) ow.write(indent + " <PDBx:valence>" + valence + "</PDBx:valence>\n");
			ow.write(indent + "</PDBx:geom_bond>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
