package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the GEOM_HBOND category record details about
 *  hydrogen bonds as calculated from the contents of the ATOM,
 *  CELL and SYMMETRY data.
 *  
 * <pre>
 *  Example 1 - based on C~14~H~13~ClN~2~O.H~2~O, reported by Palmer,
 *  Puddle & Lisgarten [Acta Cryst. (1993), C49, 1777-1779].
 *  <PDBx:geom_hbondCategory>
 *  <PDBx:geom_hbond atom_site_id_D="N6" atom_site_id_H="HN6" atom_site_id_A="OW">
 *  <PDBx:dist_DH>0.888</PDBx:dist_DH>
 *  <PDBx:dist_HA>1.921</PDBx:dist_HA>
 *  <PDBx:dist_DA>2.801</PDBx:dist_DA>
 *  <PDBx:angle_DHA>169.6</PDBx:angle_DHA>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_hbond>
 *  <PDBx:geom_hbond atom_site_id_D="OW" atom_site_id_H="HO2" atom_site_id_A="O7">
 *  <PDBx:dist_DH>0.917</PDBx:dist_DH>
 *  <PDBx:dist_HA>1.923</PDBx:dist_HA>
 *  <PDBx:dist_DA>2.793</PDBx:dist_DA>
 *  <PDBx:angle_DHA>153.5</PDBx:angle_DHA>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_hbond>
 *  <PDBx:geom_hbond atom_site_id_D="OW" atom_site_id_H="HO1" atom_site_id_A="N10">
 *  <PDBx:dist_DH>0.894</PDBx:dist_DH>
 *  <PDBx:dist_HA>1.886</PDBx:dist_HA>
 *  <PDBx:dist_DA>2.842</PDBx:dist_DA>
 *  <PDBx:angle_DHA>179.7</PDBx:angle_DHA>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_hbond>
 *  </PDBx:geom_hbondCategory>
 * </pre>
 */
public class Geom_hbond extends org.pdb.beans.Geom_hbond implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "geom_hbond";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Geom_hbond()
	{
	}

	/** Full constructor */
	public Geom_hbond(
		Datablock datablock,
		java.lang.Float angle_DHA,
		java.lang.Float angle_DHA_esd,
		java.lang.String atom_site_auth_asym_id_A,
		java.lang.String atom_site_auth_asym_id_D,
		java.lang.String atom_site_auth_asym_id_H,
		java.lang.String atom_site_auth_atom_id_A,
		java.lang.String atom_site_auth_atom_id_D,
		java.lang.String atom_site_auth_atom_id_H,
		java.lang.String atom_site_auth_comp_id_A,
		java.lang.String atom_site_auth_comp_id_D,
		java.lang.String atom_site_auth_comp_id_H,
		java.lang.String atom_site_auth_seq_id_A,
		java.lang.String atom_site_auth_seq_id_D,
		java.lang.String atom_site_auth_seq_id_H,
		java.lang.String atom_site_id_A,
		java.lang.String atom_site_id_D,
		java.lang.String atom_site_id_H,
		java.lang.String atom_site_label_alt_id_A,
		java.lang.String atom_site_label_alt_id_D,
		java.lang.String atom_site_label_alt_id_H,
		java.lang.String atom_site_label_asym_id_A,
		java.lang.String atom_site_label_asym_id_D,
		java.lang.String atom_site_label_asym_id_H,
		java.lang.String atom_site_label_atom_id_A,
		java.lang.String atom_site_label_atom_id_D,
		java.lang.String atom_site_label_atom_id_H,
		java.lang.String atom_site_label_comp_id_A,
		java.lang.String atom_site_label_comp_id_D,
		java.lang.String atom_site_label_comp_id_H,
		java.lang.Integer atom_site_label_seq_id_A,
		java.lang.Integer atom_site_label_seq_id_D,
		java.lang.Integer atom_site_label_seq_id_H,
		java.lang.Float dist_DA,
		java.lang.Float dist_DA_esd,
		java.lang.Float dist_DH,
		java.lang.Float dist_DH_esd,
		java.lang.Float dist_HA,
		java.lang.Float dist_HA_esd,
		java.lang.String publ_flag,
		java.lang.String site_symmetry_A,
		java.lang.String site_symmetry_D,
		java.lang.String site_symmetry_H)
	{
		this.datablock = datablock;
		this.angle_DHA = angle_DHA;
		this.angle_DHA_esd = angle_DHA_esd;
		this.atom_site_auth_asym_id_A = atom_site_auth_asym_id_A;
		this.atom_site_auth_asym_id_D = atom_site_auth_asym_id_D;
		this.atom_site_auth_asym_id_H = atom_site_auth_asym_id_H;
		this.atom_site_auth_atom_id_A = atom_site_auth_atom_id_A;
		this.atom_site_auth_atom_id_D = atom_site_auth_atom_id_D;
		this.atom_site_auth_atom_id_H = atom_site_auth_atom_id_H;
		this.atom_site_auth_comp_id_A = atom_site_auth_comp_id_A;
		this.atom_site_auth_comp_id_D = atom_site_auth_comp_id_D;
		this.atom_site_auth_comp_id_H = atom_site_auth_comp_id_H;
		this.atom_site_auth_seq_id_A = atom_site_auth_seq_id_A;
		this.atom_site_auth_seq_id_D = atom_site_auth_seq_id_D;
		this.atom_site_auth_seq_id_H = atom_site_auth_seq_id_H;
		this.atom_site_id_A = atom_site_id_A;
		this.atom_site_id_D = atom_site_id_D;
		this.atom_site_id_H = atom_site_id_H;
		this.atom_site_label_alt_id_A = atom_site_label_alt_id_A;
		this.atom_site_label_alt_id_D = atom_site_label_alt_id_D;
		this.atom_site_label_alt_id_H = atom_site_label_alt_id_H;
		this.atom_site_label_asym_id_A = atom_site_label_asym_id_A;
		this.atom_site_label_asym_id_D = atom_site_label_asym_id_D;
		this.atom_site_label_asym_id_H = atom_site_label_asym_id_H;
		this.atom_site_label_atom_id_A = atom_site_label_atom_id_A;
		this.atom_site_label_atom_id_D = atom_site_label_atom_id_D;
		this.atom_site_label_atom_id_H = atom_site_label_atom_id_H;
		this.atom_site_label_comp_id_A = atom_site_label_comp_id_A;
		this.atom_site_label_comp_id_D = atom_site_label_comp_id_D;
		this.atom_site_label_comp_id_H = atom_site_label_comp_id_H;
		this.atom_site_label_seq_id_A = atom_site_label_seq_id_A;
		this.atom_site_label_seq_id_D = atom_site_label_seq_id_D;
		this.atom_site_label_seq_id_H = atom_site_label_seq_id_H;
		this.dist_DA = dist_DA;
		this.dist_DA_esd = dist_DA_esd;
		this.dist_DH = dist_DH;
		this.dist_DH_esd = dist_DH_esd;
		this.dist_HA = dist_HA;
		this.dist_HA_esd = dist_HA_esd;
		this.publ_flag = publ_flag;
		this.site_symmetry_A = site_symmetry_A;
		this.site_symmetry_D = site_symmetry_D;
		this.site_symmetry_H = site_symmetry_H;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Geom_hbond");
		sb.append("\n");
		if (angle_DHA != null)
		{
			sb.append("angle_DHA = ");
			sb.append(angle_DHA);
			sb.append('\n');
		}
		if (angle_DHA_esd != null)
		{
			sb.append("angle_DHA_esd = ");
			sb.append(angle_DHA_esd);
			sb.append('\n');
		}
		if (atom_site_auth_asym_id_A != null)
		{
			sb.append("atom_site_auth_asym_id_A = ");
			sb.append(atom_site_auth_asym_id_A);
			sb.append('\n');
		}
		if (atom_site_auth_asym_id_D != null)
		{
			sb.append("atom_site_auth_asym_id_D = ");
			sb.append(atom_site_auth_asym_id_D);
			sb.append('\n');
		}
		if (atom_site_auth_asym_id_H != null)
		{
			sb.append("atom_site_auth_asym_id_H = ");
			sb.append(atom_site_auth_asym_id_H);
			sb.append('\n');
		}
		if (atom_site_auth_atom_id_A != null)
		{
			sb.append("atom_site_auth_atom_id_A = ");
			sb.append(atom_site_auth_atom_id_A);
			sb.append('\n');
		}
		if (atom_site_auth_atom_id_D != null)
		{
			sb.append("atom_site_auth_atom_id_D = ");
			sb.append(atom_site_auth_atom_id_D);
			sb.append('\n');
		}
		if (atom_site_auth_atom_id_H != null)
		{
			sb.append("atom_site_auth_atom_id_H = ");
			sb.append(atom_site_auth_atom_id_H);
			sb.append('\n');
		}
		if (atom_site_auth_comp_id_A != null)
		{
			sb.append("atom_site_auth_comp_id_A = ");
			sb.append(atom_site_auth_comp_id_A);
			sb.append('\n');
		}
		if (atom_site_auth_comp_id_D != null)
		{
			sb.append("atom_site_auth_comp_id_D = ");
			sb.append(atom_site_auth_comp_id_D);
			sb.append('\n');
		}
		if (atom_site_auth_comp_id_H != null)
		{
			sb.append("atom_site_auth_comp_id_H = ");
			sb.append(atom_site_auth_comp_id_H);
			sb.append('\n');
		}
		if (atom_site_auth_seq_id_A != null)
		{
			sb.append("atom_site_auth_seq_id_A = ");
			sb.append(atom_site_auth_seq_id_A);
			sb.append('\n');
		}
		if (atom_site_auth_seq_id_D != null)
		{
			sb.append("atom_site_auth_seq_id_D = ");
			sb.append(atom_site_auth_seq_id_D);
			sb.append('\n');
		}
		if (atom_site_auth_seq_id_H != null)
		{
			sb.append("atom_site_auth_seq_id_H = ");
			sb.append(atom_site_auth_seq_id_H);
			sb.append('\n');
		}
		if (atom_site_id_A != null)
		{
			sb.append("atom_site_id_A = ");
			sb.append(atom_site_id_A);
			sb.append('\n');
		}
		if (atom_site_id_D != null)
		{
			sb.append("atom_site_id_D = ");
			sb.append(atom_site_id_D);
			sb.append('\n');
		}
		if (atom_site_id_H != null)
		{
			sb.append("atom_site_id_H = ");
			sb.append(atom_site_id_H);
			sb.append('\n');
		}
		if (atom_site_label_alt_id_A != null)
		{
			sb.append("atom_site_label_alt_id_A = ");
			sb.append(atom_site_label_alt_id_A);
			sb.append('\n');
		}
		if (atom_site_label_alt_id_D != null)
		{
			sb.append("atom_site_label_alt_id_D = ");
			sb.append(atom_site_label_alt_id_D);
			sb.append('\n');
		}
		if (atom_site_label_alt_id_H != null)
		{
			sb.append("atom_site_label_alt_id_H = ");
			sb.append(atom_site_label_alt_id_H);
			sb.append('\n');
		}
		if (atom_site_label_asym_id_A != null)
		{
			sb.append("atom_site_label_asym_id_A = ");
			sb.append(atom_site_label_asym_id_A);
			sb.append('\n');
		}
		if (atom_site_label_asym_id_D != null)
		{
			sb.append("atom_site_label_asym_id_D = ");
			sb.append(atom_site_label_asym_id_D);
			sb.append('\n');
		}
		if (atom_site_label_asym_id_H != null)
		{
			sb.append("atom_site_label_asym_id_H = ");
			sb.append(atom_site_label_asym_id_H);
			sb.append('\n');
		}
		if (atom_site_label_atom_id_A != null)
		{
			sb.append("atom_site_label_atom_id_A = ");
			sb.append(atom_site_label_atom_id_A);
			sb.append('\n');
		}
		if (atom_site_label_atom_id_D != null)
		{
			sb.append("atom_site_label_atom_id_D = ");
			sb.append(atom_site_label_atom_id_D);
			sb.append('\n');
		}
		if (atom_site_label_atom_id_H != null)
		{
			sb.append("atom_site_label_atom_id_H = ");
			sb.append(atom_site_label_atom_id_H);
			sb.append('\n');
		}
		if (atom_site_label_comp_id_A != null)
		{
			sb.append("atom_site_label_comp_id_A = ");
			sb.append(atom_site_label_comp_id_A);
			sb.append('\n');
		}
		if (atom_site_label_comp_id_D != null)
		{
			sb.append("atom_site_label_comp_id_D = ");
			sb.append(atom_site_label_comp_id_D);
			sb.append('\n');
		}
		if (atom_site_label_comp_id_H != null)
		{
			sb.append("atom_site_label_comp_id_H = ");
			sb.append(atom_site_label_comp_id_H);
			sb.append('\n');
		}
		if (atom_site_label_seq_id_A != null)
		{
			sb.append("atom_site_label_seq_id_A = ");
			sb.append(atom_site_label_seq_id_A);
			sb.append('\n');
		}
		if (atom_site_label_seq_id_D != null)
		{
			sb.append("atom_site_label_seq_id_D = ");
			sb.append(atom_site_label_seq_id_D);
			sb.append('\n');
		}
		if (atom_site_label_seq_id_H != null)
		{
			sb.append("atom_site_label_seq_id_H = ");
			sb.append(atom_site_label_seq_id_H);
			sb.append('\n');
		}
		if (dist_DA != null)
		{
			sb.append("dist_DA = ");
			sb.append(dist_DA);
			sb.append('\n');
		}
		if (dist_DA_esd != null)
		{
			sb.append("dist_DA_esd = ");
			sb.append(dist_DA_esd);
			sb.append('\n');
		}
		if (dist_DH != null)
		{
			sb.append("dist_DH = ");
			sb.append(dist_DH);
			sb.append('\n');
		}
		if (dist_DH_esd != null)
		{
			sb.append("dist_DH_esd = ");
			sb.append(dist_DH_esd);
			sb.append('\n');
		}
		if (dist_HA != null)
		{
			sb.append("dist_HA = ");
			sb.append(dist_HA);
			sb.append('\n');
		}
		if (dist_HA_esd != null)
		{
			sb.append("dist_HA_esd = ");
			sb.append(dist_HA_esd);
			sb.append('\n');
		}
		if (publ_flag != null)
		{
			sb.append("publ_flag = ");
			sb.append(publ_flag);
			sb.append('\n');
		}
		if (site_symmetry_A != null)
		{
			sb.append("site_symmetry_A = ");
			sb.append(site_symmetry_A);
			sb.append('\n');
		}
		if (site_symmetry_D != null)
		{
			sb.append("site_symmetry_D = ");
			sb.append(site_symmetry_D);
			sb.append('\n');
		}
		if (site_symmetry_H != null)
		{
			sb.append("site_symmetry_H = ");
			sb.append(site_symmetry_H);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		angle_DHA = null;
		angle_DHA_esd = null;
		atom_site_auth_asym_id_A = null;
		atom_site_auth_asym_id_D = null;
		atom_site_auth_asym_id_H = null;
		atom_site_auth_atom_id_A = null;
		atom_site_auth_atom_id_D = null;
		atom_site_auth_atom_id_H = null;
		atom_site_auth_comp_id_A = null;
		atom_site_auth_comp_id_D = null;
		atom_site_auth_comp_id_H = null;
		atom_site_auth_seq_id_A = null;
		atom_site_auth_seq_id_D = null;
		atom_site_auth_seq_id_H = null;
		atom_site_id_A = null;
		atom_site_id_D = null;
		atom_site_id_H = null;
		atom_site_label_alt_id_A = null;
		atom_site_label_alt_id_D = null;
		atom_site_label_alt_id_H = null;
		atom_site_label_asym_id_A = null;
		atom_site_label_asym_id_D = null;
		atom_site_label_asym_id_H = null;
		atom_site_label_atom_id_A = null;
		atom_site_label_atom_id_D = null;
		atom_site_label_atom_id_H = null;
		atom_site_label_comp_id_A = null;
		atom_site_label_comp_id_D = null;
		atom_site_label_comp_id_H = null;
		atom_site_label_seq_id_A = null;
		atom_site_label_seq_id_D = null;
		atom_site_label_seq_id_H = null;
		dist_DA = null;
		dist_DA_esd = null;
		dist_DH = null;
		dist_DH_esd = null;
		dist_HA = null;
		dist_HA_esd = null;
		publ_flag = null;
		site_symmetry_A = null;
		site_symmetry_D = null;
		site_symmetry_H = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Geom_hbond)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:geom_hbond>\n");
			if (angle_DHA != null) ow.write(indent + " <PDBx:angle_DHA>" + angle_DHA + "</PDBx:angle_DHA>\n");
			if (angle_DHA_esd != null) ow.write(indent + " <PDBx:angle_DHA_esd>" + angle_DHA_esd + "</PDBx:angle_DHA_esd>\n");
			if (atom_site_auth_asym_id_A != null) ow.write(indent + " <PDBx:atom_site_auth_asym_id_A>" + atom_site_auth_asym_id_A + "</PDBx:atom_site_auth_asym_id_A>\n");
			if (atom_site_auth_asym_id_D != null) ow.write(indent + " <PDBx:atom_site_auth_asym_id_D>" + atom_site_auth_asym_id_D + "</PDBx:atom_site_auth_asym_id_D>\n");
			if (atom_site_auth_asym_id_H != null) ow.write(indent + " <PDBx:atom_site_auth_asym_id_H>" + atom_site_auth_asym_id_H + "</PDBx:atom_site_auth_asym_id_H>\n");
			if (atom_site_auth_atom_id_A != null) ow.write(indent + " <PDBx:atom_site_auth_atom_id_A>" + atom_site_auth_atom_id_A + "</PDBx:atom_site_auth_atom_id_A>\n");
			if (atom_site_auth_atom_id_D != null) ow.write(indent + " <PDBx:atom_site_auth_atom_id_D>" + atom_site_auth_atom_id_D + "</PDBx:atom_site_auth_atom_id_D>\n");
			if (atom_site_auth_atom_id_H != null) ow.write(indent + " <PDBx:atom_site_auth_atom_id_H>" + atom_site_auth_atom_id_H + "</PDBx:atom_site_auth_atom_id_H>\n");
			if (atom_site_auth_comp_id_A != null) ow.write(indent + " <PDBx:atom_site_auth_comp_id_A>" + atom_site_auth_comp_id_A + "</PDBx:atom_site_auth_comp_id_A>\n");
			if (atom_site_auth_comp_id_D != null) ow.write(indent + " <PDBx:atom_site_auth_comp_id_D>" + atom_site_auth_comp_id_D + "</PDBx:atom_site_auth_comp_id_D>\n");
			if (atom_site_auth_comp_id_H != null) ow.write(indent + " <PDBx:atom_site_auth_comp_id_H>" + atom_site_auth_comp_id_H + "</PDBx:atom_site_auth_comp_id_H>\n");
			if (atom_site_auth_seq_id_A != null) ow.write(indent + " <PDBx:atom_site_auth_seq_id_A>" + atom_site_auth_seq_id_A + "</PDBx:atom_site_auth_seq_id_A>\n");
			if (atom_site_auth_seq_id_D != null) ow.write(indent + " <PDBx:atom_site_auth_seq_id_D>" + atom_site_auth_seq_id_D + "</PDBx:atom_site_auth_seq_id_D>\n");
			if (atom_site_auth_seq_id_H != null) ow.write(indent + " <PDBx:atom_site_auth_seq_id_H>" + atom_site_auth_seq_id_H + "</PDBx:atom_site_auth_seq_id_H>\n");
			if (atom_site_id_A != null) ow.write(indent + " <PDBx:atom_site_id_A>" + atom_site_id_A + "</PDBx:atom_site_id_A>\n");
			if (atom_site_id_D != null) ow.write(indent + " <PDBx:atom_site_id_D>" + atom_site_id_D + "</PDBx:atom_site_id_D>\n");
			if (atom_site_id_H != null) ow.write(indent + " <PDBx:atom_site_id_H>" + atom_site_id_H + "</PDBx:atom_site_id_H>\n");
			if (atom_site_label_alt_id_A != null) ow.write(indent + " <PDBx:atom_site_label_alt_id_A>" + atom_site_label_alt_id_A + "</PDBx:atom_site_label_alt_id_A>\n");
			if (atom_site_label_alt_id_D != null) ow.write(indent + " <PDBx:atom_site_label_alt_id_D>" + atom_site_label_alt_id_D + "</PDBx:atom_site_label_alt_id_D>\n");
			if (atom_site_label_alt_id_H != null) ow.write(indent + " <PDBx:atom_site_label_alt_id_H>" + atom_site_label_alt_id_H + "</PDBx:atom_site_label_alt_id_H>\n");
			if (atom_site_label_asym_id_A != null) ow.write(indent + " <PDBx:atom_site_label_asym_id_A>" + atom_site_label_asym_id_A + "</PDBx:atom_site_label_asym_id_A>\n");
			if (atom_site_label_asym_id_D != null) ow.write(indent + " <PDBx:atom_site_label_asym_id_D>" + atom_site_label_asym_id_D + "</PDBx:atom_site_label_asym_id_D>\n");
			if (atom_site_label_asym_id_H != null) ow.write(indent + " <PDBx:atom_site_label_asym_id_H>" + atom_site_label_asym_id_H + "</PDBx:atom_site_label_asym_id_H>\n");
			if (atom_site_label_atom_id_A != null) ow.write(indent + " <PDBx:atom_site_label_atom_id_A>" + atom_site_label_atom_id_A + "</PDBx:atom_site_label_atom_id_A>\n");
			if (atom_site_label_atom_id_D != null) ow.write(indent + " <PDBx:atom_site_label_atom_id_D>" + atom_site_label_atom_id_D + "</PDBx:atom_site_label_atom_id_D>\n");
			if (atom_site_label_atom_id_H != null) ow.write(indent + " <PDBx:atom_site_label_atom_id_H>" + atom_site_label_atom_id_H + "</PDBx:atom_site_label_atom_id_H>\n");
			if (atom_site_label_comp_id_A != null) ow.write(indent + " <PDBx:atom_site_label_comp_id_A>" + atom_site_label_comp_id_A + "</PDBx:atom_site_label_comp_id_A>\n");
			if (atom_site_label_comp_id_D != null) ow.write(indent + " <PDBx:atom_site_label_comp_id_D>" + atom_site_label_comp_id_D + "</PDBx:atom_site_label_comp_id_D>\n");
			if (atom_site_label_comp_id_H != null) ow.write(indent + " <PDBx:atom_site_label_comp_id_H>" + atom_site_label_comp_id_H + "</PDBx:atom_site_label_comp_id_H>\n");
			if (atom_site_label_seq_id_A != null) ow.write(indent + " <PDBx:atom_site_label_seq_id_A>" + atom_site_label_seq_id_A + "</PDBx:atom_site_label_seq_id_A>\n");
			if (atom_site_label_seq_id_D != null) ow.write(indent + " <PDBx:atom_site_label_seq_id_D>" + atom_site_label_seq_id_D + "</PDBx:atom_site_label_seq_id_D>\n");
			if (atom_site_label_seq_id_H != null) ow.write(indent + " <PDBx:atom_site_label_seq_id_H>" + atom_site_label_seq_id_H + "</PDBx:atom_site_label_seq_id_H>\n");
			if (dist_DA != null) ow.write(indent + " <PDBx:dist_DA>" + dist_DA + "</PDBx:dist_DA>\n");
			if (dist_DA_esd != null) ow.write(indent + " <PDBx:dist_DA_esd>" + dist_DA_esd + "</PDBx:dist_DA_esd>\n");
			if (dist_DH != null) ow.write(indent + " <PDBx:dist_DH>" + dist_DH + "</PDBx:dist_DH>\n");
			if (dist_DH_esd != null) ow.write(indent + " <PDBx:dist_DH_esd>" + dist_DH_esd + "</PDBx:dist_DH_esd>\n");
			if (dist_HA != null) ow.write(indent + " <PDBx:dist_HA>" + dist_HA + "</PDBx:dist_HA>\n");
			if (dist_HA_esd != null) ow.write(indent + " <PDBx:dist_HA_esd>" + dist_HA_esd + "</PDBx:dist_HA_esd>\n");
			if (publ_flag != null) ow.write(indent + " <PDBx:publ_flag>" + publ_flag + "</PDBx:publ_flag>\n");
			if (site_symmetry_A != null) ow.write(indent + " <PDBx:site_symmetry_A>" + site_symmetry_A + "</PDBx:site_symmetry_A>\n");
			if (site_symmetry_D != null) ow.write(indent + " <PDBx:site_symmetry_D>" + site_symmetry_D + "</PDBx:site_symmetry_D>\n");
			if (site_symmetry_H != null) ow.write(indent + " <PDBx:site_symmetry_H>" + site_symmetry_H + "</PDBx:site_symmetry_H>\n");
			ow.write(indent + "</PDBx:geom_hbond>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
