package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_CONTACT_AUTHOR category record details
 *  about the Structural Genomics Project and name and initials
 *  for each Center.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_SG_projectCategory>
 *  <PDBx:pdbx_SG_project id="1">
 *  <PDBx:project_name>PSI, Protein Structure Initiative</PDBx:project_name>
 *  <PDBx:full_name_of_center>Berkeley Structural Genomics Center</PDBx:full_name_of_center>
 *  <PDBx:initial_of_center>BSGC</PDBx:initial_of_center>
 *  </PDBx:pdbx_SG_project>
 *  </PDBx:pdbx_SG_projectCategory>
 * </pre>
 */
public class Pdbx_SG_project extends org.pdb.beans.Pdbx_SG_project implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_SG_project";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_SG_project()
	{
	}

	/** Full constructor */
	public Pdbx_SG_project(
		Datablock datablock,
		java.lang.String full_name_of_center,
		java.lang.Integer id_,
		java.lang.String initial_of_center,
		java.lang.String project_name)
	{
		this.datablock = datablock;
		this.full_name_of_center = full_name_of_center;
		this.id_ = id_;
		this.initial_of_center = initial_of_center;
		this.project_name = project_name;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_SG_project");
		sb.append("\n");
		if (full_name_of_center != null)
		{
			sb.append("full_name_of_center = ");
			sb.append(full_name_of_center);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (initial_of_center != null)
		{
			sb.append("initial_of_center = ");
			sb.append(initial_of_center);
			sb.append('\n');
		}
		if (project_name != null)
		{
			sb.append("project_name = ");
			sb.append(project_name);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		full_name_of_center = null;
		id_ = null;
		initial_of_center = null;
		project_name = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_SG_project)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_SG_project>\n");
			if (full_name_of_center != null) ow.write(indent + " <PDBx:full_name_of_center>" + full_name_of_center + "</PDBx:full_name_of_center>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (initial_of_center != null) ow.write(indent + " <PDBx:initial_of_center>" + initial_of_center + "</PDBx:initial_of_center>\n");
			if (project_name != null) ow.write(indent + " <PDBx:project_name>" + project_name + "</PDBx:project_name>\n");
			ow.write(indent + "</PDBx:pdbx_SG_project>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
