package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Constituents of buffer in sample
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:pdbx_buffer_componentsCategory>
 *  <PDBx:pdbx_buffer_components buffer_id="1" id="1">
 *  <PDBx:name>NaCl</PDBx:name>
 *  <PDBx:volume>0.200 </PDBx:volume>
 *  <PDBx:conc>4 </PDBx:conc>
 *  </PDBx:pdbx_buffer_components>
 *  <PDBx:pdbx_buffer_components buffer_id="1" id="2">
 *  <PDBx:name>Acetic Acid</PDBx:name>
 *  <PDBx:volume>0.047 </PDBx:volume>
 *  <PDBx:conc>100</PDBx:conc>
 *  </PDBx:pdbx_buffer_components>
 *  <PDBx:pdbx_buffer_components buffer_id="1" id="3">
 *  <PDBx:name>water</PDBx:name>
 *  <PDBx:volume>0.700 </PDBx:volume>
 *  <PDBx:conc>neat</PDBx:conc>
 *  </PDBx:pdbx_buffer_components>
 *  </PDBx:pdbx_buffer_componentsCategory>
 * </pre>
 */
public class Pdbx_buffer_components extends org.pdb.beans.Pdbx_buffer_components implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_buffer_components";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_buffer_components()
	{
	}

	/** Full constructor */
	public Pdbx_buffer_components(
		Datablock datablock,
		java.lang.String buffer_id,
		java.lang.String conc,
		java.lang.String conc_units,
		java.lang.String details,
		java.lang.String id_,
		java.lang.String isotopic_labeling,
		java.lang.String name,
		java.lang.String volume)
	{
		this.datablock = datablock;
		this.buffer_id = buffer_id;
		this.conc = conc;
		this.conc_units = conc_units;
		this.details = details;
		this.id_ = id_;
		this.isotopic_labeling = isotopic_labeling;
		this.name = name;
		this.volume = volume;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_buffer_components");
		sb.append("\n");
		if (buffer_id != null)
		{
			sb.append("buffer_id = ");
			sb.append(buffer_id);
			sb.append('\n');
		}
		if (conc != null)
		{
			sb.append("conc = ");
			sb.append(conc);
			sb.append('\n');
		}
		if (conc_units != null)
		{
			sb.append("conc_units = ");
			sb.append(conc_units);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (isotopic_labeling != null)
		{
			sb.append("isotopic_labeling = ");
			sb.append(isotopic_labeling);
			sb.append('\n');
		}
		if (name != null)
		{
			sb.append("name = ");
			sb.append(name);
			sb.append('\n');
		}
		if (volume != null)
		{
			sb.append("volume = ");
			sb.append(volume);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		buffer_id = null;
		conc = null;
		conc_units = null;
		details = null;
		id_ = null;
		isotopic_labeling = null;
		name = null;
		volume = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_buffer_components)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_buffer_components>\n");
			if (buffer_id != null) ow.write(indent + " <PDBx:buffer_id>" + buffer_id + "</PDBx:buffer_id>\n");
			if (conc != null) ow.write(indent + " <PDBx:conc>" + conc + "</PDBx:conc>\n");
			if (conc_units != null) ow.write(indent + " <PDBx:conc_units>" + conc_units + "</PDBx:conc_units>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (isotopic_labeling != null) ow.write(indent + " <PDBx:isotopic_labeling>" + isotopic_labeling + "</PDBx:isotopic_labeling>\n");
			if (name != null) ow.write(indent + " <PDBx:name>" + name + "</PDBx:name>\n");
			if (volume != null) ow.write(indent + " <PDBx:volume>" + volume + "</PDBx:volume>\n");
			ow.write(indent + "</PDBx:pdbx_buffer_components>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
