package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_CHEM_COMP_ATOM_EDIT category provide
 *  atom level editing instructions to be applied to imported
 *  chemical components.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_chem_comp_atom_editCategory>
 *  <PDBx:pdbx_chem_comp_atom_edit ordinal="1">
 *  <PDBx:comp_id>LYS</PDBx:comp_id>
 *  <PDBx:edit_op>DELETE</PDBx:edit_op>
 *  <PDBx:atom_id>HN2</PDBx:atom_id>
 *  </PDBx:pdbx_chem_comp_atom_edit>
 *  </PDBx:pdbx_chem_comp_atom_editCategory>
 * </pre>
 */
public class Pdbx_chem_comp_atom_edit extends org.pdb.beans.Pdbx_chem_comp_atom_edit implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_chem_comp_atom_edit";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_chem_comp_atom_edit()
	{
	}

	/** Full constructor */
	public Pdbx_chem_comp_atom_edit(
		Datablock datablock,
		java.lang.String atom_id,
		java.lang.String comp_id,
		java.lang.String edit_atom_id,
		java.lang.String edit_atom_value,
		java.lang.String edit_op,
		java.lang.Integer ordinal)
	{
		this.datablock = datablock;
		this.atom_id = atom_id;
		this.comp_id = comp_id;
		this.edit_atom_id = edit_atom_id;
		this.edit_atom_value = edit_atom_value;
		this.edit_op = edit_op;
		this.ordinal = ordinal;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_chem_comp_atom_edit");
		sb.append("\n");
		if (atom_id != null)
		{
			sb.append("atom_id = ");
			sb.append(atom_id);
			sb.append('\n');
		}
		if (comp_id != null)
		{
			sb.append("comp_id = ");
			sb.append(comp_id);
			sb.append('\n');
		}
		if (edit_atom_id != null)
		{
			sb.append("edit_atom_id = ");
			sb.append(edit_atom_id);
			sb.append('\n');
		}
		if (edit_atom_value != null)
		{
			sb.append("edit_atom_value = ");
			sb.append(edit_atom_value);
			sb.append('\n');
		}
		if (edit_op != null)
		{
			sb.append("edit_op = ");
			sb.append(edit_op);
			sb.append('\n');
		}
		if (ordinal != null)
		{
			sb.append("ordinal = ");
			sb.append(ordinal);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		atom_id = null;
		comp_id = null;
		edit_atom_id = null;
		edit_atom_value = null;
		edit_op = null;
		ordinal = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_chem_comp_atom_edit)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_chem_comp_atom_edit>\n");
			if (atom_id != null) ow.write(indent + " <PDBx:atom_id>" + atom_id + "</PDBx:atom_id>\n");
			if (comp_id != null) ow.write(indent + " <PDBx:comp_id>" + comp_id + "</PDBx:comp_id>\n");
			if (edit_atom_id != null) ow.write(indent + " <PDBx:edit_atom_id>" + edit_atom_id + "</PDBx:edit_atom_id>\n");
			if (edit_atom_value != null) ow.write(indent + " <PDBx:edit_atom_value>" + edit_atom_value + "</PDBx:edit_atom_value>\n");
			if (edit_op != null) ow.write(indent + " <PDBx:edit_op>" + edit_op + "</PDBx:edit_op>\n");
			if (ordinal != null) ow.write(indent + " <PDBx:ordinal>" + ordinal + "</PDBx:ordinal>\n");
			ow.write(indent + "</PDBx:pdbx_chem_comp_atom_edit>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
