package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_COMP_DESCRIPTOR category provide
 *  string descriptors of component chemical structure.
 *  
 * <pre>
 *  Example 1 -
 * </pre>
 */
public class Pdbx_chem_comp_descriptor extends org.pdb.beans.Pdbx_chem_comp_descriptor implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_chem_comp_descriptor";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_chem_comp_descriptor()
	{
	}

	/** Full constructor */
	public Pdbx_chem_comp_descriptor(
		Datablock datablock,
		java.lang.String comp_id,
		java.lang.String descriptor,
		java.lang.Integer ordinal,
		java.lang.String program,
		java.lang.String program_version,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.comp_id = comp_id;
		this.descriptor = descriptor;
		this.ordinal = ordinal;
		this.program = program;
		this.program_version = program_version;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_chem_comp_descriptor");
		sb.append("\n");
		if (comp_id != null)
		{
			sb.append("comp_id = ");
			sb.append(comp_id);
			sb.append('\n');
		}
		if (descriptor != null)
		{
			sb.append("descriptor = ");
			sb.append(descriptor);
			sb.append('\n');
		}
		if (ordinal != null)
		{
			sb.append("ordinal = ");
			sb.append(ordinal);
			sb.append('\n');
		}
		if (program != null)
		{
			sb.append("program = ");
			sb.append(program);
			sb.append('\n');
		}
		if (program_version != null)
		{
			sb.append("program_version = ");
			sb.append(program_version);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		comp_id = null;
		descriptor = null;
		ordinal = null;
		program = null;
		program_version = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_chem_comp_descriptor)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_chem_comp_descriptor>\n");
			if (comp_id != null) ow.write(indent + " <PDBx:comp_id>" + comp_id + "</PDBx:comp_id>\n");
			if (descriptor != null) ow.write(indent + " <PDBx:descriptor>" + descriptor + "</PDBx:descriptor>\n");
			if (ordinal != null) ow.write(indent + " <PDBx:ordinal>" + ordinal + "</PDBx:ordinal>\n");
			if (program != null) ow.write(indent + " <PDBx:program>" + program + "</PDBx:program>\n");
			if (program_version != null) ow.write(indent + " <PDBx:program_version>" + program_version + "</PDBx:program_version>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:pdbx_chem_comp_descriptor>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
