package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_CHEM_COMP_IMPORT category identify
 *  existing chemical components to be imported into the
 *  current component definition.  Components in this list
 *  can be edited by instructions in categories
 *  pdbx_chem_comp_atom_edit and pdbx_chem_comp_bond_edit.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_chem_comp_importCategory>
 *  <PDBx:pdbx_chem_comp_import comp_id="ATP"></PDBx:pdbx_chem_comp_import>
 *  </PDBx:pdbx_chem_comp_importCategory>
 * </pre>
 */
public class Pdbx_chem_comp_import extends org.pdb.beans.Pdbx_chem_comp_import implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_chem_comp_import";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_chem_comp_import()
	{
	}

	/** Full constructor */
	public Pdbx_chem_comp_import(
		Datablock datablock,
		java.lang.String comp_id)
	{
		this.datablock = datablock;
		this.comp_id = comp_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_chem_comp_import");
		sb.append("\n");
		if (comp_id != null)
		{
			sb.append("comp_id = ");
			sb.append(comp_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		comp_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_chem_comp_import)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_chem_comp_import>\n");
			if (comp_id != null) ow.write(indent + " <PDBx:comp_id>" + comp_id + "</PDBx:comp_id>\n");
			ow.write(indent + "</PDBx:pdbx_chem_comp_import>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
