package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_CONSTRUCT category specify a sequence of
 *  nucleic acids or amino acids. It is a catch-all that may be used to
 *  provide details of sequences known to be relevant to the project as well
 *  as primers, plasmids, proteins and such like that are either used or
 *  produced during the protein production process. Molecules described
 *  here are not necessarily complete, so for instance it would be
 *  possible to include either a complete plasmid or just its insert.
 *  This category may be considered as an abbreviated form of _entity where
 *  the molecules described are not required to appear in the final co-ordinates.
 *  
 *  Note that the details provided here all pertain to a single entry as defined
 *  at deposition. It is anticipated that  attribute id in category pdbx_construct would also be
 *  composed of a sequence that is unique within a given site prefixed by a code
 *  that identifies that site and would, therefore, be GLOBALLY unique. Thus
 *  this category could also be used locally to store details about the different
 *  constructs used during protein production without reference to the entry_id
 *  (which only becomes a  meaningful concept during deposition).
 *  
 * <pre>
 *  Example 1 - hypothetical example
 *  <PDBx:pdbx_constructCategory>
 *  <PDBx:pdbx_construct id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:type>DNA</PDBx:type>
 *  <PDBx:entity_id>1</PDBx:entity_id>
 *  <PDBx:seq>  gatgctgtag gcataggctt ggttatgccg gtactgccgg gcctcttgcg ggatatcgtc
 *  gctcaaggcg cactcccgtt ctggataatg ttttttgcgc cgacatcata acggttctgg
 *  caaatattct gaaatgagct gttgacaatt aatcatcgat aagcttcttg
 *  # - - - - data truncated for brevity - - - -</PDBx:seq>
 *  </PDBx:pdbx_construct>
 *  </PDBx:pdbx_constructCategory>
 * </pre>
 */
public class Pdbx_construct extends org.pdb.beans.Pdbx_construct implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_construct";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_construct()
	{
	}

	/** Full constructor */
	public Pdbx_construct(
		Datablock datablock,
		java.lang.String class_,
		java.lang.String date,
		java.lang.String details,
		java.lang.String entity_id,
		java.lang.String entry_id,
		java.lang.String id_,
		java.lang.String name,
		java.lang.String organisation,
		java.lang.String robot_id,
		java.lang.String seq,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.class_ = class_;
		this.date = date;
		this.details = details;
		this.entity_id = entity_id;
		this.entry_id = entry_id;
		this.id_ = id_;
		this.name = name;
		this.organisation = organisation;
		this.robot_id = robot_id;
		this.seq = seq;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_construct");
		sb.append("\n");
		if (class_ != null)
		{
			sb.append("class = ");
			sb.append(class_);
			sb.append('\n');
		}
		if (date != null)
		{
			sb.append("date = ");
			sb.append(date);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (name != null)
		{
			sb.append("name = ");
			sb.append(name);
			sb.append('\n');
		}
		if (organisation != null)
		{
			sb.append("organisation = ");
			sb.append(organisation);
			sb.append('\n');
		}
		if (robot_id != null)
		{
			sb.append("robot_id = ");
			sb.append(robot_id);
			sb.append('\n');
		}
		if (seq != null)
		{
			sb.append("seq = ");
			sb.append(seq);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		class_ = null;
		date = null;
		details = null;
		entity_id = null;
		entry_id = null;
		id_ = null;
		name = null;
		organisation = null;
		robot_id = null;
		seq = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_construct)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_construct>\n");
			if (class_ != null) ow.write(indent + " <PDBx:class>" + class_ + "</PDBx:class>\n");
			if (date != null) ow.write(indent + " <PDBx:date>" + date + "</PDBx:date>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (name != null) ow.write(indent + " <PDBx:name>" + name + "</PDBx:name>\n");
			if (organisation != null) ow.write(indent + " <PDBx:organisation>" + organisation + "</PDBx:organisation>\n");
			if (robot_id != null) ow.write(indent + " <PDBx:robot_id>" + robot_id + "</PDBx:robot_id>\n");
			if (seq != null) ow.write(indent + " <PDBx:seq>" + seq + "</PDBx:seq>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:pdbx_construct>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
