package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_CONTACT_AUTHOR category record details
 *  about the name and address of the author to be contacted
 *  concerning the contents of this data block.  This category atomizes
 *  information to a greater degree than the standard AUDIT_CONTACT_AUTHOR
 *  category.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_contact_authorCategory>
 *  <PDBx:pdbx_contact_author id="1">
 *  <PDBx:name_salutation>Dr.</PDBx:name_salutation>
 *  <PDBx:name_first>Paula</PDBx:name_first>
 *  <PDBx:name_last>Fitzgerald</PDBx:name_last>
 *  <PDBx:name_mi>M.D.</PDBx:name_mi>
 *  <PDBx:address_1>Department of Biophysical Chemistry</PDBx:address_1>
 *  <PDBx:address_2>Merck Research Laboratories</PDBx:address_2>
 *  <PDBx:address_3>P. O. Box 2000, Ry80M203</PDBx:address_3>
 *  <PDBx:city>Rahway</PDBx:city>
 *  <PDBx:state_province>New Jersey</PDBx:state_province>
 *  <PDBx:postal_code>07065</PDBx:postal_code>
 *  <PDBx:country>UNITED STATES</PDBx:country>
 *  <PDBx:phone>908 594 5510</PDBx:phone>
 *  <PDBx:fax>908 594 6645</PDBx:fax>
 *  <PDBx:email>paula_fitzgerald@merck.com</PDBx:email>
 *  <PDBx:role>principal investigator/group leader</PDBx:role>
 *  <PDBx:organization_type>commercial</PDBx:organization_type>
 *  </PDBx:pdbx_contact_author>
 *  </PDBx:pdbx_contact_authorCategory>
 * </pre>
 */
public class Pdbx_contact_author extends org.pdb.beans.Pdbx_contact_author implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_contact_author";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_contact_author()
	{
	}

	/** Full constructor */
	public Pdbx_contact_author(
		Datablock datablock,
		java.lang.String address_1,
		java.lang.String address_2,
		java.lang.String address_3,
		java.lang.String city,
		java.lang.String continent,
		java.lang.String country,
		java.lang.String email,
		java.lang.String fax,
		java.lang.Integer id_,
		java.lang.String name_first,
		java.lang.String name_last,
		java.lang.String name_mi,
		java.lang.String name_salutation,
		java.lang.String organization_type,
		java.lang.String phone,
		java.lang.String postal_code,
		java.lang.String role,
		java.lang.String state_province)
	{
		this.datablock = datablock;
		this.address_1 = address_1;
		this.address_2 = address_2;
		this.address_3 = address_3;
		this.city = city;
		this.continent = continent;
		this.country = country;
		this.email = email;
		this.fax = fax;
		this.id_ = id_;
		this.name_first = name_first;
		this.name_last = name_last;
		this.name_mi = name_mi;
		this.name_salutation = name_salutation;
		this.organization_type = organization_type;
		this.phone = phone;
		this.postal_code = postal_code;
		this.role = role;
		this.state_province = state_province;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_contact_author");
		sb.append("\n");
		if (address_1 != null)
		{
			sb.append("address_1 = ");
			sb.append(address_1);
			sb.append('\n');
		}
		if (address_2 != null)
		{
			sb.append("address_2 = ");
			sb.append(address_2);
			sb.append('\n');
		}
		if (address_3 != null)
		{
			sb.append("address_3 = ");
			sb.append(address_3);
			sb.append('\n');
		}
		if (city != null)
		{
			sb.append("city = ");
			sb.append(city);
			sb.append('\n');
		}
		if (continent != null)
		{
			sb.append("continent = ");
			sb.append(continent);
			sb.append('\n');
		}
		if (country != null)
		{
			sb.append("country = ");
			sb.append(country);
			sb.append('\n');
		}
		if (email != null)
		{
			sb.append("email = ");
			sb.append(email);
			sb.append('\n');
		}
		if (fax != null)
		{
			sb.append("fax = ");
			sb.append(fax);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (name_first != null)
		{
			sb.append("name_first = ");
			sb.append(name_first);
			sb.append('\n');
		}
		if (name_last != null)
		{
			sb.append("name_last = ");
			sb.append(name_last);
			sb.append('\n');
		}
		if (name_mi != null)
		{
			sb.append("name_mi = ");
			sb.append(name_mi);
			sb.append('\n');
		}
		if (name_salutation != null)
		{
			sb.append("name_salutation = ");
			sb.append(name_salutation);
			sb.append('\n');
		}
		if (organization_type != null)
		{
			sb.append("organization_type = ");
			sb.append(organization_type);
			sb.append('\n');
		}
		if (phone != null)
		{
			sb.append("phone = ");
			sb.append(phone);
			sb.append('\n');
		}
		if (postal_code != null)
		{
			sb.append("postal_code = ");
			sb.append(postal_code);
			sb.append('\n');
		}
		if (role != null)
		{
			sb.append("role = ");
			sb.append(role);
			sb.append('\n');
		}
		if (state_province != null)
		{
			sb.append("state_province = ");
			sb.append(state_province);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		address_1 = null;
		address_2 = null;
		address_3 = null;
		city = null;
		continent = null;
		country = null;
		email = null;
		fax = null;
		id_ = null;
		name_first = null;
		name_last = null;
		name_mi = null;
		name_salutation = null;
		organization_type = null;
		phone = null;
		postal_code = null;
		role = null;
		state_province = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_contact_author)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_contact_author>\n");
			if (address_1 != null) ow.write(indent + " <PDBx:address_1>" + address_1 + "</PDBx:address_1>\n");
			if (address_2 != null) ow.write(indent + " <PDBx:address_2>" + address_2 + "</PDBx:address_2>\n");
			if (address_3 != null) ow.write(indent + " <PDBx:address_3>" + address_3 + "</PDBx:address_3>\n");
			if (city != null) ow.write(indent + " <PDBx:city>" + city + "</PDBx:city>\n");
			if (continent != null) ow.write(indent + " <PDBx:continent>" + continent + "</PDBx:continent>\n");
			if (country != null) ow.write(indent + " <PDBx:country>" + country + "</PDBx:country>\n");
			if (email != null) ow.write(indent + " <PDBx:email>" + email + "</PDBx:email>\n");
			if (fax != null) ow.write(indent + " <PDBx:fax>" + fax + "</PDBx:fax>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (name_first != null) ow.write(indent + " <PDBx:name_first>" + name_first + "</PDBx:name_first>\n");
			if (name_last != null) ow.write(indent + " <PDBx:name_last>" + name_last + "</PDBx:name_last>\n");
			if (name_mi != null) ow.write(indent + " <PDBx:name_mi>" + name_mi + "</PDBx:name_mi>\n");
			if (name_salutation != null) ow.write(indent + " <PDBx:name_salutation>" + name_salutation + "</PDBx:name_salutation>\n");
			if (organization_type != null) ow.write(indent + " <PDBx:organization_type>" + organization_type + "</PDBx:organization_type>\n");
			if (phone != null) ow.write(indent + " <PDBx:phone>" + phone + "</PDBx:phone>\n");
			if (postal_code != null) ow.write(indent + " <PDBx:postal_code>" + postal_code + "</PDBx:postal_code>\n");
			if (role != null) ow.write(indent + " <PDBx:role>" + role + "</PDBx:role>\n");
			if (state_province != null) ow.write(indent + " <PDBx:state_province>" + state_province + "</PDBx:state_province>\n");
			ow.write(indent + "</PDBx:pdbx_contact_author>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
