package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in PDBX_DATABASE_RELATED contain references to entries
 *  that are related to the this entry.
 *  <PDBx:pdbx_database_relatedCategory>
 *  <PDBx:pdbx_database_related db_name="PDB" db_id="1ABC"></PDBx:pdbx_database_related>
 *  </PDBx:pdbx_database_relatedCategory>
 */
public class Pdbx_database_related extends org.pdb.beans.Pdbx_database_related implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_database_related";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_database_related()
	{
	}

	/** Full constructor */
	public Pdbx_database_related(
		Datablock datablock,
		java.lang.String content_type,
		java.lang.String db_id,
		java.lang.String db_name,
		java.lang.String details)
	{
		this.datablock = datablock;
		this.content_type = content_type;
		this.db_id = db_id;
		this.db_name = db_name;
		this.details = details;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_database_related");
		sb.append("\n");
		if (content_type != null)
		{
			sb.append("content_type = ");
			sb.append(content_type);
			sb.append('\n');
		}
		if (db_id != null)
		{
			sb.append("db_id = ");
			sb.append(db_id);
			sb.append('\n');
		}
		if (db_name != null)
		{
			sb.append("db_name = ");
			sb.append(db_name);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		content_type = null;
		db_id = null;
		db_name = null;
		details = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_database_related)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_database_related>\n");
			if (content_type != null) ow.write(indent + " <PDBx:content_type>" + content_type + "</PDBx:content_type>\n");
			if (db_id != null) ow.write(indent + " <PDBx:db_id>" + db_id + "</PDBx:db_id>\n");
			if (db_name != null) ow.write(indent + " <PDBx:db_name>" + db_name + "</PDBx:db_name>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			ow.write(indent + "</PDBx:pdbx_database_related>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
