package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_DATABASE_REMARK category record keep additional
 *  information about the entry.  They are mostly used to create
 *  'non-standard' PDB REMARK annotations (6-99).
 *  
 * <pre>
 *  Example 1 - based on PDB entry 1ABC
 *  <PDBx:pdbx_database_remarkCategory>
 *  <PDBx:pdbx_database_remark id="1">
 *  <PDBx:text> THE NON-CRYSTALLOGRAPHIC RELATIONSHIP BETWEEN THE THREE
 *  DOUBLE HELICES IN THE ASYMMETRIC UNIT IS DESCRIBED
 *  IN THE MTRIX1-3 RECORDS.</PDBx:text>
 *  </PDBx:pdbx_database_remark>
 *  </PDBx:pdbx_database_remarkCategory>
 * </pre>
 */
public class Pdbx_database_remark extends org.pdb.beans.Pdbx_database_remark implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_database_remark";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_database_remark()
	{
	}

	/** Full constructor */
	public Pdbx_database_remark(
		Datablock datablock,
		java.lang.Integer id_,
		java.lang.String text)
	{
		this.datablock = datablock;
		this.id_ = id_;
		this.text = text;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_database_remark");
		sb.append("\n");
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (text != null)
		{
			sb.append("text = ");
			sb.append(text);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		id_ = null;
		text = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_database_remark)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_database_remark>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (text != null) ow.write(indent + " <PDBx:text>" + text + "</PDBx:text>\n");
			ow.write(indent + "</PDBx:pdbx_database_remark>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
