package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_ENTITY_ANNOTATION category specify
 *  additional annotation relevant to the molecular entities.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_entity_annotationCategory>
 *  <PDBx:pdbx_entity_annotation entity_id="1" type="molecular function">
 *  <PDBx:text>antigen binding</PDBx:text>
 *  <PDBx:support> Experimentally verified with fluroescent antigen using flow cytometry</PDBx:support>
 *  </PDBx:pdbx_entity_annotation>
 *  </PDBx:pdbx_entity_annotationCategory>
 * </pre>
 */
public class Pdbx_entity_annotation extends org.pdb.beans.Pdbx_entity_annotation implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_entity_annotation";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_entity_annotation()
	{
	}

	/** Full constructor */
	public Pdbx_entity_annotation(
		Datablock datablock,
		java.lang.String entity_id,
		java.lang.String support,
		java.lang.String text,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.entity_id = entity_id;
		this.support = support;
		this.text = text;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_entity_annotation");
		sb.append("\n");
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (support != null)
		{
			sb.append("support = ");
			sb.append(support);
			sb.append('\n');
		}
		if (text != null)
		{
			sb.append("text = ");
			sb.append(text);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		entity_id = null;
		support = null;
		text = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_entity_annotation)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_entity_annotation>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (support != null) ow.write(indent + " <PDBx:support>" + support + "</PDBx:support>\n");
			if (text != null) ow.write(indent + " <PDBx:text>" + text + "</PDBx:text>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:pdbx_entity_annotation>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
