package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  This category contains details for the cloning steps used in
 *  the overall protein production process. Each row in PDBX_ENTITY_SRC_GEN_CLONE
 *  should have an equivalent row in either PDBX_ENTITY_SRC_GEN_CLONE_LIGATION or
 *  PDBX_ENTITY_SRC_GEN_CLONE_RECOMBINATION.  If only summary information is
 *  provided data in the later two categories may be omitted.
 */
public class Pdbx_entity_src_gen_clone extends org.pdb.beans.Pdbx_entity_src_gen_clone implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_entity_src_gen_clone";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_entity_src_gen_clone()
	{
	}

	/** Full constructor */
	public Pdbx_entity_src_gen_clone(
		Datablock datablock,
		java.lang.String date,
		java.lang.String end_construct_id,
		java.lang.String entity_id,
		java.lang.String entry_id,
		java.lang.String gene_insert_method,
		java.lang.String marker,
		java.lang.Integer next_step_id,
		java.lang.String purification_details,
		java.lang.String robot_id,
		java.lang.Integer step_id,
		java.lang.String summary,
		java.lang.String transformation_method,
		java.lang.String vector_details,
		java.lang.String vector_name,
		java.lang.String verification_method)
	{
		this.datablock = datablock;
		this.date = date;
		this.end_construct_id = end_construct_id;
		this.entity_id = entity_id;
		this.entry_id = entry_id;
		this.gene_insert_method = gene_insert_method;
		this.marker = marker;
		this.next_step_id = next_step_id;
		this.purification_details = purification_details;
		this.robot_id = robot_id;
		this.step_id = step_id;
		this.summary = summary;
		this.transformation_method = transformation_method;
		this.vector_details = vector_details;
		this.vector_name = vector_name;
		this.verification_method = verification_method;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_entity_src_gen_clone");
		sb.append("\n");
		if (date != null)
		{
			sb.append("date = ");
			sb.append(date);
			sb.append('\n');
		}
		if (end_construct_id != null)
		{
			sb.append("end_construct_id = ");
			sb.append(end_construct_id);
			sb.append('\n');
		}
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (gene_insert_method != null)
		{
			sb.append("gene_insert_method = ");
			sb.append(gene_insert_method);
			sb.append('\n');
		}
		if (marker != null)
		{
			sb.append("marker = ");
			sb.append(marker);
			sb.append('\n');
		}
		if (next_step_id != null)
		{
			sb.append("next_step_id = ");
			sb.append(next_step_id);
			sb.append('\n');
		}
		if (purification_details != null)
		{
			sb.append("purification_details = ");
			sb.append(purification_details);
			sb.append('\n');
		}
		if (robot_id != null)
		{
			sb.append("robot_id = ");
			sb.append(robot_id);
			sb.append('\n');
		}
		if (step_id != null)
		{
			sb.append("step_id = ");
			sb.append(step_id);
			sb.append('\n');
		}
		if (summary != null)
		{
			sb.append("summary = ");
			sb.append(summary);
			sb.append('\n');
		}
		if (transformation_method != null)
		{
			sb.append("transformation_method = ");
			sb.append(transformation_method);
			sb.append('\n');
		}
		if (vector_details != null)
		{
			sb.append("vector_details = ");
			sb.append(vector_details);
			sb.append('\n');
		}
		if (vector_name != null)
		{
			sb.append("vector_name = ");
			sb.append(vector_name);
			sb.append('\n');
		}
		if (verification_method != null)
		{
			sb.append("verification_method = ");
			sb.append(verification_method);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		date = null;
		end_construct_id = null;
		entity_id = null;
		entry_id = null;
		gene_insert_method = null;
		marker = null;
		next_step_id = null;
		purification_details = null;
		robot_id = null;
		step_id = null;
		summary = null;
		transformation_method = null;
		vector_details = null;
		vector_name = null;
		verification_method = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_entity_src_gen_clone)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_entity_src_gen_clone>\n");
			if (date != null) ow.write(indent + " <PDBx:date>" + date + "</PDBx:date>\n");
			if (end_construct_id != null) ow.write(indent + " <PDBx:end_construct_id>" + end_construct_id + "</PDBx:end_construct_id>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (gene_insert_method != null) ow.write(indent + " <PDBx:gene_insert_method>" + gene_insert_method + "</PDBx:gene_insert_method>\n");
			if (marker != null) ow.write(indent + " <PDBx:marker>" + marker + "</PDBx:marker>\n");
			if (next_step_id != null) ow.write(indent + " <PDBx:next_step_id>" + next_step_id + "</PDBx:next_step_id>\n");
			if (purification_details != null) ow.write(indent + " <PDBx:purification_details>" + purification_details + "</PDBx:purification_details>\n");
			if (robot_id != null) ow.write(indent + " <PDBx:robot_id>" + robot_id + "</PDBx:robot_id>\n");
			if (step_id != null) ow.write(indent + " <PDBx:step_id>" + step_id + "</PDBx:step_id>\n");
			if (summary != null) ow.write(indent + " <PDBx:summary>" + summary + "</PDBx:summary>\n");
			if (transformation_method != null) ow.write(indent + " <PDBx:transformation_method>" + transformation_method + "</PDBx:transformation_method>\n");
			if (vector_details != null) ow.write(indent + " <PDBx:vector_details>" + vector_details + "</PDBx:vector_details>\n");
			if (vector_name != null) ow.write(indent + " <PDBx:vector_name>" + vector_name + "</PDBx:vector_name>\n");
			if (verification_method != null) ow.write(indent + " <PDBx:verification_method>" + verification_method + "</PDBx:verification_method>\n");
			ow.write(indent + "</PDBx:pdbx_entity_src_gen_clone>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
