package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  This category contains details for the ligation-based cloning steps used in
 *  the overall protein production process.
 *  attribute clone_step_id in category pdbx_entity_src_gen_clone_ligation in this category
 *  must point at a defined  attribute step_id in category pdbx_entity_src_gen_clone.  The details in
 *  PDBX_ENTITY_SRC_GEN_CLONE_LIGATION extend the details in PDBX_ENTITY_SRC_GEN_CLONE
 *  to cover ligation dependent cloning steps.
 */
public class Pdbx_entity_src_gen_clone_ligation extends org.pdb.beans.Pdbx_entity_src_gen_clone_ligation implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_entity_src_gen_clone_ligation";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_entity_src_gen_clone_ligation()
	{
	}

	/** Full constructor */
	public Pdbx_entity_src_gen_clone_ligation(
		Datablock datablock,
		java.lang.String cleavage_enzymes,
		java.lang.String details,
		java.lang.String entity_id,
		java.lang.String entry_id,
		java.lang.String ligation_enzymes,
		java.lang.Integer step_id,
		java.lang.Float temperature,
		java.lang.Float time)
	{
		this.datablock = datablock;
		this.cleavage_enzymes = cleavage_enzymes;
		this.details = details;
		this.entity_id = entity_id;
		this.entry_id = entry_id;
		this.ligation_enzymes = ligation_enzymes;
		this.step_id = step_id;
		this.temperature = temperature;
		this.time = time;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_entity_src_gen_clone_ligation");
		sb.append("\n");
		if (cleavage_enzymes != null)
		{
			sb.append("cleavage_enzymes = ");
			sb.append(cleavage_enzymes);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (ligation_enzymes != null)
		{
			sb.append("ligation_enzymes = ");
			sb.append(ligation_enzymes);
			sb.append('\n');
		}
		if (step_id != null)
		{
			sb.append("step_id = ");
			sb.append(step_id);
			sb.append('\n');
		}
		if (temperature != null)
		{
			sb.append("temperature = ");
			sb.append(temperature);
			sb.append('\n');
		}
		if (time != null)
		{
			sb.append("time = ");
			sb.append(time);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		cleavage_enzymes = null;
		details = null;
		entity_id = null;
		entry_id = null;
		ligation_enzymes = null;
		step_id = null;
		temperature = null;
		time = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_entity_src_gen_clone_ligation)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_entity_src_gen_clone_ligation>\n");
			if (cleavage_enzymes != null) ow.write(indent + " <PDBx:cleavage_enzymes>" + cleavage_enzymes + "</PDBx:cleavage_enzymes>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (ligation_enzymes != null) ow.write(indent + " <PDBx:ligation_enzymes>" + ligation_enzymes + "</PDBx:ligation_enzymes>\n");
			if (step_id != null) ow.write(indent + " <PDBx:step_id>" + step_id + "</PDBx:step_id>\n");
			if (temperature != null) ow.write(indent + " <PDBx:temperature>" + temperature + "</PDBx:temperature>\n");
			if (time != null) ow.write(indent + " <PDBx:time>" + time + "</PDBx:time>\n");
			ow.write(indent + "</PDBx:pdbx_entity_src_gen_clone_ligation>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
