package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  This category contains details for the fraction steps used in
 *  the overall protein production process. Examples of fractionation
 *  steps are centrifugation and magnetic bead pull-down purification.
 */
public class Pdbx_entity_src_gen_fract extends org.pdb.beans.Pdbx_entity_src_gen_fract implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_entity_src_gen_fract";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_entity_src_gen_fract()
	{
	}

	/** Full constructor */
	public Pdbx_entity_src_gen_fract(
		Datablock datablock,
		java.lang.String date,
		java.lang.String details,
		java.lang.String end_construct_id,
		java.lang.String entity_id,
		java.lang.String entry_id,
		java.lang.String method,
		java.lang.Integer next_step_id,
		java.lang.String protein_location,
		java.lang.Float protein_volume,
		java.lang.Float protein_yield,
		java.lang.String protein_yield_method,
		java.lang.String robot_id,
		java.lang.Integer step_id,
		java.lang.Float temperature)
	{
		this.datablock = datablock;
		this.date = date;
		this.details = details;
		this.end_construct_id = end_construct_id;
		this.entity_id = entity_id;
		this.entry_id = entry_id;
		this.method = method;
		this.next_step_id = next_step_id;
		this.protein_location = protein_location;
		this.protein_volume = protein_volume;
		this.protein_yield = protein_yield;
		this.protein_yield_method = protein_yield_method;
		this.robot_id = robot_id;
		this.step_id = step_id;
		this.temperature = temperature;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_entity_src_gen_fract");
		sb.append("\n");
		if (date != null)
		{
			sb.append("date = ");
			sb.append(date);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (end_construct_id != null)
		{
			sb.append("end_construct_id = ");
			sb.append(end_construct_id);
			sb.append('\n');
		}
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		if (next_step_id != null)
		{
			sb.append("next_step_id = ");
			sb.append(next_step_id);
			sb.append('\n');
		}
		if (protein_location != null)
		{
			sb.append("protein_location = ");
			sb.append(protein_location);
			sb.append('\n');
		}
		if (protein_volume != null)
		{
			sb.append("protein_volume = ");
			sb.append(protein_volume);
			sb.append('\n');
		}
		if (protein_yield != null)
		{
			sb.append("protein_yield = ");
			sb.append(protein_yield);
			sb.append('\n');
		}
		if (protein_yield_method != null)
		{
			sb.append("protein_yield_method = ");
			sb.append(protein_yield_method);
			sb.append('\n');
		}
		if (robot_id != null)
		{
			sb.append("robot_id = ");
			sb.append(robot_id);
			sb.append('\n');
		}
		if (step_id != null)
		{
			sb.append("step_id = ");
			sb.append(step_id);
			sb.append('\n');
		}
		if (temperature != null)
		{
			sb.append("temperature = ");
			sb.append(temperature);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		date = null;
		details = null;
		end_construct_id = null;
		entity_id = null;
		entry_id = null;
		method = null;
		next_step_id = null;
		protein_location = null;
		protein_volume = null;
		protein_yield = null;
		protein_yield_method = null;
		robot_id = null;
		step_id = null;
		temperature = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_entity_src_gen_fract)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_entity_src_gen_fract>\n");
			if (date != null) ow.write(indent + " <PDBx:date>" + date + "</PDBx:date>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (end_construct_id != null) ow.write(indent + " <PDBx:end_construct_id>" + end_construct_id + "</PDBx:end_construct_id>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			if (next_step_id != null) ow.write(indent + " <PDBx:next_step_id>" + next_step_id + "</PDBx:next_step_id>\n");
			if (protein_location != null) ow.write(indent + " <PDBx:protein_location>" + protein_location + "</PDBx:protein_location>\n");
			if (protein_volume != null) ow.write(indent + " <PDBx:protein_volume>" + protein_volume + "</PDBx:protein_volume>\n");
			if (protein_yield != null) ow.write(indent + " <PDBx:protein_yield>" + protein_yield + "</PDBx:protein_yield>\n");
			if (protein_yield_method != null) ow.write(indent + " <PDBx:protein_yield_method>" + protein_yield_method + "</PDBx:protein_yield_method>\n");
			if (robot_id != null) ow.write(indent + " <PDBx:robot_id>" + robot_id + "</PDBx:robot_id>\n");
			if (step_id != null) ow.write(indent + " <PDBx:step_id>" + step_id + "</PDBx:step_id>\n");
			if (temperature != null) ow.write(indent + " <PDBx:temperature>" + temperature + "</PDBx:temperature>\n");
			ow.write(indent + "</PDBx:pdbx_entity_src_gen_fract>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
