package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  This category contains details for the DIGEST steps used in
 *  the overall protein production process. The digestion is assumed
 *  to be applied to the result of the previous production step, or the
 *  gene source if this is the first production step.
 *  
 * <pre>
 *  Example 1 - hypothetical example
 *  <PDBx:pdbx_entity_src_gen_prod_digestCategory>
 *  <PDBx:pdbx_entity_src_gen_prod_digest entry_id="111000111" entity_id="222000111" step_id="2">
 *  <PDBx:next_step_id>3</PDBx:next_step_id>
 *  <PDBx:end_construct_id>440050000123</PDBx:end_construct_id>
 *  <PDBx:robot_id>5</PDBx:robot_id>
 *  <PDBx:date>2002-07-12:15:13</PDBx:date>
 *  <PDBx:restriction_enzyme_1>NcoI</PDBx:restriction_enzyme_1>
 *  <PDBx:restriction_enzyme_2>BamII</PDBx:restriction_enzyme_2>
 *  <PDBx:purification_details>  No purification</PDBx:purification_details>
 *  </PDBx:pdbx_entity_src_gen_prod_digest>
 *  </PDBx:pdbx_entity_src_gen_prod_digestCategory>
 * </pre>
 */
public class Pdbx_entity_src_gen_prod_digest extends org.pdb.beans.Pdbx_entity_src_gen_prod_digest implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_entity_src_gen_prod_digest";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_entity_src_gen_prod_digest()
	{
	}

	/** Full constructor */
	public Pdbx_entity_src_gen_prod_digest(
		Datablock datablock,
		java.lang.String date,
		java.lang.String end_construct_id,
		java.lang.String entity_id,
		java.lang.String entry_id,
		java.lang.Integer next_step_id,
		java.lang.String purification_details,
		java.lang.String restriction_enzyme_1,
		java.lang.String restriction_enzyme_2,
		java.lang.String robot_id,
		java.lang.Integer step_id,
		java.lang.String summary)
	{
		this.datablock = datablock;
		this.date = date;
		this.end_construct_id = end_construct_id;
		this.entity_id = entity_id;
		this.entry_id = entry_id;
		this.next_step_id = next_step_id;
		this.purification_details = purification_details;
		this.restriction_enzyme_1 = restriction_enzyme_1;
		this.restriction_enzyme_2 = restriction_enzyme_2;
		this.robot_id = robot_id;
		this.step_id = step_id;
		this.summary = summary;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_entity_src_gen_prod_digest");
		sb.append("\n");
		if (date != null)
		{
			sb.append("date = ");
			sb.append(date);
			sb.append('\n');
		}
		if (end_construct_id != null)
		{
			sb.append("end_construct_id = ");
			sb.append(end_construct_id);
			sb.append('\n');
		}
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (next_step_id != null)
		{
			sb.append("next_step_id = ");
			sb.append(next_step_id);
			sb.append('\n');
		}
		if (purification_details != null)
		{
			sb.append("purification_details = ");
			sb.append(purification_details);
			sb.append('\n');
		}
		if (restriction_enzyme_1 != null)
		{
			sb.append("restriction_enzyme_1 = ");
			sb.append(restriction_enzyme_1);
			sb.append('\n');
		}
		if (restriction_enzyme_2 != null)
		{
			sb.append("restriction_enzyme_2 = ");
			sb.append(restriction_enzyme_2);
			sb.append('\n');
		}
		if (robot_id != null)
		{
			sb.append("robot_id = ");
			sb.append(robot_id);
			sb.append('\n');
		}
		if (step_id != null)
		{
			sb.append("step_id = ");
			sb.append(step_id);
			sb.append('\n');
		}
		if (summary != null)
		{
			sb.append("summary = ");
			sb.append(summary);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		date = null;
		end_construct_id = null;
		entity_id = null;
		entry_id = null;
		next_step_id = null;
		purification_details = null;
		restriction_enzyme_1 = null;
		restriction_enzyme_2 = null;
		robot_id = null;
		step_id = null;
		summary = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_entity_src_gen_prod_digest)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_entity_src_gen_prod_digest>\n");
			if (date != null) ow.write(indent + " <PDBx:date>" + date + "</PDBx:date>\n");
			if (end_construct_id != null) ow.write(indent + " <PDBx:end_construct_id>" + end_construct_id + "</PDBx:end_construct_id>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (next_step_id != null) ow.write(indent + " <PDBx:next_step_id>" + next_step_id + "</PDBx:next_step_id>\n");
			if (purification_details != null) ow.write(indent + " <PDBx:purification_details>" + purification_details + "</PDBx:purification_details>\n");
			if (restriction_enzyme_1 != null) ow.write(indent + " <PDBx:restriction_enzyme_1>" + restriction_enzyme_1 + "</PDBx:restriction_enzyme_1>\n");
			if (restriction_enzyme_2 != null) ow.write(indent + " <PDBx:restriction_enzyme_2>" + restriction_enzyme_2 + "</PDBx:restriction_enzyme_2>\n");
			if (robot_id != null) ow.write(indent + " <PDBx:robot_id>" + robot_id + "</PDBx:robot_id>\n");
			if (step_id != null) ow.write(indent + " <PDBx:step_id>" + step_id + "</PDBx:step_id>\n");
			if (summary != null) ow.write(indent + " <PDBx:summary>" + summary + "</PDBx:summary>\n");
			ow.write(indent + "</PDBx:pdbx_entity_src_gen_prod_digest>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
