package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  This category contains details for the PCR steps used in
 *  the overall protein production process. The PCR is assumed
 *  to be applied to the result of the previous production step, or the
 *  gene source if this is the first production step.
 *  
 * <pre>
 *  Example 1 - hypothetical example
 *  <PDBx:pdbx_entity_src_gen_prod_pcrCategory>
 *  <PDBx:pdbx_entity_src_gen_prod_pcr entry_id="111000111" entity_id="222000111" step_id="1">
 *  <PDBx:next_step_id>2</PDBx:next_step_id>
 *  <PDBx:end_construct_id>440050000111</PDBx:end_construct_id>
 *  <PDBx:robot_id>5</PDBx:robot_id>
 *  <PDBx:date>2002-07-12:15:13</PDBx:date>
 *  <PDBx:forward_primer_id>2</PDBx:forward_primer_id>
 *  <PDBx:reverse_primer_id>3</PDBx:reverse_primer_id>
 *  <PDBx:reaction_details>  Annealing temperature = 70 C
 *  Annealing time = 60 s
 *  Extending temperature = 74 C
 *  Extending time = 120 s
 *  Melting temperature = 95 C
 *  Melting time = 120 s
 *  Number of cycles = 40
 *  Polymerase = KOD
 *  Template = 10 pmol
 *  Primer = 25 pmol
 *  Total volume = 25 ul</PDBx:reaction_details>
 *  <PDBx:purification_details>  No purification</PDBx:purification_details>
 *  </PDBx:pdbx_entity_src_gen_prod_pcr>
 *  </PDBx:pdbx_entity_src_gen_prod_pcrCategory>
 * </pre>
 */
public class Pdbx_entity_src_gen_prod_pcr extends org.pdb.beans.Pdbx_entity_src_gen_prod_pcr implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_entity_src_gen_prod_pcr";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_entity_src_gen_prod_pcr()
	{
	}

	/** Full constructor */
	public Pdbx_entity_src_gen_prod_pcr(
		Datablock datablock,
		java.lang.String date,
		java.lang.String end_construct_id,
		java.lang.String entity_id,
		java.lang.String entry_id,
		java.lang.String forward_primer_id,
		java.lang.Integer next_step_id,
		java.lang.String purification_details,
		java.lang.String reaction_details,
		java.lang.String reverse_primer_id,
		java.lang.String robot_id,
		java.lang.Integer step_id,
		java.lang.String summary)
	{
		this.datablock = datablock;
		this.date = date;
		this.end_construct_id = end_construct_id;
		this.entity_id = entity_id;
		this.entry_id = entry_id;
		this.forward_primer_id = forward_primer_id;
		this.next_step_id = next_step_id;
		this.purification_details = purification_details;
		this.reaction_details = reaction_details;
		this.reverse_primer_id = reverse_primer_id;
		this.robot_id = robot_id;
		this.step_id = step_id;
		this.summary = summary;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_entity_src_gen_prod_pcr");
		sb.append("\n");
		if (date != null)
		{
			sb.append("date = ");
			sb.append(date);
			sb.append('\n');
		}
		if (end_construct_id != null)
		{
			sb.append("end_construct_id = ");
			sb.append(end_construct_id);
			sb.append('\n');
		}
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (forward_primer_id != null)
		{
			sb.append("forward_primer_id = ");
			sb.append(forward_primer_id);
			sb.append('\n');
		}
		if (next_step_id != null)
		{
			sb.append("next_step_id = ");
			sb.append(next_step_id);
			sb.append('\n');
		}
		if (purification_details != null)
		{
			sb.append("purification_details = ");
			sb.append(purification_details);
			sb.append('\n');
		}
		if (reaction_details != null)
		{
			sb.append("reaction_details = ");
			sb.append(reaction_details);
			sb.append('\n');
		}
		if (reverse_primer_id != null)
		{
			sb.append("reverse_primer_id = ");
			sb.append(reverse_primer_id);
			sb.append('\n');
		}
		if (robot_id != null)
		{
			sb.append("robot_id = ");
			sb.append(robot_id);
			sb.append('\n');
		}
		if (step_id != null)
		{
			sb.append("step_id = ");
			sb.append(step_id);
			sb.append('\n');
		}
		if (summary != null)
		{
			sb.append("summary = ");
			sb.append(summary);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		date = null;
		end_construct_id = null;
		entity_id = null;
		entry_id = null;
		forward_primer_id = null;
		next_step_id = null;
		purification_details = null;
		reaction_details = null;
		reverse_primer_id = null;
		robot_id = null;
		step_id = null;
		summary = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_entity_src_gen_prod_pcr)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_entity_src_gen_prod_pcr>\n");
			if (date != null) ow.write(indent + " <PDBx:date>" + date + "</PDBx:date>\n");
			if (end_construct_id != null) ow.write(indent + " <PDBx:end_construct_id>" + end_construct_id + "</PDBx:end_construct_id>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (forward_primer_id != null) ow.write(indent + " <PDBx:forward_primer_id>" + forward_primer_id + "</PDBx:forward_primer_id>\n");
			if (next_step_id != null) ow.write(indent + " <PDBx:next_step_id>" + next_step_id + "</PDBx:next_step_id>\n");
			if (purification_details != null) ow.write(indent + " <PDBx:purification_details>" + purification_details + "</PDBx:purification_details>\n");
			if (reaction_details != null) ow.write(indent + " <PDBx:reaction_details>" + reaction_details + "</PDBx:reaction_details>\n");
			if (reverse_primer_id != null) ow.write(indent + " <PDBx:reverse_primer_id>" + reverse_primer_id + "</PDBx:reverse_primer_id>\n");
			if (robot_id != null) ow.write(indent + " <PDBx:robot_id>" + robot_id + "</PDBx:robot_id>\n");
			if (step_id != null) ow.write(indent + " <PDBx:step_id>" + step_id + "</PDBx:step_id>\n");
			if (summary != null) ow.write(indent + " <PDBx:summary>" + summary + "</PDBx:summary>\n");
			ow.write(indent + "</PDBx:pdbx_entity_src_gen_prod_pcr>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
