package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_EXPTL_CRYSTAL_GROW_SOL category record
 *  details about the solutions that were 'mixed'
 *  to produce the crystal.
 *  
 * <pre>
 *  Example 1
 *  <PDBx:pdbx_exptl_crystal_grow_solCategory>
 *  <PDBx:pdbx_exptl_crystal_grow_sol crystal_id="1" sol_id="protein">
 *  <PDBx:volume>0.5</PDBx:volume>
 *  <PDBx:volume_units>microliter</PDBx:volume_units>
 *  <PDBx:pH>7.5</PDBx:pH>
 *  </PDBx:pdbx_exptl_crystal_grow_sol>
 *  <PDBx:pdbx_exptl_crystal_grow_sol crystal_id="1" sol_id="precipitant">
 *  <PDBx:volume>0.5</PDBx:volume>
 *  <PDBx:volume_units>microliter</PDBx:volume_units>
 *  <PDBx:pH>7.3</PDBx:pH>
 *  </PDBx:pdbx_exptl_crystal_grow_sol>
 *  <PDBx:pdbx_exptl_crystal_grow_sol crystal_id="1" sol_id="reservoir">
 *  <PDBx:volume>0.5</PDBx:volume>
 *  <PDBx:volume_units>milliliter</PDBx:volume_units>
 *  <PDBx:pH>7.3</PDBx:pH>
 *  </PDBx:pdbx_exptl_crystal_grow_sol>
 *  </PDBx:pdbx_exptl_crystal_grow_solCategory>
 * </pre>
 */
public class Pdbx_exptl_crystal_grow_sol extends org.pdb.beans.Pdbx_exptl_crystal_grow_sol implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_exptl_crystal_grow_sol";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_exptl_crystal_grow_sol()
	{
	}

	/** Full constructor */
	public Pdbx_exptl_crystal_grow_sol(
		Datablock datablock,
		java.lang.String crystal_id,
		java.lang.Float pH,
		java.lang.String sol_id,
		java.lang.Float volume,
		java.lang.String volume_units)
	{
		this.datablock = datablock;
		this.crystal_id = crystal_id;
		this.pH = pH;
		this.sol_id = sol_id;
		this.volume = volume;
		this.volume_units = volume_units;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_exptl_crystal_grow_sol");
		sb.append("\n");
		if (crystal_id != null)
		{
			sb.append("crystal_id = ");
			sb.append(crystal_id);
			sb.append('\n');
		}
		if (pH != null)
		{
			sb.append("pH = ");
			sb.append(pH);
			sb.append('\n');
		}
		if (sol_id != null)
		{
			sb.append("sol_id = ");
			sb.append(sol_id);
			sb.append('\n');
		}
		if (volume != null)
		{
			sb.append("volume = ");
			sb.append(volume);
			sb.append('\n');
		}
		if (volume_units != null)
		{
			sb.append("volume_units = ");
			sb.append(volume_units);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		crystal_id = null;
		pH = null;
		sol_id = null;
		volume = null;
		volume_units = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_exptl_crystal_grow_sol)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_exptl_crystal_grow_sol>\n");
			if (crystal_id != null) ow.write(indent + " <PDBx:crystal_id>" + crystal_id + "</PDBx:crystal_id>\n");
			if (pH != null) ow.write(indent + " <PDBx:pH>" + pH + "</PDBx:pH>\n");
			if (sol_id != null) ow.write(indent + " <PDBx:sol_id>" + sol_id + "</PDBx:sol_id>\n");
			if (volume != null) ow.write(indent + " <PDBx:volume>" + volume + "</PDBx:volume>\n");
			if (volume_units != null) ow.write(indent + " <PDBx:volume_units>" + volume_units + "</PDBx:volume_units>\n");
			ow.write(indent + "</PDBx:pdbx_exptl_crystal_grow_sol>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
