package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the pdbx_exptl_pd record information about
 *  powder sample preparations.
 */
public class Pdbx_exptl_pd extends org.pdb.beans.Pdbx_exptl_pd implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_exptl_pd";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_exptl_pd()
	{
	}

	/** Full constructor */
	public Pdbx_exptl_pd(
		Datablock datablock,
		java.lang.String entry_id,
		java.lang.String spec_preparation,
		java.lang.Float spec_preparation_pH,
		java.lang.String spec_preparation_pH_range)
	{
		this.datablock = datablock;
		this.entry_id = entry_id;
		this.spec_preparation = spec_preparation;
		this.spec_preparation_pH = spec_preparation_pH;
		this.spec_preparation_pH_range = spec_preparation_pH_range;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_exptl_pd");
		sb.append("\n");
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (spec_preparation != null)
		{
			sb.append("spec_preparation = ");
			sb.append(spec_preparation);
			sb.append('\n');
		}
		if (spec_preparation_pH != null)
		{
			sb.append("spec_preparation_pH = ");
			sb.append(spec_preparation_pH);
			sb.append('\n');
		}
		if (spec_preparation_pH_range != null)
		{
			sb.append("spec_preparation_pH_range = ");
			sb.append(spec_preparation_pH_range);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		entry_id = null;
		spec_preparation = null;
		spec_preparation_pH = null;
		spec_preparation_pH_range = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_exptl_pd)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_exptl_pd>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (spec_preparation != null) ow.write(indent + " <PDBx:spec_preparation>" + spec_preparation + "</PDBx:spec_preparation>\n");
			if (spec_preparation_pH != null) ow.write(indent + " <PDBx:spec_preparation_pH>" + spec_preparation_pH + "</PDBx:spec_preparation_pH>\n");
			if (spec_preparation_pH_range != null) ow.write(indent + " <PDBx:spec_preparation_pH_range>" + spec_preparation_pH_range + "</PDBx:spec_preparation_pH_range>\n");
			ow.write(indent + "</PDBx:pdbx_exptl_pd>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
