package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_FEATURE_ASSEMBLY category records
 *  information about properties pertaining to this
 *  structural assembly.
 *  
 * <pre>
 *  Example 1 - Biological process for functional assembly
 *  <PDBx:pdbx_feature_assemblyCategory>
 *  <PDBx:pdbx_feature_assembly id="1">
 *  <PDBx:assembly_id>b1</PDBx:assembly_id>
 *  <PDBx:feature_name>biological process</PDBx:feature_name>
 *  <PDBx:feature>nitrogen metabolism</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>GO</PDBx:feature_assigned_by>
 *  <PDBx:feature_citation_id>GO</PDBx:feature_citation_id>
 *  </PDBx:pdbx_feature_assembly>
 *  </PDBx:pdbx_feature_assemblyCategory>
 * </pre>
 */
public class Pdbx_feature_assembly extends org.pdb.beans.Pdbx_feature_assembly implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_feature_assembly";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_feature_assembly()
	{
	}

	/** Full constructor */
	public Pdbx_feature_assembly(
		Datablock datablock,
		java.lang.String assembly_id,
		java.lang.String feature,
		java.lang.String feature_assigned_by,
		java.lang.String feature_citation_id,
		java.lang.String feature_identifier,
		java.lang.String feature_name,
		java.lang.String feature_software_id,
		java.lang.String feature_type,
		java.lang.String id_)
	{
		this.datablock = datablock;
		this.assembly_id = assembly_id;
		this.feature = feature;
		this.feature_assigned_by = feature_assigned_by;
		this.feature_citation_id = feature_citation_id;
		this.feature_identifier = feature_identifier;
		this.feature_name = feature_name;
		this.feature_software_id = feature_software_id;
		this.feature_type = feature_type;
		this.id_ = id_;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_feature_assembly");
		sb.append("\n");
		if (assembly_id != null)
		{
			sb.append("assembly_id = ");
			sb.append(assembly_id);
			sb.append('\n');
		}
		if (feature != null)
		{
			sb.append("feature = ");
			sb.append(feature);
			sb.append('\n');
		}
		if (feature_assigned_by != null)
		{
			sb.append("feature_assigned_by = ");
			sb.append(feature_assigned_by);
			sb.append('\n');
		}
		if (feature_citation_id != null)
		{
			sb.append("feature_citation_id = ");
			sb.append(feature_citation_id);
			sb.append('\n');
		}
		if (feature_identifier != null)
		{
			sb.append("feature_identifier = ");
			sb.append(feature_identifier);
			sb.append('\n');
		}
		if (feature_name != null)
		{
			sb.append("feature_name = ");
			sb.append(feature_name);
			sb.append('\n');
		}
		if (feature_software_id != null)
		{
			sb.append("feature_software_id = ");
			sb.append(feature_software_id);
			sb.append('\n');
		}
		if (feature_type != null)
		{
			sb.append("feature_type = ");
			sb.append(feature_type);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		assembly_id = null;
		feature = null;
		feature_assigned_by = null;
		feature_citation_id = null;
		feature_identifier = null;
		feature_name = null;
		feature_software_id = null;
		feature_type = null;
		id_ = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_feature_assembly)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_feature_assembly>\n");
			if (assembly_id != null) ow.write(indent + " <PDBx:assembly_id>" + assembly_id + "</PDBx:assembly_id>\n");
			if (feature != null) ow.write(indent + " <PDBx:feature>" + feature + "</PDBx:feature>\n");
			if (feature_assigned_by != null) ow.write(indent + " <PDBx:feature_assigned_by>" + feature_assigned_by + "</PDBx:feature_assigned_by>\n");
			if (feature_citation_id != null) ow.write(indent + " <PDBx:feature_citation_id>" + feature_citation_id + "</PDBx:feature_citation_id>\n");
			if (feature_identifier != null) ow.write(indent + " <PDBx:feature_identifier>" + feature_identifier + "</PDBx:feature_identifier>\n");
			if (feature_name != null) ow.write(indent + " <PDBx:feature_name>" + feature_name + "</PDBx:feature_name>\n");
			if (feature_software_id != null) ow.write(indent + " <PDBx:feature_software_id>" + feature_software_id + "</PDBx:feature_software_id>\n");
			if (feature_type != null) ow.write(indent + " <PDBx:feature_type>" + feature_type + "</PDBx:feature_type>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			ow.write(indent + "</PDBx:pdbx_feature_assembly>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
