package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_FEATURE_MONOMER category records
 *  information about properties pertaining to particular
 *  monomers in this structure.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_feature_monomerCategory>
 *  <PDBx:pdbx_feature_monomer id="1">
 *  <PDBx:label_alt_id xsi:nil="true" />
 *  <PDBx:label_asym_id>A</PDBx:label_asym_id>
 *  <PDBx:label_comp_id>ASP</PDBx:label_comp_id>
 *  <PDBx:label_seq_id>1</PDBx:label_seq_id>
 *  <PDBx:feature_name>SASA</PDBx:feature_name>
 *  <PDBx:feature>129.4</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>POPS</PDBx:feature_assigned_by>
 *  <PDBx:feature_citation_id>pops</PDBx:feature_citation_id>
 *  </PDBx:pdbx_feature_monomer>
 *  <PDBx:pdbx_feature_monomer id="1">
 *  <PDBx:label_alt_id xsi:nil="true" />
 *  <PDBx:label_asym_id>A</PDBx:label_asym_id>
 *  <PDBx:label_comp_id>ILE</PDBx:label_comp_id>
 *  <PDBx:label_seq_id>2</PDBx:label_seq_id>
 *  <PDBx:feature_name>SASA</PDBx:feature_name>
 *  <PDBx:feature>35.5</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>POPS</PDBx:feature_assigned_by>
 *  <PDBx:feature_citation_id>pops</PDBx:feature_citation_id>
 *  </PDBx:pdbx_feature_monomer>
 *  <PDBx:pdbx_feature_monomer id="1">
 *  <PDBx:label_alt_id xsi:nil="true" />
 *  <PDBx:label_asym_id>A</PDBx:label_asym_id>
 *  <PDBx:label_comp_id>VAL</PDBx:label_comp_id>
 *  <PDBx:label_seq_id>3</PDBx:label_seq_id>
 *  <PDBx:feature_name>SASA</PDBx:feature_name>
 *  <PDBx:feature>87.2</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>POPS</PDBx:feature_assigned_by>
 *  <PDBx:feature_citation_id>pops</PDBx:feature_citation_id>
 *  </PDBx:pdbx_feature_monomer>
 *  </PDBx:pdbx_feature_monomerCategory>
 * </pre>
 */
public class Pdbx_feature_monomer extends org.pdb.beans.Pdbx_feature_monomer implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_feature_monomer";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_feature_monomer()
	{
	}

	/** Full constructor */
	public Pdbx_feature_monomer(
		Datablock datablock,
		java.lang.String auth_asym_id,
		java.lang.String auth_comp_id,
		java.lang.String auth_seq_id,
		java.lang.String feature,
		java.lang.String feature_assigned_by,
		java.lang.String feature_citation_id,
		java.lang.String feature_identifier,
		java.lang.String feature_name,
		java.lang.String feature_software_id,
		java.lang.String feature_type,
		java.lang.String id_,
		java.lang.String label_alt_id,
		java.lang.String label_asym_id,
		java.lang.String label_comp_id,
		java.lang.Integer label_seq_id)
	{
		this.datablock = datablock;
		this.auth_asym_id = auth_asym_id;
		this.auth_comp_id = auth_comp_id;
		this.auth_seq_id = auth_seq_id;
		this.feature = feature;
		this.feature_assigned_by = feature_assigned_by;
		this.feature_citation_id = feature_citation_id;
		this.feature_identifier = feature_identifier;
		this.feature_name = feature_name;
		this.feature_software_id = feature_software_id;
		this.feature_type = feature_type;
		this.id_ = id_;
		this.label_alt_id = label_alt_id;
		this.label_asym_id = label_asym_id;
		this.label_comp_id = label_comp_id;
		this.label_seq_id = label_seq_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_feature_monomer");
		sb.append("\n");
		if (auth_asym_id != null)
		{
			sb.append("auth_asym_id = ");
			sb.append(auth_asym_id);
			sb.append('\n');
		}
		if (auth_comp_id != null)
		{
			sb.append("auth_comp_id = ");
			sb.append(auth_comp_id);
			sb.append('\n');
		}
		if (auth_seq_id != null)
		{
			sb.append("auth_seq_id = ");
			sb.append(auth_seq_id);
			sb.append('\n');
		}
		if (feature != null)
		{
			sb.append("feature = ");
			sb.append(feature);
			sb.append('\n');
		}
		if (feature_assigned_by != null)
		{
			sb.append("feature_assigned_by = ");
			sb.append(feature_assigned_by);
			sb.append('\n');
		}
		if (feature_citation_id != null)
		{
			sb.append("feature_citation_id = ");
			sb.append(feature_citation_id);
			sb.append('\n');
		}
		if (feature_identifier != null)
		{
			sb.append("feature_identifier = ");
			sb.append(feature_identifier);
			sb.append('\n');
		}
		if (feature_name != null)
		{
			sb.append("feature_name = ");
			sb.append(feature_name);
			sb.append('\n');
		}
		if (feature_software_id != null)
		{
			sb.append("feature_software_id = ");
			sb.append(feature_software_id);
			sb.append('\n');
		}
		if (feature_type != null)
		{
			sb.append("feature_type = ");
			sb.append(feature_type);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (label_alt_id != null)
		{
			sb.append("label_alt_id = ");
			sb.append(label_alt_id);
			sb.append('\n');
		}
		if (label_asym_id != null)
		{
			sb.append("label_asym_id = ");
			sb.append(label_asym_id);
			sb.append('\n');
		}
		if (label_comp_id != null)
		{
			sb.append("label_comp_id = ");
			sb.append(label_comp_id);
			sb.append('\n');
		}
		if (label_seq_id != null)
		{
			sb.append("label_seq_id = ");
			sb.append(label_seq_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		auth_asym_id = null;
		auth_comp_id = null;
		auth_seq_id = null;
		feature = null;
		feature_assigned_by = null;
		feature_citation_id = null;
		feature_identifier = null;
		feature_name = null;
		feature_software_id = null;
		feature_type = null;
		id_ = null;
		label_alt_id = null;
		label_asym_id = null;
		label_comp_id = null;
		label_seq_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_feature_monomer)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_feature_monomer>\n");
			if (auth_asym_id != null) ow.write(indent + " <PDBx:auth_asym_id>" + auth_asym_id + "</PDBx:auth_asym_id>\n");
			if (auth_comp_id != null) ow.write(indent + " <PDBx:auth_comp_id>" + auth_comp_id + "</PDBx:auth_comp_id>\n");
			if (auth_seq_id != null) ow.write(indent + " <PDBx:auth_seq_id>" + auth_seq_id + "</PDBx:auth_seq_id>\n");
			if (feature != null) ow.write(indent + " <PDBx:feature>" + feature + "</PDBx:feature>\n");
			if (feature_assigned_by != null) ow.write(indent + " <PDBx:feature_assigned_by>" + feature_assigned_by + "</PDBx:feature_assigned_by>\n");
			if (feature_citation_id != null) ow.write(indent + " <PDBx:feature_citation_id>" + feature_citation_id + "</PDBx:feature_citation_id>\n");
			if (feature_identifier != null) ow.write(indent + " <PDBx:feature_identifier>" + feature_identifier + "</PDBx:feature_identifier>\n");
			if (feature_name != null) ow.write(indent + " <PDBx:feature_name>" + feature_name + "</PDBx:feature_name>\n");
			if (feature_software_id != null) ow.write(indent + " <PDBx:feature_software_id>" + feature_software_id + "</PDBx:feature_software_id>\n");
			if (feature_type != null) ow.write(indent + " <PDBx:feature_type>" + feature_type + "</PDBx:feature_type>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (label_alt_id != null) ow.write(indent + " <PDBx:label_alt_id>" + label_alt_id + "</PDBx:label_alt_id>\n");
			if (label_asym_id != null) ow.write(indent + " <PDBx:label_asym_id>" + label_asym_id + "</PDBx:label_asym_id>\n");
			if (label_comp_id != null) ow.write(indent + " <PDBx:label_comp_id>" + label_comp_id + "</PDBx:label_comp_id>\n");
			if (label_seq_id != null) ow.write(indent + " <PDBx:label_seq_id>" + label_seq_id + "</PDBx:label_seq_id>\n");
			ow.write(indent + "</PDBx:pdbx_feature_monomer>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
