package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  This category contains the information that describes the
 *  ensemble of deposited structures. If only an average structure
 *  has been deposited skip this section.
 *  This example uses the data from the MCP-1 study.
 *  <PDBx:pdbx_nmr_ensembleCategory>
 *  <PDBx:pdbx_nmr_ensemble entry_id="1ABC">
 *  <PDBx:conformers_calculated_total_number>40</PDBx:conformers_calculated_total_number>
 *  <PDBx:conformers_submitted_total_number>20</PDBx:conformers_submitted_total_number>
 *  <PDBx:conformer_selection_criteria>structures with the least restraint violations</PDBx:conformer_selection_criteria>
 *  <PDBx:representative_conformer>1</PDBx:representative_conformer>
 *  </PDBx:pdbx_nmr_ensemble>
 *  </PDBx:pdbx_nmr_ensembleCategory>
 */
public class Pdbx_nmr_ensemble extends org.pdb.beans.Pdbx_nmr_ensemble implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_nmr_ensemble";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_nmr_ensemble()
	{
	}

	/** Full constructor */
	public Pdbx_nmr_ensemble(
		Datablock datablock,
		java.lang.Integer average_constraint_violations_per_residue,
		java.lang.Integer average_constraints_per_residue,
		java.lang.Float average_distance_constraint_violation,
		java.lang.Float average_torsion_angle_constraint_violation,
		java.lang.String conformer_selection_criteria,
		java.lang.Integer conformers_calculated_total_number,
		java.lang.Integer conformers_submitted_total_number,
		java.lang.String distance_constraint_violation_method,
		java.lang.String entry_id,
		java.lang.Float maximum_distance_constraint_violation,
		java.lang.Float maximum_lower_distance_constraint_violation,
		java.lang.Float maximum_torsion_angle_constraint_violation,
		java.lang.Float maximum_upper_distance_constraint_violation,
		java.lang.Integer representative_conformer,
		java.lang.String torsion_angle_constraint_violation_method)
	{
		this.datablock = datablock;
		this.average_constraint_violations_per_residue = average_constraint_violations_per_residue;
		this.average_constraints_per_residue = average_constraints_per_residue;
		this.average_distance_constraint_violation = average_distance_constraint_violation;
		this.average_torsion_angle_constraint_violation = average_torsion_angle_constraint_violation;
		this.conformer_selection_criteria = conformer_selection_criteria;
		this.conformers_calculated_total_number = conformers_calculated_total_number;
		this.conformers_submitted_total_number = conformers_submitted_total_number;
		this.distance_constraint_violation_method = distance_constraint_violation_method;
		this.entry_id = entry_id;
		this.maximum_distance_constraint_violation = maximum_distance_constraint_violation;
		this.maximum_lower_distance_constraint_violation = maximum_lower_distance_constraint_violation;
		this.maximum_torsion_angle_constraint_violation = maximum_torsion_angle_constraint_violation;
		this.maximum_upper_distance_constraint_violation = maximum_upper_distance_constraint_violation;
		this.representative_conformer = representative_conformer;
		this.torsion_angle_constraint_violation_method = torsion_angle_constraint_violation_method;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_nmr_ensemble");
		sb.append("\n");
		if (average_constraint_violations_per_residue != null)
		{
			sb.append("average_constraint_violations_per_residue = ");
			sb.append(average_constraint_violations_per_residue);
			sb.append('\n');
		}
		if (average_constraints_per_residue != null)
		{
			sb.append("average_constraints_per_residue = ");
			sb.append(average_constraints_per_residue);
			sb.append('\n');
		}
		if (average_distance_constraint_violation != null)
		{
			sb.append("average_distance_constraint_violation = ");
			sb.append(average_distance_constraint_violation);
			sb.append('\n');
		}
		if (average_torsion_angle_constraint_violation != null)
		{
			sb.append("average_torsion_angle_constraint_violation = ");
			sb.append(average_torsion_angle_constraint_violation);
			sb.append('\n');
		}
		if (conformer_selection_criteria != null)
		{
			sb.append("conformer_selection_criteria = ");
			sb.append(conformer_selection_criteria);
			sb.append('\n');
		}
		if (conformers_calculated_total_number != null)
		{
			sb.append("conformers_calculated_total_number = ");
			sb.append(conformers_calculated_total_number);
			sb.append('\n');
		}
		if (conformers_submitted_total_number != null)
		{
			sb.append("conformers_submitted_total_number = ");
			sb.append(conformers_submitted_total_number);
			sb.append('\n');
		}
		if (distance_constraint_violation_method != null)
		{
			sb.append("distance_constraint_violation_method = ");
			sb.append(distance_constraint_violation_method);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (maximum_distance_constraint_violation != null)
		{
			sb.append("maximum_distance_constraint_violation = ");
			sb.append(maximum_distance_constraint_violation);
			sb.append('\n');
		}
		if (maximum_lower_distance_constraint_violation != null)
		{
			sb.append("maximum_lower_distance_constraint_violation = ");
			sb.append(maximum_lower_distance_constraint_violation);
			sb.append('\n');
		}
		if (maximum_torsion_angle_constraint_violation != null)
		{
			sb.append("maximum_torsion_angle_constraint_violation = ");
			sb.append(maximum_torsion_angle_constraint_violation);
			sb.append('\n');
		}
		if (maximum_upper_distance_constraint_violation != null)
		{
			sb.append("maximum_upper_distance_constraint_violation = ");
			sb.append(maximum_upper_distance_constraint_violation);
			sb.append('\n');
		}
		if (representative_conformer != null)
		{
			sb.append("representative_conformer = ");
			sb.append(representative_conformer);
			sb.append('\n');
		}
		if (torsion_angle_constraint_violation_method != null)
		{
			sb.append("torsion_angle_constraint_violation_method = ");
			sb.append(torsion_angle_constraint_violation_method);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		average_constraint_violations_per_residue = null;
		average_constraints_per_residue = null;
		average_distance_constraint_violation = null;
		average_torsion_angle_constraint_violation = null;
		conformer_selection_criteria = null;
		conformers_calculated_total_number = null;
		conformers_submitted_total_number = null;
		distance_constraint_violation_method = null;
		entry_id = null;
		maximum_distance_constraint_violation = null;
		maximum_lower_distance_constraint_violation = null;
		maximum_torsion_angle_constraint_violation = null;
		maximum_upper_distance_constraint_violation = null;
		representative_conformer = null;
		torsion_angle_constraint_violation_method = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_nmr_ensemble)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_nmr_ensemble>\n");
			if (average_constraint_violations_per_residue != null) ow.write(indent + " <PDBx:average_constraint_violations_per_residue>" + average_constraint_violations_per_residue + "</PDBx:average_constraint_violations_per_residue>\n");
			if (average_constraints_per_residue != null) ow.write(indent + " <PDBx:average_constraints_per_residue>" + average_constraints_per_residue + "</PDBx:average_constraints_per_residue>\n");
			if (average_distance_constraint_violation != null) ow.write(indent + " <PDBx:average_distance_constraint_violation>" + average_distance_constraint_violation + "</PDBx:average_distance_constraint_violation>\n");
			if (average_torsion_angle_constraint_violation != null) ow.write(indent + " <PDBx:average_torsion_angle_constraint_violation>" + average_torsion_angle_constraint_violation + "</PDBx:average_torsion_angle_constraint_violation>\n");
			if (conformer_selection_criteria != null) ow.write(indent + " <PDBx:conformer_selection_criteria>" + conformer_selection_criteria + "</PDBx:conformer_selection_criteria>\n");
			if (conformers_calculated_total_number != null) ow.write(indent + " <PDBx:conformers_calculated_total_number>" + conformers_calculated_total_number + "</PDBx:conformers_calculated_total_number>\n");
			if (conformers_submitted_total_number != null) ow.write(indent + " <PDBx:conformers_submitted_total_number>" + conformers_submitted_total_number + "</PDBx:conformers_submitted_total_number>\n");
			if (distance_constraint_violation_method != null) ow.write(indent + " <PDBx:distance_constraint_violation_method>" + distance_constraint_violation_method + "</PDBx:distance_constraint_violation_method>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (maximum_distance_constraint_violation != null) ow.write(indent + " <PDBx:maximum_distance_constraint_violation>" + maximum_distance_constraint_violation + "</PDBx:maximum_distance_constraint_violation>\n");
			if (maximum_lower_distance_constraint_violation != null) ow.write(indent + " <PDBx:maximum_lower_distance_constraint_violation>" + maximum_lower_distance_constraint_violation + "</PDBx:maximum_lower_distance_constraint_violation>\n");
			if (maximum_torsion_angle_constraint_violation != null) ow.write(indent + " <PDBx:maximum_torsion_angle_constraint_violation>" + maximum_torsion_angle_constraint_violation + "</PDBx:maximum_torsion_angle_constraint_violation>\n");
			if (maximum_upper_distance_constraint_violation != null) ow.write(indent + " <PDBx:maximum_upper_distance_constraint_violation>" + maximum_upper_distance_constraint_violation + "</PDBx:maximum_upper_distance_constraint_violation>\n");
			if (representative_conformer != null) ow.write(indent + " <PDBx:representative_conformer>" + representative_conformer + "</PDBx:representative_conformer>\n");
			if (torsion_angle_constraint_violation_method != null) ow.write(indent + " <PDBx:torsion_angle_constraint_violation_method>" + torsion_angle_constraint_violation_method + "</PDBx:torsion_angle_constraint_violation_method>\n");
			ow.write(indent + "</PDBx:pdbx_nmr_ensemble>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
