package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Structural statistics are derived from molecular dynamics and simulated annealing
 *  programs.
 *  This example is derived from the MCP-1 structure calculation statistics.
 *  For this  structure the statistics were calculated over residues 5-69 for
 *  both the monomer and dimer .
 *  <PDBx:pdbx_nmr_ensemble_rmsCategory>
 *  <PDBx:pdbx_nmr_ensemble_rms entry_id="1ABC">
 *  <PDBx:residue_range_begin>5</PDBx:residue_range_begin>
 *  <PDBx:chain_range_begin>A</PDBx:chain_range_begin>
 *  <PDBx:residue_range_end>69</PDBx:residue_range_end>
 *  <PDBx:chain_range_end>A</PDBx:chain_range_end>
 *  <PDBx:atom_type>all heavy atoms</PDBx:atom_type>
 *  <PDBx:distance_rms_dev>0.22</PDBx:distance_rms_dev>
 *  <PDBx:distance_rms_dev_error>0.06</PDBx:distance_rms_dev_error>
 *  </PDBx:pdbx_nmr_ensemble_rms>
 *  </PDBx:pdbx_nmr_ensemble_rmsCategory>
 */
public class Pdbx_nmr_ensemble_rms extends org.pdb.beans.Pdbx_nmr_ensemble_rms implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_nmr_ensemble_rms";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_nmr_ensemble_rms()
	{
	}

	/** Full constructor */
	public Pdbx_nmr_ensemble_rms(
		Datablock datablock,
		java.lang.String atom_type,
		java.lang.Float bond_angle_rms_dev,
		java.lang.Float bond_angle_rms_dev_error,
		java.lang.String chain_range_begin,
		java.lang.String chain_range_end,
		java.lang.String coord_average_rmsd_method,
		java.lang.Float covalent_bond_rms_dev,
		java.lang.Float covalent_bond_rms_dev_error,
		java.lang.Float dihedral_angles_rms_dev,
		java.lang.Float dihedral_angles_rms_dev_error,
		java.lang.Float distance_rms_dev,
		java.lang.Float distance_rms_dev_error,
		java.lang.String entry_id,
		java.lang.Float improper_torsion_angle_rms_dev,
		java.lang.Float improper_torsion_angle_rms_dev_error,
		java.lang.Float peptide_planarity_rms_dev,
		java.lang.Float peptide_planarity_rms_dev_error,
		java.lang.Integer residue_range_begin,
		java.lang.Integer residue_range_end)
	{
		this.datablock = datablock;
		this.atom_type = atom_type;
		this.bond_angle_rms_dev = bond_angle_rms_dev;
		this.bond_angle_rms_dev_error = bond_angle_rms_dev_error;
		this.chain_range_begin = chain_range_begin;
		this.chain_range_end = chain_range_end;
		this.coord_average_rmsd_method = coord_average_rmsd_method;
		this.covalent_bond_rms_dev = covalent_bond_rms_dev;
		this.covalent_bond_rms_dev_error = covalent_bond_rms_dev_error;
		this.dihedral_angles_rms_dev = dihedral_angles_rms_dev;
		this.dihedral_angles_rms_dev_error = dihedral_angles_rms_dev_error;
		this.distance_rms_dev = distance_rms_dev;
		this.distance_rms_dev_error = distance_rms_dev_error;
		this.entry_id = entry_id;
		this.improper_torsion_angle_rms_dev = improper_torsion_angle_rms_dev;
		this.improper_torsion_angle_rms_dev_error = improper_torsion_angle_rms_dev_error;
		this.peptide_planarity_rms_dev = peptide_planarity_rms_dev;
		this.peptide_planarity_rms_dev_error = peptide_planarity_rms_dev_error;
		this.residue_range_begin = residue_range_begin;
		this.residue_range_end = residue_range_end;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_nmr_ensemble_rms");
		sb.append("\n");
		if (atom_type != null)
		{
			sb.append("atom_type = ");
			sb.append(atom_type);
			sb.append('\n');
		}
		if (bond_angle_rms_dev != null)
		{
			sb.append("bond_angle_rms_dev = ");
			sb.append(bond_angle_rms_dev);
			sb.append('\n');
		}
		if (bond_angle_rms_dev_error != null)
		{
			sb.append("bond_angle_rms_dev_error = ");
			sb.append(bond_angle_rms_dev_error);
			sb.append('\n');
		}
		if (chain_range_begin != null)
		{
			sb.append("chain_range_begin = ");
			sb.append(chain_range_begin);
			sb.append('\n');
		}
		if (chain_range_end != null)
		{
			sb.append("chain_range_end = ");
			sb.append(chain_range_end);
			sb.append('\n');
		}
		if (coord_average_rmsd_method != null)
		{
			sb.append("coord_average_rmsd_method = ");
			sb.append(coord_average_rmsd_method);
			sb.append('\n');
		}
		if (covalent_bond_rms_dev != null)
		{
			sb.append("covalent_bond_rms_dev = ");
			sb.append(covalent_bond_rms_dev);
			sb.append('\n');
		}
		if (covalent_bond_rms_dev_error != null)
		{
			sb.append("covalent_bond_rms_dev_error = ");
			sb.append(covalent_bond_rms_dev_error);
			sb.append('\n');
		}
		if (dihedral_angles_rms_dev != null)
		{
			sb.append("dihedral_angles_rms_dev = ");
			sb.append(dihedral_angles_rms_dev);
			sb.append('\n');
		}
		if (dihedral_angles_rms_dev_error != null)
		{
			sb.append("dihedral_angles_rms_dev_error = ");
			sb.append(dihedral_angles_rms_dev_error);
			sb.append('\n');
		}
		if (distance_rms_dev != null)
		{
			sb.append("distance_rms_dev = ");
			sb.append(distance_rms_dev);
			sb.append('\n');
		}
		if (distance_rms_dev_error != null)
		{
			sb.append("distance_rms_dev_error = ");
			sb.append(distance_rms_dev_error);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (improper_torsion_angle_rms_dev != null)
		{
			sb.append("improper_torsion_angle_rms_dev = ");
			sb.append(improper_torsion_angle_rms_dev);
			sb.append('\n');
		}
		if (improper_torsion_angle_rms_dev_error != null)
		{
			sb.append("improper_torsion_angle_rms_dev_error = ");
			sb.append(improper_torsion_angle_rms_dev_error);
			sb.append('\n');
		}
		if (peptide_planarity_rms_dev != null)
		{
			sb.append("peptide_planarity_rms_dev = ");
			sb.append(peptide_planarity_rms_dev);
			sb.append('\n');
		}
		if (peptide_planarity_rms_dev_error != null)
		{
			sb.append("peptide_planarity_rms_dev_error = ");
			sb.append(peptide_planarity_rms_dev_error);
			sb.append('\n');
		}
		if (residue_range_begin != null)
		{
			sb.append("residue_range_begin = ");
			sb.append(residue_range_begin);
			sb.append('\n');
		}
		if (residue_range_end != null)
		{
			sb.append("residue_range_end = ");
			sb.append(residue_range_end);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		atom_type = null;
		bond_angle_rms_dev = null;
		bond_angle_rms_dev_error = null;
		chain_range_begin = null;
		chain_range_end = null;
		coord_average_rmsd_method = null;
		covalent_bond_rms_dev = null;
		covalent_bond_rms_dev_error = null;
		dihedral_angles_rms_dev = null;
		dihedral_angles_rms_dev_error = null;
		distance_rms_dev = null;
		distance_rms_dev_error = null;
		entry_id = null;
		improper_torsion_angle_rms_dev = null;
		improper_torsion_angle_rms_dev_error = null;
		peptide_planarity_rms_dev = null;
		peptide_planarity_rms_dev_error = null;
		residue_range_begin = null;
		residue_range_end = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_nmr_ensemble_rms)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_nmr_ensemble_rms>\n");
			if (atom_type != null) ow.write(indent + " <PDBx:atom_type>" + atom_type + "</PDBx:atom_type>\n");
			if (bond_angle_rms_dev != null) ow.write(indent + " <PDBx:bond_angle_rms_dev>" + bond_angle_rms_dev + "</PDBx:bond_angle_rms_dev>\n");
			if (bond_angle_rms_dev_error != null) ow.write(indent + " <PDBx:bond_angle_rms_dev_error>" + bond_angle_rms_dev_error + "</PDBx:bond_angle_rms_dev_error>\n");
			if (chain_range_begin != null) ow.write(indent + " <PDBx:chain_range_begin>" + chain_range_begin + "</PDBx:chain_range_begin>\n");
			if (chain_range_end != null) ow.write(indent + " <PDBx:chain_range_end>" + chain_range_end + "</PDBx:chain_range_end>\n");
			if (coord_average_rmsd_method != null) ow.write(indent + " <PDBx:coord_average_rmsd_method>" + coord_average_rmsd_method + "</PDBx:coord_average_rmsd_method>\n");
			if (covalent_bond_rms_dev != null) ow.write(indent + " <PDBx:covalent_bond_rms_dev>" + covalent_bond_rms_dev + "</PDBx:covalent_bond_rms_dev>\n");
			if (covalent_bond_rms_dev_error != null) ow.write(indent + " <PDBx:covalent_bond_rms_dev_error>" + covalent_bond_rms_dev_error + "</PDBx:covalent_bond_rms_dev_error>\n");
			if (dihedral_angles_rms_dev != null) ow.write(indent + " <PDBx:dihedral_angles_rms_dev>" + dihedral_angles_rms_dev + "</PDBx:dihedral_angles_rms_dev>\n");
			if (dihedral_angles_rms_dev_error != null) ow.write(indent + " <PDBx:dihedral_angles_rms_dev_error>" + dihedral_angles_rms_dev_error + "</PDBx:dihedral_angles_rms_dev_error>\n");
			if (distance_rms_dev != null) ow.write(indent + " <PDBx:distance_rms_dev>" + distance_rms_dev + "</PDBx:distance_rms_dev>\n");
			if (distance_rms_dev_error != null) ow.write(indent + " <PDBx:distance_rms_dev_error>" + distance_rms_dev_error + "</PDBx:distance_rms_dev_error>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (improper_torsion_angle_rms_dev != null) ow.write(indent + " <PDBx:improper_torsion_angle_rms_dev>" + improper_torsion_angle_rms_dev + "</PDBx:improper_torsion_angle_rms_dev>\n");
			if (improper_torsion_angle_rms_dev_error != null) ow.write(indent + " <PDBx:improper_torsion_angle_rms_dev_error>" + improper_torsion_angle_rms_dev_error + "</PDBx:improper_torsion_angle_rms_dev_error>\n");
			if (peptide_planarity_rms_dev != null) ow.write(indent + " <PDBx:peptide_planarity_rms_dev>" + peptide_planarity_rms_dev + "</PDBx:peptide_planarity_rms_dev>\n");
			if (peptide_planarity_rms_dev_error != null) ow.write(indent + " <PDBx:peptide_planarity_rms_dev_error>" + peptide_planarity_rms_dev_error + "</PDBx:peptide_planarity_rms_dev_error>\n");
			if (residue_range_begin != null) ow.write(indent + " <PDBx:residue_range_begin>" + residue_range_begin + "</PDBx:residue_range_begin>\n");
			if (residue_range_end != null) ow.write(indent + " <PDBx:residue_range_end>" + residue_range_end + "</PDBx:residue_range_end>\n");
			ow.write(indent + "</PDBx:pdbx_nmr_ensemble_rms>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
