package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  In this section, enter information on those experiments that were
 *  used to generate constraint data. For each NMR experiment indicate
 *  which sample and which sample conditions were used for the experiment.
 *  This example was taken from the MCP-1 study.
 *  <PDBx:pdbx_nmr_exptlCategory>
 *  <PDBx:pdbx_nmr_exptl experiment_id="1" solution_id="3" conditions_id="1">
 *  <PDBx:type>3D_15N-separated_NOESY</PDBx:type>
 *  </PDBx:pdbx_nmr_exptl>
 *  <PDBx:pdbx_nmr_exptl experiment_id="2" solution_id="1" conditions_id="1">
 *  <PDBx:type>3D_13C-separated_NOESY</PDBx:type>
 *  </PDBx:pdbx_nmr_exptl>
 *  <PDBx:pdbx_nmr_exptl experiment_id="3" solution_id="1" conditions_id="2">
 *  <PDBx:type>4D_13C/15N-separated_NOESY</PDBx:type>
 *  </PDBx:pdbx_nmr_exptl>
 *  <PDBx:pdbx_nmr_exptl experiment_id="4" solution_id="1" conditions_id="1">
 *  <PDBx:type>4D_13C-separated_NOESY</PDBx:type>
 *  </PDBx:pdbx_nmr_exptl>
 *  <PDBx:pdbx_nmr_exptl experiment_id="5" solution_id="1" conditions_id="1">
 *  <PDBx:type>3D_15N-separated_ROESY</PDBx:type>
 *  </PDBx:pdbx_nmr_exptl>
 *  <PDBx:pdbx_nmr_exptl experiment_id="6" solution_id="3" conditions_id="1">
 *  <PDBx:type>3D_13C-separated_ROESY</PDBx:type>
 *  </PDBx:pdbx_nmr_exptl>
 *  </PDBx:pdbx_nmr_exptlCategory>
 */
public class Pdbx_nmr_exptl extends org.pdb.beans.Pdbx_nmr_exptl implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_nmr_exptl";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_nmr_exptl()
	{
	}

	/** Full constructor */
	public Pdbx_nmr_exptl(
		Datablock datablock,
		java.lang.String conditions_id,
		java.lang.String experiment_id,
		java.lang.String solution_id,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.conditions_id = conditions_id;
		this.experiment_id = experiment_id;
		this.solution_id = solution_id;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_nmr_exptl");
		sb.append("\n");
		if (conditions_id != null)
		{
			sb.append("conditions_id = ");
			sb.append(conditions_id);
			sb.append('\n');
		}
		if (experiment_id != null)
		{
			sb.append("experiment_id = ");
			sb.append(experiment_id);
			sb.append('\n');
		}
		if (solution_id != null)
		{
			sb.append("solution_id = ");
			sb.append(solution_id);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		conditions_id = null;
		experiment_id = null;
		solution_id = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_nmr_exptl)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_nmr_exptl>\n");
			if (conditions_id != null) ow.write(indent + " <PDBx:conditions_id>" + conditions_id + "</PDBx:conditions_id>\n");
			if (experiment_id != null) ow.write(indent + " <PDBx:experiment_id>" + experiment_id + "</PDBx:experiment_id>\n");
			if (solution_id != null) ow.write(indent + " <PDBx:solution_id>" + solution_id + "</PDBx:solution_id>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:pdbx_nmr_exptl>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
