package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  The chemical constituents of
 *  each NMR sample. Each sample is identified by a number and
 *  each component in the sample is identified by name.
 *  
 * <pre>
 *  Example 1
 *  
 *  This example was taken from the study of MCP-1 which is a dimer under the
 *  conditions studied. Three solutions with different isotope compositions were
 *  studied.
 *  <PDBx:pdbx_nmr_exptl_sampleCategory>
 *  <PDBx:pdbx_nmr_exptl_sample solution_id="1" component="MCP-1">
 *  <PDBx:concentration>2.</PDBx:concentration>
 *  <PDBx:concentration_units>mM</PDBx:concentration_units>
 *  <PDBx:isotopic_labeling>U-15N,13C</PDBx:isotopic_labeling>
 *  </PDBx:pdbx_nmr_exptl_sample>
 *  <PDBx:pdbx_nmr_exptl_sample solution_id="1" component="H2O">
 *  <PDBx:concentration>90.</PDBx:concentration>
 *  <PDBx:concentration_units>&#37;</PDBx:concentration_units>
 *  </PDBx:pdbx_nmr_exptl_sample>
 *  <PDBx:pdbx_nmr_exptl_sample solution_id="1" component="D2O">
 *  <PDBx:concentration>10.</PDBx:concentration>
 *  <PDBx:concentration_units>&#37;</PDBx:concentration_units>
 *  </PDBx:pdbx_nmr_exptl_sample>
 *  </PDBx:pdbx_nmr_exptl_sampleCategory>
 *  
 *  
 *  Example 2
 *  
 *  This example was taken from the study of MCP-1 which is a dimer under the
 *  conditions studied. Three solutions with different isotope compositions were
 *  studied.
 *  <PDBx:pdbx_nmr_exptl_sampleCategory>
 *  <PDBx:pdbx_nmr_exptl_sample solution_id="2" component="MCP-1">
 *  <PDBx:concentration>1.</PDBx:concentration>
 *  <PDBx:concentration_units>mM</PDBx:concentration_units>
 *  <PDBx:isotopic_labeling>U-50&#37; 15N</PDBx:isotopic_labeling>
 *  </PDBx:pdbx_nmr_exptl_sample>
 *  <PDBx:pdbx_nmr_exptl_sample solution_id="2" component="H2O">
 *  <PDBx:concentration>90.</PDBx:concentration>
 *  <PDBx:concentration_units>&#37;</PDBx:concentration_units>
 *  </PDBx:pdbx_nmr_exptl_sample>
 *  <PDBx:pdbx_nmr_exptl_sample solution_id="2" component="D2O">
 *  <PDBx:concentration>10.</PDBx:concentration>
 *  <PDBx:concentration_units>&#37;</PDBx:concentration_units>
 *  </PDBx:pdbx_nmr_exptl_sample>
 *  </PDBx:pdbx_nmr_exptl_sampleCategory>
 * </pre>
 */
public class Pdbx_nmr_exptl_sample extends org.pdb.beans.Pdbx_nmr_exptl_sample implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_nmr_exptl_sample";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_nmr_exptl_sample()
	{
	}

	/** Full constructor */
	public Pdbx_nmr_exptl_sample(
		Datablock datablock,
		java.lang.String component,
		java.lang.Float concentration,
		java.lang.String concentration_units,
		java.lang.String isotopic_labeling,
		java.lang.String solution_id)
	{
		this.datablock = datablock;
		this.component = component;
		this.concentration = concentration;
		this.concentration_units = concentration_units;
		this.isotopic_labeling = isotopic_labeling;
		this.solution_id = solution_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_nmr_exptl_sample");
		sb.append("\n");
		if (component != null)
		{
			sb.append("component = ");
			sb.append(component);
			sb.append('\n');
		}
		if (concentration != null)
		{
			sb.append("concentration = ");
			sb.append(concentration);
			sb.append('\n');
		}
		if (concentration_units != null)
		{
			sb.append("concentration_units = ");
			sb.append(concentration_units);
			sb.append('\n');
		}
		if (isotopic_labeling != null)
		{
			sb.append("isotopic_labeling = ");
			sb.append(isotopic_labeling);
			sb.append('\n');
		}
		if (solution_id != null)
		{
			sb.append("solution_id = ");
			sb.append(solution_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		component = null;
		concentration = null;
		concentration_units = null;
		isotopic_labeling = null;
		solution_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_nmr_exptl_sample)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_nmr_exptl_sample>\n");
			if (component != null) ow.write(indent + " <PDBx:component>" + component + "</PDBx:component>\n");
			if (concentration != null) ow.write(indent + " <PDBx:concentration>" + concentration + "</PDBx:concentration>\n");
			if (concentration_units != null) ow.write(indent + " <PDBx:concentration_units>" + concentration_units + "</PDBx:concentration_units>\n");
			if (isotopic_labeling != null) ow.write(indent + " <PDBx:isotopic_labeling>" + isotopic_labeling + "</PDBx:isotopic_labeling>\n");
			if (solution_id != null) ow.write(indent + " <PDBx:solution_id>" + solution_id + "</PDBx:solution_id>\n");
			ow.write(indent + "</PDBx:pdbx_nmr_exptl_sample>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
