package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  The experimental conditions used to for each sample.  Each set of conditions
 *  is identified by a numerical code.
 *  This example was taken from a pH stability study.
 *  <PDBx:pdbx_nmr_exptl_sample_conditionsCategory>
 *  <PDBx:pdbx_nmr_exptl_sample_conditions conditions_id="1">
 *  <PDBx:temperature>298</PDBx:temperature>
 *  <PDBx:pressure>ambient</PDBx:pressure>
 *  <PDBx:pH>7</PDBx:pH>
 *  <PDBx:ionic_strength>25mM NaCl</PDBx:ionic_strength>
 *  </PDBx:pdbx_nmr_exptl_sample_conditions>
 *  <PDBx:pdbx_nmr_exptl_sample_conditions conditions_id="2">
 *  <PDBx:temperature>298</PDBx:temperature>
 *  <PDBx:pressure>ambient</PDBx:pressure>
 *  <PDBx:pH>3</PDBx:pH>
 *  <PDBx:ionic_strength>25mM NaCl</PDBx:ionic_strength>
 *  </PDBx:pdbx_nmr_exptl_sample_conditions>
 *  </PDBx:pdbx_nmr_exptl_sample_conditionsCategory>
 */
public class Pdbx_nmr_exptl_sample_conditions extends org.pdb.beans.Pdbx_nmr_exptl_sample_conditions implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_nmr_exptl_sample_conditions";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_nmr_exptl_sample_conditions()
	{
	}

	/** Full constructor */
	public Pdbx_nmr_exptl_sample_conditions(
		Datablock datablock,
		java.lang.String conditions_id,
		java.lang.String ionic_strength,
		java.lang.String pH,
		java.lang.String pressure,
		java.lang.String pressure_units,
		java.lang.String temperature)
	{
		this.datablock = datablock;
		this.conditions_id = conditions_id;
		this.ionic_strength = ionic_strength;
		this.pH = pH;
		this.pressure = pressure;
		this.pressure_units = pressure_units;
		this.temperature = temperature;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_nmr_exptl_sample_conditions");
		sb.append("\n");
		if (conditions_id != null)
		{
			sb.append("conditions_id = ");
			sb.append(conditions_id);
			sb.append('\n');
		}
		if (ionic_strength != null)
		{
			sb.append("ionic_strength = ");
			sb.append(ionic_strength);
			sb.append('\n');
		}
		if (pH != null)
		{
			sb.append("pH = ");
			sb.append(pH);
			sb.append('\n');
		}
		if (pressure != null)
		{
			sb.append("pressure = ");
			sb.append(pressure);
			sb.append('\n');
		}
		if (pressure_units != null)
		{
			sb.append("pressure_units = ");
			sb.append(pressure_units);
			sb.append('\n');
		}
		if (temperature != null)
		{
			sb.append("temperature = ");
			sb.append(temperature);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		conditions_id = null;
		ionic_strength = null;
		pH = null;
		pressure = null;
		pressure_units = null;
		temperature = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_nmr_exptl_sample_conditions)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_nmr_exptl_sample_conditions>\n");
			if (conditions_id != null) ow.write(indent + " <PDBx:conditions_id>" + conditions_id + "</PDBx:conditions_id>\n");
			if (ionic_strength != null) ow.write(indent + " <PDBx:ionic_strength>" + ionic_strength + "</PDBx:ionic_strength>\n");
			if (pH != null) ow.write(indent + " <PDBx:pH>" + pH + "</PDBx:pH>\n");
			if (pressure != null) ow.write(indent + " <PDBx:pressure>" + pressure + "</PDBx:pressure>\n");
			if (pressure_units != null) ow.write(indent + " <PDBx:pressure_units>" + pressure_units + "</PDBx:pressure_units>\n");
			if (temperature != null) ow.write(indent + " <PDBx:temperature>" + temperature + "</PDBx:temperature>\n");
			ow.write(indent + "</PDBx:pdbx_nmr_exptl_sample_conditions>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
