package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  An average structure is often calculated in addition to the ensemble, or one
 *  of the ensemble is selected as a representative structure. This section
 *  describes selection of the representative structure.
 *  This example is drawn from the MCP-1 structure.
 *  <PDBx:pdbx_nmr_representativeCategory>
 *  <PDBx:pdbx_nmr_representative entry_id="1ABC">
 *  <PDBx:conformer_id>15</PDBx:conformer_id>
 *  <PDBx:selection_criteria>lowest energy</PDBx:selection_criteria>
 *  </PDBx:pdbx_nmr_representative>
 *  </PDBx:pdbx_nmr_representativeCategory>
 */
public class Pdbx_nmr_representative extends org.pdb.beans.Pdbx_nmr_representative implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_nmr_representative";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_nmr_representative()
	{
	}

	/** Full constructor */
	public Pdbx_nmr_representative(
		Datablock datablock,
		java.lang.String conformer_id,
		java.lang.String entry_id,
		java.lang.String selection_criteria)
	{
		this.datablock = datablock;
		this.conformer_id = conformer_id;
		this.entry_id = entry_id;
		this.selection_criteria = selection_criteria;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_nmr_representative");
		sb.append("\n");
		if (conformer_id != null)
		{
			sb.append("conformer_id = ");
			sb.append(conformer_id);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (selection_criteria != null)
		{
			sb.append("selection_criteria = ");
			sb.append(selection_criteria);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		conformer_id = null;
		entry_id = null;
		selection_criteria = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_nmr_representative)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_nmr_representative>\n");
			if (conformer_id != null) ow.write(indent + " <PDBx:conformer_id>" + conformer_id + "</PDBx:conformer_id>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (selection_criteria != null) ow.write(indent + " <PDBx:selection_criteria>" + selection_criteria + "</PDBx:selection_criteria>\n");
			ow.write(indent + "</PDBx:pdbx_nmr_representative>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
