package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Description of the software that was used for data collection, data processing,
 *  data analysis, structure calculations and refinement. The description should
 *  include the name of the software, the author of the software and the version used.
 *  This example describes the software used in the MCP-1 study.
 *  <PDBx:pdbx_nmr_softwareCategory>
 *  <PDBx:pdbx_nmr_software name="UXNMR" version="940501.3" classification="collection">
 *  <PDBx:authors>Bruker</PDBx:authors>
 *  </PDBx:pdbx_nmr_software>
 *  <PDBx:pdbx_nmr_software name="FELIX" version="1.1" classification="processing">
 *  <PDBx:authors>Hare</PDBx:authors>
 *  </PDBx:pdbx_nmr_software>
 *  <PDBx:pdbx_nmr_software name="ANSIG" version="3.0" classification="data analysis">
 *  <PDBx:authors>Kraulis</PDBx:authors>
 *  </PDBx:pdbx_nmr_software>
 *  <PDBx:pdbx_nmr_software name="X-PLOR" version="3.8" classification="structure calculation">
 *  <PDBx:authors>Brunger</PDBx:authors>
 *  </PDBx:pdbx_nmr_software>
 *  <PDBx:pdbx_nmr_software name="X-PLOR" version="3.8" classification="refinement">
 *  <PDBx:authors>Brunger</PDBx:authors>
 *  </PDBx:pdbx_nmr_software>
 *  </PDBx:pdbx_nmr_softwareCategory>
 */
public class Pdbx_nmr_software extends org.pdb.beans.Pdbx_nmr_software implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_nmr_software";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_nmr_software()
	{
	}

	/** Full constructor */
	public Pdbx_nmr_software(
		Datablock datablock,
		java.lang.String authors,
		java.lang.String classification,
		java.lang.String name,
		java.lang.String version)
	{
		this.datablock = datablock;
		this.authors = authors;
		this.classification = classification;
		this.name = name;
		this.version = version;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_nmr_software");
		sb.append("\n");
		if (authors != null)
		{
			sb.append("authors = ");
			sb.append(authors);
			sb.append('\n');
		}
		if (classification != null)
		{
			sb.append("classification = ");
			sb.append(classification);
			sb.append('\n');
		}
		if (name != null)
		{
			sb.append("name = ");
			sb.append(name);
			sb.append('\n');
		}
		if (version != null)
		{
			sb.append("version = ");
			sb.append(version);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		authors = null;
		classification = null;
		name = null;
		version = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_nmr_software)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_nmr_software>\n");
			if (authors != null) ow.write(indent + " <PDBx:authors>" + authors + "</PDBx:authors>\n");
			if (classification != null) ow.write(indent + " <PDBx:classification>" + classification + "</PDBx:classification>\n");
			if (name != null) ow.write(indent + " <PDBx:name>" + name + "</PDBx:name>\n");
			if (version != null) ow.write(indent + " <PDBx:version>" + version + "</PDBx:version>\n");
			ow.write(indent + "</PDBx:pdbx_nmr_software>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
