package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  The details about each spectrometer used to collect data for this
 *  deposition.
 *  The instruments described here are the ones used for the MCP-1 studies.
 *  <PDBx:pdbx_nmr_spectrometerCategory>
 *  <PDBx:pdbx_nmr_spectrometer spectrometer_id="1">
 *  <PDBx:type>Bruker AMX</PDBx:type>
 *  <PDBx:field_strength>600.</PDBx:field_strength>
 *  </PDBx:pdbx_nmr_spectrometer>
 *  <PDBx:pdbx_nmr_spectrometer spectrometer_id="2">
 *  <PDBx:type>Bruker AMX</PDBx:type>
 *  <PDBx:field_strength>500.</PDBx:field_strength>
 *  </PDBx:pdbx_nmr_spectrometer>
 *  </PDBx:pdbx_nmr_spectrometerCategory>
 */
public class Pdbx_nmr_spectrometer extends org.pdb.beans.Pdbx_nmr_spectrometer implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_nmr_spectrometer";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_nmr_spectrometer()
	{
	}

	/** Full constructor */
	public Pdbx_nmr_spectrometer(
		Datablock datablock,
		java.lang.Float field_strength,
		java.lang.String manufacturer,
		java.lang.String model,
		java.lang.String spectrometer_id,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.field_strength = field_strength;
		this.manufacturer = manufacturer;
		this.model = model;
		this.spectrometer_id = spectrometer_id;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_nmr_spectrometer");
		sb.append("\n");
		if (field_strength != null)
		{
			sb.append("field_strength = ");
			sb.append(field_strength);
			sb.append('\n');
		}
		if (manufacturer != null)
		{
			sb.append("manufacturer = ");
			sb.append(manufacturer);
			sb.append('\n');
		}
		if (model != null)
		{
			sb.append("model = ");
			sb.append(model);
			sb.append('\n');
		}
		if (spectrometer_id != null)
		{
			sb.append("spectrometer_id = ");
			sb.append(spectrometer_id);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		field_strength = null;
		manufacturer = null;
		model = null;
		spectrometer_id = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_nmr_spectrometer)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_nmr_spectrometer>\n");
			if (field_strength != null) ow.write(indent + " <PDBx:field_strength>" + field_strength + "</PDBx:field_strength>\n");
			if (manufacturer != null) ow.write(indent + " <PDBx:manufacturer>" + manufacturer + "</PDBx:manufacturer>\n");
			if (model != null) ow.write(indent + " <PDBx:model>" + model + "</PDBx:model>\n");
			if (spectrometer_id != null) ow.write(indent + " <PDBx:spectrometer_id>" + spectrometer_id + "</PDBx:spectrometer_id>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:pdbx_nmr_spectrometer>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
