package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  The same as category pdbx_phasing_MAD_set, but
 *  broken into shells.
 *  
 *  
 * <pre>
 *  Example 1 -  three wavelengths (SHARP example)
 *  <PDBx:pdbx_phasing_MAD_set_shellCategory>
 *  <PDBx:pdbx_phasing_MAD_set_shell id="ISO_1" d_res_low="22.60" d_res_high="7.77">
 *  <PDBx:reflns_acentric>64</PDBx:reflns_acentric>
 *  <PDBx:reflns_centric>23</PDBx:reflns_centric>
 *  <PDBx:R_cullis_acentric>0.000</PDBx:R_cullis_acentric>
 *  <PDBx:R_cullis_centric>0.000</PDBx:R_cullis_centric>
 *  <PDBx:power_acentric>0.000</PDBx:power_acentric>
 *  <PDBx:power_centric>0.000</PDBx:power_centric>
 *  </PDBx:pdbx_phasing_MAD_set_shell>
 *  <PDBx:pdbx_phasing_MAD_set_shell id="ISO_1" d_res_low="7.77" d_res_high="5.67">
 *  <PDBx:reflns_acentric>130</PDBx:reflns_acentric>
 *  <PDBx:reflns_centric>32</PDBx:reflns_centric>
 *  <PDBx:R_cullis_acentric>0.000</PDBx:R_cullis_acentric>
 *  <PDBx:R_cullis_centric>0.000</PDBx:R_cullis_centric>
 *  <PDBx:power_acentric>0.000</PDBx:power_acentric>
 *  <PDBx:power_centric>0.000</PDBx:power_centric>
 *  </PDBx:pdbx_phasing_MAD_set_shell>
 *  <PDBx:pdbx_phasing_MAD_set_shell id="ISO_1" d_res_low="5.67" d_res_high="4.68">
 *  <PDBx:reflns_acentric>182</PDBx:reflns_acentric>
 *  <PDBx:reflns_centric>27</PDBx:reflns_centric>
 *  <PDBx:R_cullis_acentric>0.000</PDBx:R_cullis_acentric>
 *  <PDBx:R_cullis_centric>0.000</PDBx:R_cullis_centric>
 *  <PDBx:power_acentric>0.000</PDBx:power_acentric>
 *  <PDBx:power_centric>0.000</PDBx:power_centric>
 *  </PDBx:pdbx_phasing_MAD_set_shell>
 *  <PDBx:pdbx_phasing_MAD_set_shell id="ISO_1" d_res_low="4.68" d_res_high="4.07">
 *  <PDBx:reflns_acentric>207</PDBx:reflns_acentric>
 *  <PDBx:reflns_centric>24</PDBx:reflns_centric>
 *  <PDBx:R_cullis_acentric>0.000</PDBx:R_cullis_acentric>
 *  <PDBx:R_cullis_centric>0.000</PDBx:R_cullis_centric>
 *  <PDBx:power_acentric>0.000</PDBx:power_acentric>
 *  <PDBx:power_centric>0.000</PDBx:power_centric>
 *  </PDBx:pdbx_phasing_MAD_set_shell>
 *  <PDBx:pdbx_phasing_MAD_set_shell id="ANO_1" d_res_low="22.60" d_res_high="7.77">
 *  <PDBx:reflns_acentric>62</PDBx:reflns_acentric>
 *  <PDBx:reflns_centric>0</PDBx:reflns_centric>
 *  <PDBx:R_cullis_acentric>0.610</PDBx:R_cullis_acentric>
 *  <PDBx:R_cullis_centric>0.000</PDBx:R_cullis_centric>
 *  <PDBx:power_acentric>1.804</PDBx:power_acentric>
 *  <PDBx:power_centric>0.000</PDBx:power_centric>
 *  </PDBx:pdbx_phasing_MAD_set_shell>
 *  <PDBx:pdbx_phasing_MAD_set_shell id="ANO_1" d_res_low="7.77" d_res_high="5.67">
 *  <PDBx:reflns_acentric>129</PDBx:reflns_acentric>
 *  <PDBx:reflns_centric>0</PDBx:reflns_centric>
 *  <PDBx:R_cullis_acentric>0.532</PDBx:R_cullis_acentric>
 *  <PDBx:R_cullis_centric>0.000</PDBx:R_cullis_centric>
 *  <PDBx:power_acentric>2.382</PDBx:power_acentric>
 *  <PDBx:power_centric>0.000</PDBx:power_centric>
 *  </PDBx:pdbx_phasing_MAD_set_shell>
 *  <PDBx:pdbx_phasing_MAD_set_shell id="ANO_1" d_res_low="5.67" d_res_high="4.68">
 *  <PDBx:reflns_acentric>178</PDBx:reflns_acentric>
 *  <PDBx:reflns_centric>0</PDBx:reflns_centric>
 *  <PDBx:R_cullis_acentric>0.673</PDBx:R_cullis_acentric>
 *  <PDBx:R_cullis_centric>0.000</PDBx:R_cullis_centric>
 *  <PDBx:power_acentric>1.858</PDBx:power_acentric>
 *  <PDBx:power_centric>0.000</PDBx:power_centric>
 *  </PDBx:pdbx_phasing_MAD_set_shell>
 *  <PDBx:pdbx_phasing_MAD_set_shell id="ANO_1" d_res_low="4.68" d_res_high="4.07">
 *  <PDBx:reflns_acentric>204</PDBx:reflns_acentric>
 *  <PDBx:reflns_centric>0</PDBx:reflns_centric>
 *  <PDBx:R_cullis_acentric>0.755</PDBx:R_cullis_acentric>
 *  <PDBx:R_cullis_centric>0.000</PDBx:R_cullis_centric>
 *  <PDBx:power_acentric>1.605</PDBx:power_acentric>
 *  <PDBx:power_centric>0.000</PDBx:power_centric>
 *  </PDBx:pdbx_phasing_MAD_set_shell>
 *  </PDBx:pdbx_phasing_MAD_set_shellCategory>
 * </pre>
 */
public class Pdbx_phasing_MAD_set_shell extends org.pdb.beans.Pdbx_phasing_MAD_set_shell implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_phasing_MAD_set_shell";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_phasing_MAD_set_shell()
	{
	}

	/** Full constructor */
	public Pdbx_phasing_MAD_set_shell(
		Datablock datablock,
		java.lang.Float R_cullis,
		java.lang.Float R_cullis_acentric,
		java.lang.Float R_cullis_centric,
		java.lang.Float R_kraut,
		java.lang.Float R_kraut_acentric,
		java.lang.Float R_kraut_centric,
		java.lang.Float d_res_high,
		java.lang.Float d_res_low,
		java.lang.Float fom,
		java.lang.Float fom_acentric,
		java.lang.Float fom_centric,
		java.lang.String id_,
		java.lang.Float loc,
		java.lang.Float loc_acentric,
		java.lang.Float loc_centric,
		java.lang.Float power,
		java.lang.Float power_acentric,
		java.lang.Float power_centric,
		java.lang.Integer reflns,
		java.lang.Integer reflns_acentric,
		java.lang.Integer reflns_centric)
	{
		this.datablock = datablock;
		this.R_cullis = R_cullis;
		this.R_cullis_acentric = R_cullis_acentric;
		this.R_cullis_centric = R_cullis_centric;
		this.R_kraut = R_kraut;
		this.R_kraut_acentric = R_kraut_acentric;
		this.R_kraut_centric = R_kraut_centric;
		this.d_res_high = d_res_high;
		this.d_res_low = d_res_low;
		this.fom = fom;
		this.fom_acentric = fom_acentric;
		this.fom_centric = fom_centric;
		this.id_ = id_;
		this.loc = loc;
		this.loc_acentric = loc_acentric;
		this.loc_centric = loc_centric;
		this.power = power;
		this.power_acentric = power_acentric;
		this.power_centric = power_centric;
		this.reflns = reflns;
		this.reflns_acentric = reflns_acentric;
		this.reflns_centric = reflns_centric;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_phasing_MAD_set_shell");
		sb.append("\n");
		if (R_cullis != null)
		{
			sb.append("R_cullis = ");
			sb.append(R_cullis);
			sb.append('\n');
		}
		if (R_cullis_acentric != null)
		{
			sb.append("R_cullis_acentric = ");
			sb.append(R_cullis_acentric);
			sb.append('\n');
		}
		if (R_cullis_centric != null)
		{
			sb.append("R_cullis_centric = ");
			sb.append(R_cullis_centric);
			sb.append('\n');
		}
		if (R_kraut != null)
		{
			sb.append("R_kraut = ");
			sb.append(R_kraut);
			sb.append('\n');
		}
		if (R_kraut_acentric != null)
		{
			sb.append("R_kraut_acentric = ");
			sb.append(R_kraut_acentric);
			sb.append('\n');
		}
		if (R_kraut_centric != null)
		{
			sb.append("R_kraut_centric = ");
			sb.append(R_kraut_centric);
			sb.append('\n');
		}
		if (d_res_high != null)
		{
			sb.append("d_res_high = ");
			sb.append(d_res_high);
			sb.append('\n');
		}
		if (d_res_low != null)
		{
			sb.append("d_res_low = ");
			sb.append(d_res_low);
			sb.append('\n');
		}
		if (fom != null)
		{
			sb.append("fom = ");
			sb.append(fom);
			sb.append('\n');
		}
		if (fom_acentric != null)
		{
			sb.append("fom_acentric = ");
			sb.append(fom_acentric);
			sb.append('\n');
		}
		if (fom_centric != null)
		{
			sb.append("fom_centric = ");
			sb.append(fom_centric);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (loc != null)
		{
			sb.append("loc = ");
			sb.append(loc);
			sb.append('\n');
		}
		if (loc_acentric != null)
		{
			sb.append("loc_acentric = ");
			sb.append(loc_acentric);
			sb.append('\n');
		}
		if (loc_centric != null)
		{
			sb.append("loc_centric = ");
			sb.append(loc_centric);
			sb.append('\n');
		}
		if (power != null)
		{
			sb.append("power = ");
			sb.append(power);
			sb.append('\n');
		}
		if (power_acentric != null)
		{
			sb.append("power_acentric = ");
			sb.append(power_acentric);
			sb.append('\n');
		}
		if (power_centric != null)
		{
			sb.append("power_centric = ");
			sb.append(power_centric);
			sb.append('\n');
		}
		if (reflns != null)
		{
			sb.append("reflns = ");
			sb.append(reflns);
			sb.append('\n');
		}
		if (reflns_acentric != null)
		{
			sb.append("reflns_acentric = ");
			sb.append(reflns_acentric);
			sb.append('\n');
		}
		if (reflns_centric != null)
		{
			sb.append("reflns_centric = ");
			sb.append(reflns_centric);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		R_cullis = null;
		R_cullis_acentric = null;
		R_cullis_centric = null;
		R_kraut = null;
		R_kraut_acentric = null;
		R_kraut_centric = null;
		d_res_high = null;
		d_res_low = null;
		fom = null;
		fom_acentric = null;
		fom_centric = null;
		id_ = null;
		loc = null;
		loc_acentric = null;
		loc_centric = null;
		power = null;
		power_acentric = null;
		power_centric = null;
		reflns = null;
		reflns_acentric = null;
		reflns_centric = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_phasing_MAD_set_shell)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_phasing_MAD_set_shell>\n");
			if (R_cullis != null) ow.write(indent + " <PDBx:R_cullis>" + R_cullis + "</PDBx:R_cullis>\n");
			if (R_cullis_acentric != null) ow.write(indent + " <PDBx:R_cullis_acentric>" + R_cullis_acentric + "</PDBx:R_cullis_acentric>\n");
			if (R_cullis_centric != null) ow.write(indent + " <PDBx:R_cullis_centric>" + R_cullis_centric + "</PDBx:R_cullis_centric>\n");
			if (R_kraut != null) ow.write(indent + " <PDBx:R_kraut>" + R_kraut + "</PDBx:R_kraut>\n");
			if (R_kraut_acentric != null) ow.write(indent + " <PDBx:R_kraut_acentric>" + R_kraut_acentric + "</PDBx:R_kraut_acentric>\n");
			if (R_kraut_centric != null) ow.write(indent + " <PDBx:R_kraut_centric>" + R_kraut_centric + "</PDBx:R_kraut_centric>\n");
			if (d_res_high != null) ow.write(indent + " <PDBx:d_res_high>" + d_res_high + "</PDBx:d_res_high>\n");
			if (d_res_low != null) ow.write(indent + " <PDBx:d_res_low>" + d_res_low + "</PDBx:d_res_low>\n");
			if (fom != null) ow.write(indent + " <PDBx:fom>" + fom + "</PDBx:fom>\n");
			if (fom_acentric != null) ow.write(indent + " <PDBx:fom_acentric>" + fom_acentric + "</PDBx:fom_acentric>\n");
			if (fom_centric != null) ow.write(indent + " <PDBx:fom_centric>" + fom_centric + "</PDBx:fom_centric>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (loc != null) ow.write(indent + " <PDBx:loc>" + loc + "</PDBx:loc>\n");
			if (loc_acentric != null) ow.write(indent + " <PDBx:loc_acentric>" + loc_acentric + "</PDBx:loc_acentric>\n");
			if (loc_centric != null) ow.write(indent + " <PDBx:loc_centric>" + loc_centric + "</PDBx:loc_centric>\n");
			if (power != null) ow.write(indent + " <PDBx:power>" + power + "</PDBx:power>\n");
			if (power_acentric != null) ow.write(indent + " <PDBx:power_acentric>" + power_acentric + "</PDBx:power_acentric>\n");
			if (power_centric != null) ow.write(indent + " <PDBx:power_centric>" + power_centric + "</PDBx:power_centric>\n");
			if (reflns != null) ow.write(indent + " <PDBx:reflns>" + reflns + "</PDBx:reflns>\n");
			if (reflns_acentric != null) ow.write(indent + " <PDBx:reflns_acentric>" + reflns_acentric + "</PDBx:reflns_acentric>\n");
			if (reflns_centric != null) ow.write(indent + " <PDBx:reflns_centric>" + reflns_centric + "</PDBx:reflns_centric>\n");
			ow.write(indent + "</PDBx:pdbx_phasing_MAD_set_shell>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
