package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_PHASING_DM category record details about
 *  density modification
 *  
 * <pre>
 *  Example 1 - density modification from resolve
 *  <PDBx:pdbx_phasing_dmCategory>
 *  <PDBx:pdbx_phasing_dm entry_id="ABC001">
 *  <PDBx:fom_acentric>0.85</PDBx:fom_acentric>
 *  <PDBx:fom_centric>0.79</PDBx:fom_centric>
 *  <PDBx:fom>0.85</PDBx:fom>
 *  <PDBx:reflns_acentric>11351</PDBx:reflns_acentric>
 *  <PDBx:reflns_centric>1135</PDBx:reflns_centric>
 *  <PDBx:reflns>12486</PDBx:reflns>
 *  </PDBx:pdbx_phasing_dm>
 *  </PDBx:pdbx_phasing_dmCategory>
 * </pre>
 */
public class Pdbx_phasing_dm extends org.pdb.beans.Pdbx_phasing_dm implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_phasing_dm";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_phasing_dm()
	{
	}

	/** Full constructor */
	public Pdbx_phasing_dm(
		Datablock datablock,
		java.lang.Float delta_phi_final,
		java.lang.Float delta_phi_initial,
		java.lang.String entry_id,
		java.lang.Float fom,
		java.lang.Float fom_acentric,
		java.lang.Float fom_centric,
		java.lang.String mask_type,
		java.lang.String method,
		java.lang.Integer reflns,
		java.lang.Integer reflns_acentric,
		java.lang.Integer reflns_centric)
	{
		this.datablock = datablock;
		this.delta_phi_final = delta_phi_final;
		this.delta_phi_initial = delta_phi_initial;
		this.entry_id = entry_id;
		this.fom = fom;
		this.fom_acentric = fom_acentric;
		this.fom_centric = fom_centric;
		this.mask_type = mask_type;
		this.method = method;
		this.reflns = reflns;
		this.reflns_acentric = reflns_acentric;
		this.reflns_centric = reflns_centric;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_phasing_dm");
		sb.append("\n");
		if (delta_phi_final != null)
		{
			sb.append("delta_phi_final = ");
			sb.append(delta_phi_final);
			sb.append('\n');
		}
		if (delta_phi_initial != null)
		{
			sb.append("delta_phi_initial = ");
			sb.append(delta_phi_initial);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (fom != null)
		{
			sb.append("fom = ");
			sb.append(fom);
			sb.append('\n');
		}
		if (fom_acentric != null)
		{
			sb.append("fom_acentric = ");
			sb.append(fom_acentric);
			sb.append('\n');
		}
		if (fom_centric != null)
		{
			sb.append("fom_centric = ");
			sb.append(fom_centric);
			sb.append('\n');
		}
		if (mask_type != null)
		{
			sb.append("mask_type = ");
			sb.append(mask_type);
			sb.append('\n');
		}
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		if (reflns != null)
		{
			sb.append("reflns = ");
			sb.append(reflns);
			sb.append('\n');
		}
		if (reflns_acentric != null)
		{
			sb.append("reflns_acentric = ");
			sb.append(reflns_acentric);
			sb.append('\n');
		}
		if (reflns_centric != null)
		{
			sb.append("reflns_centric = ");
			sb.append(reflns_centric);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		delta_phi_final = null;
		delta_phi_initial = null;
		entry_id = null;
		fom = null;
		fom_acentric = null;
		fom_centric = null;
		mask_type = null;
		method = null;
		reflns = null;
		reflns_acentric = null;
		reflns_centric = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_phasing_dm)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_phasing_dm>\n");
			if (delta_phi_final != null) ow.write(indent + " <PDBx:delta_phi_final>" + delta_phi_final + "</PDBx:delta_phi_final>\n");
			if (delta_phi_initial != null) ow.write(indent + " <PDBx:delta_phi_initial>" + delta_phi_initial + "</PDBx:delta_phi_initial>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (fom != null) ow.write(indent + " <PDBx:fom>" + fom + "</PDBx:fom>\n");
			if (fom_acentric != null) ow.write(indent + " <PDBx:fom_acentric>" + fom_acentric + "</PDBx:fom_acentric>\n");
			if (fom_centric != null) ow.write(indent + " <PDBx:fom_centric>" + fom_centric + "</PDBx:fom_centric>\n");
			if (mask_type != null) ow.write(indent + " <PDBx:mask_type>" + mask_type + "</PDBx:mask_type>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			if (reflns != null) ow.write(indent + " <PDBx:reflns>" + reflns + "</PDBx:reflns>\n");
			if (reflns_acentric != null) ow.write(indent + " <PDBx:reflns_acentric>" + reflns_acentric + "</PDBx:reflns_acentric>\n");
			if (reflns_centric != null) ow.write(indent + " <PDBx:reflns_centric>" + reflns_centric + "</PDBx:reflns_centric>\n");
			ow.write(indent + "</PDBx:pdbx_phasing_dm>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
