package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_REFINE_TLS_GROUP category record details about
 *  a fragment of a TLS group.
 *  
 *  Properties of the TLS group are recorded in PDBX_REFINE_TLS
 */
public class Pdbx_refine_tls_group extends org.pdb.beans.Pdbx_refine_tls_group implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_refine_tls_group";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_refine_tls_group()
	{
	}

	/** Full constructor */
	public Pdbx_refine_tls_group(
		Datablock datablock,
		java.lang.String beg_auth_asym_id,
		java.lang.String beg_auth_seq_id,
		java.lang.String beg_label_asym_id,
		java.lang.Integer beg_label_seq_id,
		java.lang.String end_auth_asym_id,
		java.lang.String end_auth_seq_id,
		java.lang.String end_label_asym_id,
		java.lang.Integer end_label_seq_id,
		java.lang.String id_,
		java.lang.String refine_tls_id,
		java.lang.String selection)
	{
		this.datablock = datablock;
		this.beg_auth_asym_id = beg_auth_asym_id;
		this.beg_auth_seq_id = beg_auth_seq_id;
		this.beg_label_asym_id = beg_label_asym_id;
		this.beg_label_seq_id = beg_label_seq_id;
		this.end_auth_asym_id = end_auth_asym_id;
		this.end_auth_seq_id = end_auth_seq_id;
		this.end_label_asym_id = end_label_asym_id;
		this.end_label_seq_id = end_label_seq_id;
		this.id_ = id_;
		this.refine_tls_id = refine_tls_id;
		this.selection = selection;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_refine_tls_group");
		sb.append("\n");
		if (beg_auth_asym_id != null)
		{
			sb.append("beg_auth_asym_id = ");
			sb.append(beg_auth_asym_id);
			sb.append('\n');
		}
		if (beg_auth_seq_id != null)
		{
			sb.append("beg_auth_seq_id = ");
			sb.append(beg_auth_seq_id);
			sb.append('\n');
		}
		if (beg_label_asym_id != null)
		{
			sb.append("beg_label_asym_id = ");
			sb.append(beg_label_asym_id);
			sb.append('\n');
		}
		if (beg_label_seq_id != null)
		{
			sb.append("beg_label_seq_id = ");
			sb.append(beg_label_seq_id);
			sb.append('\n');
		}
		if (end_auth_asym_id != null)
		{
			sb.append("end_auth_asym_id = ");
			sb.append(end_auth_asym_id);
			sb.append('\n');
		}
		if (end_auth_seq_id != null)
		{
			sb.append("end_auth_seq_id = ");
			sb.append(end_auth_seq_id);
			sb.append('\n');
		}
		if (end_label_asym_id != null)
		{
			sb.append("end_label_asym_id = ");
			sb.append(end_label_asym_id);
			sb.append('\n');
		}
		if (end_label_seq_id != null)
		{
			sb.append("end_label_seq_id = ");
			sb.append(end_label_seq_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (refine_tls_id != null)
		{
			sb.append("refine_tls_id = ");
			sb.append(refine_tls_id);
			sb.append('\n');
		}
		if (selection != null)
		{
			sb.append("selection = ");
			sb.append(selection);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		beg_auth_asym_id = null;
		beg_auth_seq_id = null;
		beg_label_asym_id = null;
		beg_label_seq_id = null;
		end_auth_asym_id = null;
		end_auth_seq_id = null;
		end_label_asym_id = null;
		end_label_seq_id = null;
		id_ = null;
		refine_tls_id = null;
		selection = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_refine_tls_group)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_refine_tls_group>\n");
			if (beg_auth_asym_id != null) ow.write(indent + " <PDBx:beg_auth_asym_id>" + beg_auth_asym_id + "</PDBx:beg_auth_asym_id>\n");
			if (beg_auth_seq_id != null) ow.write(indent + " <PDBx:beg_auth_seq_id>" + beg_auth_seq_id + "</PDBx:beg_auth_seq_id>\n");
			if (beg_label_asym_id != null) ow.write(indent + " <PDBx:beg_label_asym_id>" + beg_label_asym_id + "</PDBx:beg_label_asym_id>\n");
			if (beg_label_seq_id != null) ow.write(indent + " <PDBx:beg_label_seq_id>" + beg_label_seq_id + "</PDBx:beg_label_seq_id>\n");
			if (end_auth_asym_id != null) ow.write(indent + " <PDBx:end_auth_asym_id>" + end_auth_asym_id + "</PDBx:end_auth_asym_id>\n");
			if (end_auth_seq_id != null) ow.write(indent + " <PDBx:end_auth_seq_id>" + end_auth_seq_id + "</PDBx:end_auth_seq_id>\n");
			if (end_label_asym_id != null) ow.write(indent + " <PDBx:end_label_asym_id>" + end_label_asym_id + "</PDBx:end_label_asym_id>\n");
			if (end_label_seq_id != null) ow.write(indent + " <PDBx:end_label_seq_id>" + end_label_seq_id + "</PDBx:end_label_seq_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (refine_tls_id != null) ow.write(indent + " <PDBx:refine_tls_id>" + refine_tls_id + "</PDBx:refine_tls_id>\n");
			if (selection != null) ow.write(indent + " <PDBx:selection>" + selection + "</PDBx:selection>\n");
			ow.write(indent + "</PDBx:pdbx_refine_tls_group>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
