package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_SEQUENCE_RANGE category identify the
 *  beginning and ending points of polypeptide sequence segments.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_sequence_rangeCategory>
 *  <PDBx:pdbx_sequence_range seq_range_id="s1" beg_label_alt_id="" beg_label_asym_id="A" beg_label_comp_id="PRO" beg_label_seq_id="1" end_label_alt_id="" end_label_asym_id="A" end_label_comp_id="GLY" end_label_seq_id="29"></PDBx:pdbx_sequence_range>
 *  <PDBx:pdbx_sequence_range seq_range_id="s2" beg_label_alt_id="" beg_label_asym_id="D" beg_label_comp_id="PRO" beg_label_seq_id="91" end_label_alt_id="" end_label_asym_id="D" end_label_comp_id="GLY" end_label_seq_id="119"></PDBx:pdbx_sequence_range>
 *  </PDBx:pdbx_sequence_rangeCategory>
 * </pre>
 */
public class Pdbx_sequence_range extends org.pdb.beans.Pdbx_sequence_range implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_sequence_range";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_sequence_range()
	{
	}

	/** Full constructor */
	public Pdbx_sequence_range(
		Datablock datablock,
		java.lang.String beg_auth_asym_id,
		java.lang.String beg_auth_comp_id,
		java.lang.String beg_auth_seq_id,
		java.lang.String beg_label_alt_id,
		java.lang.String beg_label_asym_id,
		java.lang.String beg_label_comp_id,
		java.lang.Integer beg_label_seq_id,
		java.lang.String end_auth_asym_id,
		java.lang.String end_auth_comp_id,
		java.lang.String end_auth_seq_id,
		java.lang.String end_label_alt_id,
		java.lang.String end_label_asym_id,
		java.lang.String end_label_comp_id,
		java.lang.Integer end_label_seq_id,
		java.lang.String seq_range_id)
	{
		this.datablock = datablock;
		this.beg_auth_asym_id = beg_auth_asym_id;
		this.beg_auth_comp_id = beg_auth_comp_id;
		this.beg_auth_seq_id = beg_auth_seq_id;
		this.beg_label_alt_id = beg_label_alt_id;
		this.beg_label_asym_id = beg_label_asym_id;
		this.beg_label_comp_id = beg_label_comp_id;
		this.beg_label_seq_id = beg_label_seq_id;
		this.end_auth_asym_id = end_auth_asym_id;
		this.end_auth_comp_id = end_auth_comp_id;
		this.end_auth_seq_id = end_auth_seq_id;
		this.end_label_alt_id = end_label_alt_id;
		this.end_label_asym_id = end_label_asym_id;
		this.end_label_comp_id = end_label_comp_id;
		this.end_label_seq_id = end_label_seq_id;
		this.seq_range_id = seq_range_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_sequence_range");
		sb.append("\n");
		if (beg_auth_asym_id != null)
		{
			sb.append("beg_auth_asym_id = ");
			sb.append(beg_auth_asym_id);
			sb.append('\n');
		}
		if (beg_auth_comp_id != null)
		{
			sb.append("beg_auth_comp_id = ");
			sb.append(beg_auth_comp_id);
			sb.append('\n');
		}
		if (beg_auth_seq_id != null)
		{
			sb.append("beg_auth_seq_id = ");
			sb.append(beg_auth_seq_id);
			sb.append('\n');
		}
		if (beg_label_alt_id != null)
		{
			sb.append("beg_label_alt_id = ");
			sb.append(beg_label_alt_id);
			sb.append('\n');
		}
		if (beg_label_asym_id != null)
		{
			sb.append("beg_label_asym_id = ");
			sb.append(beg_label_asym_id);
			sb.append('\n');
		}
		if (beg_label_comp_id != null)
		{
			sb.append("beg_label_comp_id = ");
			sb.append(beg_label_comp_id);
			sb.append('\n');
		}
		if (beg_label_seq_id != null)
		{
			sb.append("beg_label_seq_id = ");
			sb.append(beg_label_seq_id);
			sb.append('\n');
		}
		if (end_auth_asym_id != null)
		{
			sb.append("end_auth_asym_id = ");
			sb.append(end_auth_asym_id);
			sb.append('\n');
		}
		if (end_auth_comp_id != null)
		{
			sb.append("end_auth_comp_id = ");
			sb.append(end_auth_comp_id);
			sb.append('\n');
		}
		if (end_auth_seq_id != null)
		{
			sb.append("end_auth_seq_id = ");
			sb.append(end_auth_seq_id);
			sb.append('\n');
		}
		if (end_label_alt_id != null)
		{
			sb.append("end_label_alt_id = ");
			sb.append(end_label_alt_id);
			sb.append('\n');
		}
		if (end_label_asym_id != null)
		{
			sb.append("end_label_asym_id = ");
			sb.append(end_label_asym_id);
			sb.append('\n');
		}
		if (end_label_comp_id != null)
		{
			sb.append("end_label_comp_id = ");
			sb.append(end_label_comp_id);
			sb.append('\n');
		}
		if (end_label_seq_id != null)
		{
			sb.append("end_label_seq_id = ");
			sb.append(end_label_seq_id);
			sb.append('\n');
		}
		if (seq_range_id != null)
		{
			sb.append("seq_range_id = ");
			sb.append(seq_range_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		beg_auth_asym_id = null;
		beg_auth_comp_id = null;
		beg_auth_seq_id = null;
		beg_label_alt_id = null;
		beg_label_asym_id = null;
		beg_label_comp_id = null;
		beg_label_seq_id = null;
		end_auth_asym_id = null;
		end_auth_comp_id = null;
		end_auth_seq_id = null;
		end_label_alt_id = null;
		end_label_asym_id = null;
		end_label_comp_id = null;
		end_label_seq_id = null;
		seq_range_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_sequence_range)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_sequence_range>\n");
			if (beg_auth_asym_id != null) ow.write(indent + " <PDBx:beg_auth_asym_id>" + beg_auth_asym_id + "</PDBx:beg_auth_asym_id>\n");
			if (beg_auth_comp_id != null) ow.write(indent + " <PDBx:beg_auth_comp_id>" + beg_auth_comp_id + "</PDBx:beg_auth_comp_id>\n");
			if (beg_auth_seq_id != null) ow.write(indent + " <PDBx:beg_auth_seq_id>" + beg_auth_seq_id + "</PDBx:beg_auth_seq_id>\n");
			if (beg_label_alt_id != null) ow.write(indent + " <PDBx:beg_label_alt_id>" + beg_label_alt_id + "</PDBx:beg_label_alt_id>\n");
			if (beg_label_asym_id != null) ow.write(indent + " <PDBx:beg_label_asym_id>" + beg_label_asym_id + "</PDBx:beg_label_asym_id>\n");
			if (beg_label_comp_id != null) ow.write(indent + " <PDBx:beg_label_comp_id>" + beg_label_comp_id + "</PDBx:beg_label_comp_id>\n");
			if (beg_label_seq_id != null) ow.write(indent + " <PDBx:beg_label_seq_id>" + beg_label_seq_id + "</PDBx:beg_label_seq_id>\n");
			if (end_auth_asym_id != null) ow.write(indent + " <PDBx:end_auth_asym_id>" + end_auth_asym_id + "</PDBx:end_auth_asym_id>\n");
			if (end_auth_comp_id != null) ow.write(indent + " <PDBx:end_auth_comp_id>" + end_auth_comp_id + "</PDBx:end_auth_comp_id>\n");
			if (end_auth_seq_id != null) ow.write(indent + " <PDBx:end_auth_seq_id>" + end_auth_seq_id + "</PDBx:end_auth_seq_id>\n");
			if (end_label_alt_id != null) ow.write(indent + " <PDBx:end_label_alt_id>" + end_label_alt_id + "</PDBx:end_label_alt_id>\n");
			if (end_label_asym_id != null) ow.write(indent + " <PDBx:end_label_asym_id>" + end_label_asym_id + "</PDBx:end_label_asym_id>\n");
			if (end_label_comp_id != null) ow.write(indent + " <PDBx:end_label_comp_id>" + end_label_comp_id + "</PDBx:end_label_comp_id>\n");
			if (end_label_seq_id != null) ow.write(indent + " <PDBx:end_label_seq_id>" + end_label_seq_id + "</PDBx:end_label_seq_id>\n");
			if (seq_range_id != null) ow.write(indent + " <PDBx:seq_range_id>" + seq_range_id + "</PDBx:seq_range_id>\n");
			ow.write(indent + "</PDBx:pdbx_sequence_range>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
