package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_SOLN_SCATTER_MODEL category record details about the
 *  homology model fitting to the solution scatter data.
 */
public class Pdbx_soln_scatter_model extends org.pdb.beans.Pdbx_soln_scatter_model implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_soln_scatter_model";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_soln_scatter_model()
	{
	}

	/** Full constructor */
	public Pdbx_soln_scatter_model(
		Datablock datablock,
		java.lang.String conformer_selection_criteria,
		java.lang.String details,
		java.lang.String entry_fitting_list,
		java.lang.String id_,
		java.lang.String method,
		java.lang.Integer num_conformers_calculated,
		java.lang.Integer num_conformers_submitted,
		java.lang.String scatter_id,
		java.lang.String software_author_list,
		java.lang.String software_list)
	{
		this.datablock = datablock;
		this.conformer_selection_criteria = conformer_selection_criteria;
		this.details = details;
		this.entry_fitting_list = entry_fitting_list;
		this.id_ = id_;
		this.method = method;
		this.num_conformers_calculated = num_conformers_calculated;
		this.num_conformers_submitted = num_conformers_submitted;
		this.scatter_id = scatter_id;
		this.software_author_list = software_author_list;
		this.software_list = software_list;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_soln_scatter_model");
		sb.append("\n");
		if (conformer_selection_criteria != null)
		{
			sb.append("conformer_selection_criteria = ");
			sb.append(conformer_selection_criteria);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_fitting_list != null)
		{
			sb.append("entry_fitting_list = ");
			sb.append(entry_fitting_list);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		if (num_conformers_calculated != null)
		{
			sb.append("num_conformers_calculated = ");
			sb.append(num_conformers_calculated);
			sb.append('\n');
		}
		if (num_conformers_submitted != null)
		{
			sb.append("num_conformers_submitted = ");
			sb.append(num_conformers_submitted);
			sb.append('\n');
		}
		if (scatter_id != null)
		{
			sb.append("scatter_id = ");
			sb.append(scatter_id);
			sb.append('\n');
		}
		if (software_author_list != null)
		{
			sb.append("software_author_list = ");
			sb.append(software_author_list);
			sb.append('\n');
		}
		if (software_list != null)
		{
			sb.append("software_list = ");
			sb.append(software_list);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		conformer_selection_criteria = null;
		details = null;
		entry_fitting_list = null;
		id_ = null;
		method = null;
		num_conformers_calculated = null;
		num_conformers_submitted = null;
		scatter_id = null;
		software_author_list = null;
		software_list = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_soln_scatter_model)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_soln_scatter_model>\n");
			if (conformer_selection_criteria != null) ow.write(indent + " <PDBx:conformer_selection_criteria>" + conformer_selection_criteria + "</PDBx:conformer_selection_criteria>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_fitting_list != null) ow.write(indent + " <PDBx:entry_fitting_list>" + entry_fitting_list + "</PDBx:entry_fitting_list>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			if (num_conformers_calculated != null) ow.write(indent + " <PDBx:num_conformers_calculated>" + num_conformers_calculated + "</PDBx:num_conformers_calculated>\n");
			if (num_conformers_submitted != null) ow.write(indent + " <PDBx:num_conformers_submitted>" + num_conformers_submitted + "</PDBx:num_conformers_submitted>\n");
			if (scatter_id != null) ow.write(indent + " <PDBx:scatter_id>" + scatter_id + "</PDBx:scatter_id>\n");
			if (software_author_list != null) ow.write(indent + " <PDBx:software_author_list>" + software_author_list + "</PDBx:software_author_list>\n");
			if (software_list != null) ow.write(indent + " <PDBx:software_list>" + software_list + "</PDBx:software_list>\n");
			ow.write(indent + "</PDBx:pdbx_soln_scatter_model>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
