package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_STRUCT_ASSEMBLY category record details about
 *  the structural elements that form macromolecular assemblies.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_assemblyCategory>
 *  <PDBx:pdbx_struct_assembly id="1">
 *  <PDBx:details> The icosahedral virus particle.</PDBx:details>
 *  </PDBx:pdbx_struct_assembly>
 *  </PDBx:pdbx_struct_assemblyCategory>
 * </pre>
 */
public class Pdbx_struct_assembly extends org.pdb.beans.Pdbx_struct_assembly implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_struct_assembly";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_struct_assembly()
	{
	}

	/** Full constructor */
	public Pdbx_struct_assembly(
		Datablock datablock,
		java.lang.String details,
		java.lang.String id_)
	{
		this.datablock = datablock;
		this.details = details;
		this.id_ = id_;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_struct_assembly");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		id_ = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_struct_assembly)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_struct_assembly>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			ow.write(indent + "</PDBx:pdbx_struct_assembly>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
