package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_STRUCT_ASSEMBLY_GEN category record details about
 *  the generation of each macromolecular assemblies. The PDBX_STRUCT_ASSEMBLY_GEN
 *  data items provide the specifications of the components that
 *  constitute that assembly in terms of cartesian transformations.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_assembly_genCategory>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="1" asym_id_list="A" oper_expression="1"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="1" asym_id_list="B" oper_expression="1"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="2" asym_id_list="A" oper_expression="2"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="2" asym_id_list="B" oper_expression="2"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="2" asym_id_list="C" oper_expression="2"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="3" asym_id_list="A" oper_expression="3"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="3" asym_id_list="B" oper_expression="3"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="3" asym_id_list="D" oper_expression="3"></PDBx:pdbx_struct_assembly_gen>
 *  </PDBx:pdbx_struct_assembly_genCategory>
 *  
 *  
 *  Example 2 -
 *  <PDBx:pdbx_struct_assembly_genCategory>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="1" asym_id_list="A,B" oper_expression="1"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="2" asym_id_list="A,B,C" oper_expression="2"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="3" asym_id_list="A,B,D" oper_expression="3"></PDBx:pdbx_struct_assembly_gen>
 *  </PDBx:pdbx_struct_assembly_genCategory>
 * </pre>
 */
public class Pdbx_struct_assembly_gen extends org.pdb.beans.Pdbx_struct_assembly_gen implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_struct_assembly_gen";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_struct_assembly_gen()
	{
	}

	/** Full constructor */
	public Pdbx_struct_assembly_gen(
		Datablock datablock,
		java.lang.String assembly_id,
		java.lang.String asym_id_list,
		java.lang.String entity_inst_id,
		java.lang.String oper_expression)
	{
		this.datablock = datablock;
		this.assembly_id = assembly_id;
		this.asym_id_list = asym_id_list;
		this.entity_inst_id = entity_inst_id;
		this.oper_expression = oper_expression;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_struct_assembly_gen");
		sb.append("\n");
		if (assembly_id != null)
		{
			sb.append("assembly_id = ");
			sb.append(assembly_id);
			sb.append('\n');
		}
		if (asym_id_list != null)
		{
			sb.append("asym_id_list = ");
			sb.append(asym_id_list);
			sb.append('\n');
		}
		if (entity_inst_id != null)
		{
			sb.append("entity_inst_id = ");
			sb.append(entity_inst_id);
			sb.append('\n');
		}
		if (oper_expression != null)
		{
			sb.append("oper_expression = ");
			sb.append(oper_expression);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		assembly_id = null;
		asym_id_list = null;
		entity_inst_id = null;
		oper_expression = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_struct_assembly_gen)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_struct_assembly_gen>\n");
			if (assembly_id != null) ow.write(indent + " <PDBx:assembly_id>" + assembly_id + "</PDBx:assembly_id>\n");
			if (asym_id_list != null) ow.write(indent + " <PDBx:asym_id_list>" + asym_id_list + "</PDBx:asym_id_list>\n");
			if (entity_inst_id != null) ow.write(indent + " <PDBx:entity_inst_id>" + entity_inst_id + "</PDBx:entity_inst_id>\n");
			if (oper_expression != null) ow.write(indent + " <PDBx:oper_expression>" + oper_expression + "</PDBx:oper_expression>\n");
			ow.write(indent + "</PDBx:pdbx_struct_assembly_gen>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
