package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Properties and features of structural assemblies.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_assembly_propCategory>
 *  <PDBx:pdbx_struct_assembly_prop biol_id="1" type="ABSA">
 *  <PDBx:value>1456.7</PDBx:value>
 *  <PDBx:details>   </PDBx:details>
 *  </PDBx:pdbx_struct_assembly_prop>
 *  </PDBx:pdbx_struct_assembly_propCategory>
 * </pre>
 */
public class Pdbx_struct_assembly_prop extends org.pdb.beans.Pdbx_struct_assembly_prop implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_struct_assembly_prop";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_struct_assembly_prop()
	{
	}

	/** Full constructor */
	public Pdbx_struct_assembly_prop(
		Datablock datablock,
		java.lang.String biol_id,
		java.lang.String details,
		java.lang.String type,
		java.lang.String value)
	{
		this.datablock = datablock;
		this.biol_id = biol_id;
		this.details = details;
		this.type = type;
		this.value = value;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_struct_assembly_prop");
		sb.append("\n");
		if (biol_id != null)
		{
			sb.append("biol_id = ");
			sb.append(biol_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		if (value != null)
		{
			sb.append("value = ");
			sb.append(value);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		biol_id = null;
		details = null;
		type = null;
		value = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_struct_assembly_prop)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_struct_assembly_prop>\n");
			if (biol_id != null) ow.write(indent + " <PDBx:biol_id>" + biol_id + "</PDBx:biol_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			if (value != null) ow.write(indent + " <PDBx:value>" + value + "</PDBx:value>\n");
			ow.write(indent + "</PDBx:pdbx_struct_assembly_prop>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
