package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_STRUCT_ASYM_GEN category record details about
 *  the generation of the crystallographic asymmetric unit. The
 *  PDBX_STRUCT_ASYM_GEN data items provide the specifications of the
 *  components that constitute the asymmetric unit in terms of cartesian
 *  transformations of deposited coordinates.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_asym_genCategory>
 *  <PDBx:pdbx_struct_asym_gen entity_inst_id="A" oper_expression="1">
 *  <PDBx:asym_id>A</PDBx:asym_id>
 *  </PDBx:pdbx_struct_asym_gen>
 *  <PDBx:pdbx_struct_asym_gen entity_inst_id="B" oper_expression="1">
 *  <PDBx:asym_id>B</PDBx:asym_id>
 *  </PDBx:pdbx_struct_asym_gen>
 *  </PDBx:pdbx_struct_asym_genCategory>
 * </pre>
 */
public class Pdbx_struct_asym_gen extends org.pdb.beans.Pdbx_struct_asym_gen implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_struct_asym_gen";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_struct_asym_gen()
	{
	}

	/** Full constructor */
	public Pdbx_struct_asym_gen(
		Datablock datablock,
		java.lang.String asym_id,
		java.lang.String entity_inst_id,
		java.lang.String oper_expression)
	{
		this.datablock = datablock;
		this.asym_id = asym_id;
		this.entity_inst_id = entity_inst_id;
		this.oper_expression = oper_expression;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_struct_asym_gen");
		sb.append("\n");
		if (asym_id != null)
		{
			sb.append("asym_id = ");
			sb.append(asym_id);
			sb.append('\n');
		}
		if (entity_inst_id != null)
		{
			sb.append("entity_inst_id = ");
			sb.append(entity_inst_id);
			sb.append('\n');
		}
		if (oper_expression != null)
		{
			sb.append("oper_expression = ");
			sb.append(oper_expression);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		asym_id = null;
		entity_inst_id = null;
		oper_expression = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_struct_asym_gen)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_struct_asym_gen>\n");
			if (asym_id != null) ow.write(indent + " <PDBx:asym_id>" + asym_id + "</PDBx:asym_id>\n");
			if (entity_inst_id != null) ow.write(indent + " <PDBx:entity_inst_id>" + entity_inst_id + "</PDBx:entity_inst_id>\n");
			if (oper_expression != null) ow.write(indent + " <PDBx:oper_expression>" + oper_expression + "</PDBx:oper_expression>\n");
			ow.write(indent + "</PDBx:pdbx_struct_asym_gen>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
