package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_STRUCT_CHEM_COMP_DIAGNOSTICS category provide
 *  annotation of diagnostics observed in chemical components.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_chem_comp_diagnosticsCategory>
 *  <PDBx:pdbx_struct_chem_comp_diagnostics ordinal="1">
 *  <PDBx:auth_comp_id>ATP</PDBx:auth_comp_id>
 *  <PDBx:auth_seq_id>10</PDBx:auth_seq_id>
 *  <PDBx:seq_num>10</PDBx:seq_num>
 *  <PDBx:pdb_strand_id>A</PDBx:pdb_strand_id>
 *  <PDBx:asym_id>A</PDBx:asym_id>
 *  <PDBx:type>MISSING_ATOM</PDBx:type>
 *  </PDBx:pdbx_struct_chem_comp_diagnostics>
 *  </PDBx:pdbx_struct_chem_comp_diagnosticsCategory>
 * </pre>
 */
public class Pdbx_struct_chem_comp_diagnostics extends org.pdb.beans.Pdbx_struct_chem_comp_diagnostics implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_struct_chem_comp_diagnostics";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_struct_chem_comp_diagnostics()
	{
	}

	/** Full constructor */
	public Pdbx_struct_chem_comp_diagnostics(
		Datablock datablock,
		java.lang.String asym_id,
		java.lang.String auth_comp_id,
		java.lang.String auth_seq_id,
		java.lang.Integer ordinal,
		java.lang.String pdb_ins_code,
		java.lang.String pdb_strand_id,
		java.lang.String seq_num,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.asym_id = asym_id;
		this.auth_comp_id = auth_comp_id;
		this.auth_seq_id = auth_seq_id;
		this.ordinal = ordinal;
		this.pdb_ins_code = pdb_ins_code;
		this.pdb_strand_id = pdb_strand_id;
		this.seq_num = seq_num;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_struct_chem_comp_diagnostics");
		sb.append("\n");
		if (asym_id != null)
		{
			sb.append("asym_id = ");
			sb.append(asym_id);
			sb.append('\n');
		}
		if (auth_comp_id != null)
		{
			sb.append("auth_comp_id = ");
			sb.append(auth_comp_id);
			sb.append('\n');
		}
		if (auth_seq_id != null)
		{
			sb.append("auth_seq_id = ");
			sb.append(auth_seq_id);
			sb.append('\n');
		}
		if (ordinal != null)
		{
			sb.append("ordinal = ");
			sb.append(ordinal);
			sb.append('\n');
		}
		if (pdb_ins_code != null)
		{
			sb.append("pdb_ins_code = ");
			sb.append(pdb_ins_code);
			sb.append('\n');
		}
		if (pdb_strand_id != null)
		{
			sb.append("pdb_strand_id = ");
			sb.append(pdb_strand_id);
			sb.append('\n');
		}
		if (seq_num != null)
		{
			sb.append("seq_num = ");
			sb.append(seq_num);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		asym_id = null;
		auth_comp_id = null;
		auth_seq_id = null;
		ordinal = null;
		pdb_ins_code = null;
		pdb_strand_id = null;
		seq_num = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_struct_chem_comp_diagnostics)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_struct_chem_comp_diagnostics>\n");
			if (asym_id != null) ow.write(indent + " <PDBx:asym_id>" + asym_id + "</PDBx:asym_id>\n");
			if (auth_comp_id != null) ow.write(indent + " <PDBx:auth_comp_id>" + auth_comp_id + "</PDBx:auth_comp_id>\n");
			if (auth_seq_id != null) ow.write(indent + " <PDBx:auth_seq_id>" + auth_seq_id + "</PDBx:auth_seq_id>\n");
			if (ordinal != null) ow.write(indent + " <PDBx:ordinal>" + ordinal + "</PDBx:ordinal>\n");
			if (pdb_ins_code != null) ow.write(indent + " <PDBx:pdb_ins_code>" + pdb_ins_code + "</PDBx:pdb_ins_code>\n");
			if (pdb_strand_id != null) ow.write(indent + " <PDBx:pdb_strand_id>" + pdb_strand_id + "</PDBx:pdb_strand_id>\n");
			if (seq_num != null) ow.write(indent + " <PDBx:seq_num>" + seq_num + "</PDBx:seq_num>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:pdbx_struct_chem_comp_diagnostics>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
