package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_STRUCT_ENTITY_INST category record details about the
 *  structural elements in the deposited entry.  The entity instance is a method
 *  neutral identifier for the observed molecular entities in the deposited coordinate
 *  set.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_entity_instCategory>
 *  <PDBx:pdbx_struct_entity_inst id="A">
 *  <PDBx:entity_id>1</PDBx:entity_id>
 *  <PDBx:details>one monomer of the dimeric enzyme</PDBx:details>
 *  </PDBx:pdbx_struct_entity_inst>
 *  <PDBx:pdbx_struct_entity_inst id="B">
 *  <PDBx:entity_id>1</PDBx:entity_id>
 *  <PDBx:details>one monomer of the dimeric enzyme</PDBx:details>
 *  </PDBx:pdbx_struct_entity_inst>
 *  </PDBx:pdbx_struct_entity_instCategory>
 * </pre>
 */
public class Pdbx_struct_entity_inst extends org.pdb.beans.Pdbx_struct_entity_inst implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_struct_entity_inst";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_struct_entity_inst()
	{
	}

	/** Full constructor */
	public Pdbx_struct_entity_inst(
		Datablock datablock,
		java.lang.String details,
		java.lang.String entity_id,
		java.lang.String id_)
	{
		this.datablock = datablock;
		this.details = details;
		this.entity_id = entity_id;
		this.id_ = id_;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_struct_entity_inst");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		entity_id = null;
		id_ = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_struct_entity_inst)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_struct_entity_inst>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			ow.write(indent + "</PDBx:pdbx_struct_entity_inst>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
