package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Special features of this structural entry.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_infoCategory>
 *  <PDBx:pdbx_struct_info type="nonpolymer_zero_occupancy_flag" value="Y"></PDBx:pdbx_struct_info>
 *  <PDBx:pdbx_struct_info type="polymer_zero_occupancy_flag" value="Y"></PDBx:pdbx_struct_info>
 *  <PDBx:pdbx_struct_info type="multiple_model_flag" value="Y"></PDBx:pdbx_struct_info>
 *  <PDBx:pdbx_struct_info type="multiple_model_details" value="Model 3 missing ligand ACX"></PDBx:pdbx_struct_info>
 *  <PDBx:pdbx_struct_info type="nonpolymer_details" value="Disordered ligand geometry for C34 with missing pyridine ring"></PDBx:pdbx_struct_info>
 *  <PDBx:pdbx_struct_info type="missing atoms in alternate conformations" value="Y"></PDBx:pdbx_struct_info>
 *  </PDBx:pdbx_struct_infoCategory>
 * </pre>
 */
public class Pdbx_struct_info extends org.pdb.beans.Pdbx_struct_info implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_struct_info";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_struct_info()
	{
	}

	/** Full constructor */
	public Pdbx_struct_info(
		Datablock datablock,
		java.lang.String details,
		java.lang.String type,
		java.lang.String value)
	{
		this.datablock = datablock;
		this.details = details;
		this.type = type;
		this.value = value;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_struct_info");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		if (value != null)
		{
			sb.append("value = ");
			sb.append(value);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		type = null;
		value = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_struct_info)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_struct_info>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			if (value != null) ow.write(indent + " <PDBx:value>" + value + "</PDBx:value>\n");
			ow.write(indent + "</PDBx:pdbx_struct_info>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
