package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_STRUCT_MSYM_GEN category record details about
 *  the generation of the minimal asymmetric unit. For instance, this
 *  category can be used to provide this information for helical and point
 *  symmetry systems.   The PDBX_STRUCT_MSYM_GEN data items provide the
 *  specifications of the components that constitute the asymmetric unit
 *  in terms of cartesian transformations of deposited coordinates.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_msym_genCategory>
 *  <PDBx:pdbx_struct_msym_gen msym_id="A" entity_inst_id="A" oper_expression="3"></PDBx:pdbx_struct_msym_gen>
 *  <PDBx:pdbx_struct_msym_gen msym_id="B" entity_inst_id="B" oper_expression="4"></PDBx:pdbx_struct_msym_gen>
 *  <PDBx:pdbx_struct_msym_gen msym_id="C" entity_inst_id="B" oper_expression="5"></PDBx:pdbx_struct_msym_gen>
 *  </PDBx:pdbx_struct_msym_genCategory>
 * </pre>
 */
public class Pdbx_struct_msym_gen extends org.pdb.beans.Pdbx_struct_msym_gen implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_struct_msym_gen";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_struct_msym_gen()
	{
	}

	/** Full constructor */
	public Pdbx_struct_msym_gen(
		Datablock datablock,
		java.lang.String entity_inst_id,
		java.lang.String msym_id,
		java.lang.String oper_expression)
	{
		this.datablock = datablock;
		this.entity_inst_id = entity_inst_id;
		this.msym_id = msym_id;
		this.oper_expression = oper_expression;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_struct_msym_gen");
		sb.append("\n");
		if (entity_inst_id != null)
		{
			sb.append("entity_inst_id = ");
			sb.append(entity_inst_id);
			sb.append('\n');
		}
		if (msym_id != null)
		{
			sb.append("msym_id = ");
			sb.append(msym_id);
			sb.append('\n');
		}
		if (oper_expression != null)
		{
			sb.append("oper_expression = ");
			sb.append(oper_expression);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		entity_inst_id = null;
		msym_id = null;
		oper_expression = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_struct_msym_gen)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_struct_msym_gen>\n");
			if (entity_inst_id != null) ow.write(indent + " <PDBx:entity_inst_id>" + entity_inst_id + "</PDBx:entity_inst_id>\n");
			if (msym_id != null) ow.write(indent + " <PDBx:msym_id>" + msym_id + "</PDBx:msym_id>\n");
			if (oper_expression != null) ow.write(indent + " <PDBx:oper_expression>" + oper_expression + "</PDBx:oper_expression>\n");
			ow.write(indent + "</PDBx:pdbx_struct_msym_gen>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
