package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_STRUCT_REF_SEQ_FEATURE category provide a
 *  mechanism for identifying and annotating sequence features.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_ref_seq_featureCategory>
 *  <PDBx:pdbx_struct_ref_seq_feature feature_id="1">
 *  <PDBx:align_id>algn2</PDBx:align_id>
 *  <PDBx:beg_auth_mon_id>GLU</PDBx:beg_auth_mon_id>
 *  <PDBx:end_auth_mon_id>PHE</PDBx:end_auth_mon_id>
 *  <PDBx:beg_auth_seq_id>10</PDBx:beg_auth_seq_id>
 *  <PDBx:end_auth_seq_id>14</PDBx:end_auth_seq_id>
 *  <PDBx:type>variant</PDBx:type>
 *  <PDBx:details>  Special </PDBx:details>
 *  </PDBx:pdbx_struct_ref_seq_feature>
 *  </PDBx:pdbx_struct_ref_seq_featureCategory>
 * </pre>
 */
public class Pdbx_struct_ref_seq_feature extends org.pdb.beans.Pdbx_struct_ref_seq_feature implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_struct_ref_seq_feature";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_struct_ref_seq_feature()
	{
	}

	/** Full constructor */
	public Pdbx_struct_ref_seq_feature(
		Datablock datablock,
		java.lang.String align_id,
		java.lang.String asym_id,
		java.lang.String beg_auth_mon_id,
		java.lang.String beg_auth_seq_id,
		java.lang.String beg_pdb_ins_code,
		java.lang.String beg_seq_num,
		java.lang.String details,
		java.lang.String end_auth_mon_id,
		java.lang.String end_auth_seq_id,
		java.lang.String end_pdb_ins_code,
		java.lang.String end_seq_num,
		java.lang.Integer feature_id,
		java.lang.String pdb_strand_id,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.align_id = align_id;
		this.asym_id = asym_id;
		this.beg_auth_mon_id = beg_auth_mon_id;
		this.beg_auth_seq_id = beg_auth_seq_id;
		this.beg_pdb_ins_code = beg_pdb_ins_code;
		this.beg_seq_num = beg_seq_num;
		this.details = details;
		this.end_auth_mon_id = end_auth_mon_id;
		this.end_auth_seq_id = end_auth_seq_id;
		this.end_pdb_ins_code = end_pdb_ins_code;
		this.end_seq_num = end_seq_num;
		this.feature_id = feature_id;
		this.pdb_strand_id = pdb_strand_id;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_struct_ref_seq_feature");
		sb.append("\n");
		if (align_id != null)
		{
			sb.append("align_id = ");
			sb.append(align_id);
			sb.append('\n');
		}
		if (asym_id != null)
		{
			sb.append("asym_id = ");
			sb.append(asym_id);
			sb.append('\n');
		}
		if (beg_auth_mon_id != null)
		{
			sb.append("beg_auth_mon_id = ");
			sb.append(beg_auth_mon_id);
			sb.append('\n');
		}
		if (beg_auth_seq_id != null)
		{
			sb.append("beg_auth_seq_id = ");
			sb.append(beg_auth_seq_id);
			sb.append('\n');
		}
		if (beg_pdb_ins_code != null)
		{
			sb.append("beg_pdb_ins_code = ");
			sb.append(beg_pdb_ins_code);
			sb.append('\n');
		}
		if (beg_seq_num != null)
		{
			sb.append("beg_seq_num = ");
			sb.append(beg_seq_num);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (end_auth_mon_id != null)
		{
			sb.append("end_auth_mon_id = ");
			sb.append(end_auth_mon_id);
			sb.append('\n');
		}
		if (end_auth_seq_id != null)
		{
			sb.append("end_auth_seq_id = ");
			sb.append(end_auth_seq_id);
			sb.append('\n');
		}
		if (end_pdb_ins_code != null)
		{
			sb.append("end_pdb_ins_code = ");
			sb.append(end_pdb_ins_code);
			sb.append('\n');
		}
		if (end_seq_num != null)
		{
			sb.append("end_seq_num = ");
			sb.append(end_seq_num);
			sb.append('\n');
		}
		if (feature_id != null)
		{
			sb.append("feature_id = ");
			sb.append(feature_id);
			sb.append('\n');
		}
		if (pdb_strand_id != null)
		{
			sb.append("pdb_strand_id = ");
			sb.append(pdb_strand_id);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		align_id = null;
		asym_id = null;
		beg_auth_mon_id = null;
		beg_auth_seq_id = null;
		beg_pdb_ins_code = null;
		beg_seq_num = null;
		details = null;
		end_auth_mon_id = null;
		end_auth_seq_id = null;
		end_pdb_ins_code = null;
		end_seq_num = null;
		feature_id = null;
		pdb_strand_id = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_struct_ref_seq_feature)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_struct_ref_seq_feature>\n");
			if (align_id != null) ow.write(indent + " <PDBx:align_id>" + align_id + "</PDBx:align_id>\n");
			if (asym_id != null) ow.write(indent + " <PDBx:asym_id>" + asym_id + "</PDBx:asym_id>\n");
			if (beg_auth_mon_id != null) ow.write(indent + " <PDBx:beg_auth_mon_id>" + beg_auth_mon_id + "</PDBx:beg_auth_mon_id>\n");
			if (beg_auth_seq_id != null) ow.write(indent + " <PDBx:beg_auth_seq_id>" + beg_auth_seq_id + "</PDBx:beg_auth_seq_id>\n");
			if (beg_pdb_ins_code != null) ow.write(indent + " <PDBx:beg_pdb_ins_code>" + beg_pdb_ins_code + "</PDBx:beg_pdb_ins_code>\n");
			if (beg_seq_num != null) ow.write(indent + " <PDBx:beg_seq_num>" + beg_seq_num + "</PDBx:beg_seq_num>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (end_auth_mon_id != null) ow.write(indent + " <PDBx:end_auth_mon_id>" + end_auth_mon_id + "</PDBx:end_auth_mon_id>\n");
			if (end_auth_seq_id != null) ow.write(indent + " <PDBx:end_auth_seq_id>" + end_auth_seq_id + "</PDBx:end_auth_seq_id>\n");
			if (end_pdb_ins_code != null) ow.write(indent + " <PDBx:end_pdb_ins_code>" + end_pdb_ins_code + "</PDBx:end_pdb_ins_code>\n");
			if (end_seq_num != null) ow.write(indent + " <PDBx:end_seq_num>" + end_seq_num + "</PDBx:end_seq_num>\n");
			if (feature_id != null) ow.write(indent + " <PDBx:feature_id>" + feature_id + "</PDBx:feature_id>\n");
			if (pdb_strand_id != null) ow.write(indent + " <PDBx:pdb_strand_id>" + pdb_strand_id + "</PDBx:pdb_strand_id>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:pdbx_struct_ref_seq_feature>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
