package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Parameter and topology files used in X-PLOR/CNS refinement.
 *  <PDBx:pdbx_xplor_fileCategory>
 *  <PDBx:pdbx_xplor_file serial_no="1">
 *  <PDBx:param_file>parm_hol.dat</PDBx:param_file>
 *  <PDBx:topol_file>topol_hol.dat</PDBx:topol_file>
 *  </PDBx:pdbx_xplor_file>
 *  </PDBx:pdbx_xplor_fileCategory>
 */
public class Pdbx_xplor_file extends org.pdb.beans.Pdbx_xplor_file implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_xplor_file";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_xplor_file()
	{
	}

	/** Full constructor */
	public Pdbx_xplor_file(
		Datablock datablock,
		java.lang.String param_file,
		java.lang.String serial_no,
		java.lang.String topol_file)
	{
		this.datablock = datablock;
		this.param_file = param_file;
		this.serial_no = serial_no;
		this.topol_file = topol_file;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_xplor_file");
		sb.append("\n");
		if (param_file != null)
		{
			sb.append("param_file = ");
			sb.append(param_file);
			sb.append('\n');
		}
		if (serial_no != null)
		{
			sb.append("serial_no = ");
			sb.append(serial_no);
			sb.append('\n');
		}
		if (topol_file != null)
		{
			sb.append("topol_file = ");
			sb.append(topol_file);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		param_file = null;
		serial_no = null;
		topol_file = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_xplor_file)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_xplor_file>\n");
			if (param_file != null) ow.write(indent + " <PDBx:param_file>" + param_file + "</PDBx:param_file>\n");
			if (serial_no != null) ow.write(indent + " <PDBx:serial_no>" + serial_no + "</PDBx:serial_no>\n");
			if (topol_file != null) ow.write(indent + " <PDBx:topol_file>" + topol_file + "</PDBx:topol_file>\n");
			ow.write(indent + "</PDBx:pdbx_xplor_file>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
