package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PHASING_MAD category record details about
 *  the phasing of the structure where methods involving
 *  multiple-wavelength anomalous-dispersion techniques are involved.
 *  
 * <pre>
 *  Example 1 - based on a paper by Shapiro et al. [Nature (London)
 *  (1995), 374, 327-337].
 *  <PDBx:phasing_MADCategory>
 *  <PDBx:phasing_MAD entry_id="NCAD"></PDBx:phasing_MAD>
 *  </PDBx:phasing_MADCategory>
 * </pre>
 */
public class Phasing_MAD extends org.pdb.beans.Phasing_MAD implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "phasing_MAD";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Phasing_MAD()
	{
	}

	/** Full constructor */
	public Phasing_MAD(
		Datablock datablock,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.String method,
		java.lang.Float pdbx_R_cullis,
		java.lang.Float pdbx_R_cullis_acentric,
		java.lang.Float pdbx_R_cullis_centric,
		java.lang.Float pdbx_R_kraut,
		java.lang.Float pdbx_R_kraut_acentric,
		java.lang.Float pdbx_R_kraut_centric,
		java.lang.String pdbx_anom_scat_method,
		java.lang.Float pdbx_d_res_high,
		java.lang.Float pdbx_d_res_low,
		java.lang.Float pdbx_fom,
		java.lang.Float pdbx_fom_acentric,
		java.lang.Float pdbx_fom_centric,
		java.lang.Float pdbx_loc,
		java.lang.Float pdbx_loc_acentric,
		java.lang.Float pdbx_loc_centric,
		java.lang.Integer pdbx_number_data_sets,
		java.lang.Float pdbx_power,
		java.lang.Float pdbx_power_acentric,
		java.lang.Float pdbx_power_centric,
		java.lang.Integer pdbx_reflns,
		java.lang.Integer pdbx_reflns_acentric,
		java.lang.Integer pdbx_reflns_centric)
	{
		this.datablock = datablock;
		this.details = details;
		this.entry_id = entry_id;
		this.method = method;
		this.pdbx_R_cullis = pdbx_R_cullis;
		this.pdbx_R_cullis_acentric = pdbx_R_cullis_acentric;
		this.pdbx_R_cullis_centric = pdbx_R_cullis_centric;
		this.pdbx_R_kraut = pdbx_R_kraut;
		this.pdbx_R_kraut_acentric = pdbx_R_kraut_acentric;
		this.pdbx_R_kraut_centric = pdbx_R_kraut_centric;
		this.pdbx_anom_scat_method = pdbx_anom_scat_method;
		this.pdbx_d_res_high = pdbx_d_res_high;
		this.pdbx_d_res_low = pdbx_d_res_low;
		this.pdbx_fom = pdbx_fom;
		this.pdbx_fom_acentric = pdbx_fom_acentric;
		this.pdbx_fom_centric = pdbx_fom_centric;
		this.pdbx_loc = pdbx_loc;
		this.pdbx_loc_acentric = pdbx_loc_acentric;
		this.pdbx_loc_centric = pdbx_loc_centric;
		this.pdbx_number_data_sets = pdbx_number_data_sets;
		this.pdbx_power = pdbx_power;
		this.pdbx_power_acentric = pdbx_power_acentric;
		this.pdbx_power_centric = pdbx_power_centric;
		this.pdbx_reflns = pdbx_reflns;
		this.pdbx_reflns_acentric = pdbx_reflns_acentric;
		this.pdbx_reflns_centric = pdbx_reflns_centric;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Phasing_MAD");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		if (pdbx_R_cullis != null)
		{
			sb.append("pdbx_R_cullis = ");
			sb.append(pdbx_R_cullis);
			sb.append('\n');
		}
		if (pdbx_R_cullis_acentric != null)
		{
			sb.append("pdbx_R_cullis_acentric = ");
			sb.append(pdbx_R_cullis_acentric);
			sb.append('\n');
		}
		if (pdbx_R_cullis_centric != null)
		{
			sb.append("pdbx_R_cullis_centric = ");
			sb.append(pdbx_R_cullis_centric);
			sb.append('\n');
		}
		if (pdbx_R_kraut != null)
		{
			sb.append("pdbx_R_kraut = ");
			sb.append(pdbx_R_kraut);
			sb.append('\n');
		}
		if (pdbx_R_kraut_acentric != null)
		{
			sb.append("pdbx_R_kraut_acentric = ");
			sb.append(pdbx_R_kraut_acentric);
			sb.append('\n');
		}
		if (pdbx_R_kraut_centric != null)
		{
			sb.append("pdbx_R_kraut_centric = ");
			sb.append(pdbx_R_kraut_centric);
			sb.append('\n');
		}
		if (pdbx_anom_scat_method != null)
		{
			sb.append("pdbx_anom_scat_method = ");
			sb.append(pdbx_anom_scat_method);
			sb.append('\n');
		}
		if (pdbx_d_res_high != null)
		{
			sb.append("pdbx_d_res_high = ");
			sb.append(pdbx_d_res_high);
			sb.append('\n');
		}
		if (pdbx_d_res_low != null)
		{
			sb.append("pdbx_d_res_low = ");
			sb.append(pdbx_d_res_low);
			sb.append('\n');
		}
		if (pdbx_fom != null)
		{
			sb.append("pdbx_fom = ");
			sb.append(pdbx_fom);
			sb.append('\n');
		}
		if (pdbx_fom_acentric != null)
		{
			sb.append("pdbx_fom_acentric = ");
			sb.append(pdbx_fom_acentric);
			sb.append('\n');
		}
		if (pdbx_fom_centric != null)
		{
			sb.append("pdbx_fom_centric = ");
			sb.append(pdbx_fom_centric);
			sb.append('\n');
		}
		if (pdbx_loc != null)
		{
			sb.append("pdbx_loc = ");
			sb.append(pdbx_loc);
			sb.append('\n');
		}
		if (pdbx_loc_acentric != null)
		{
			sb.append("pdbx_loc_acentric = ");
			sb.append(pdbx_loc_acentric);
			sb.append('\n');
		}
		if (pdbx_loc_centric != null)
		{
			sb.append("pdbx_loc_centric = ");
			sb.append(pdbx_loc_centric);
			sb.append('\n');
		}
		if (pdbx_number_data_sets != null)
		{
			sb.append("pdbx_number_data_sets = ");
			sb.append(pdbx_number_data_sets);
			sb.append('\n');
		}
		if (pdbx_power != null)
		{
			sb.append("pdbx_power = ");
			sb.append(pdbx_power);
			sb.append('\n');
		}
		if (pdbx_power_acentric != null)
		{
			sb.append("pdbx_power_acentric = ");
			sb.append(pdbx_power_acentric);
			sb.append('\n');
		}
		if (pdbx_power_centric != null)
		{
			sb.append("pdbx_power_centric = ");
			sb.append(pdbx_power_centric);
			sb.append('\n');
		}
		if (pdbx_reflns != null)
		{
			sb.append("pdbx_reflns = ");
			sb.append(pdbx_reflns);
			sb.append('\n');
		}
		if (pdbx_reflns_acentric != null)
		{
			sb.append("pdbx_reflns_acentric = ");
			sb.append(pdbx_reflns_acentric);
			sb.append('\n');
		}
		if (pdbx_reflns_centric != null)
		{
			sb.append("pdbx_reflns_centric = ");
			sb.append(pdbx_reflns_centric);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		entry_id = null;
		method = null;
		pdbx_R_cullis = null;
		pdbx_R_cullis_acentric = null;
		pdbx_R_cullis_centric = null;
		pdbx_R_kraut = null;
		pdbx_R_kraut_acentric = null;
		pdbx_R_kraut_centric = null;
		pdbx_anom_scat_method = null;
		pdbx_d_res_high = null;
		pdbx_d_res_low = null;
		pdbx_fom = null;
		pdbx_fom_acentric = null;
		pdbx_fom_centric = null;
		pdbx_loc = null;
		pdbx_loc_acentric = null;
		pdbx_loc_centric = null;
		pdbx_number_data_sets = null;
		pdbx_power = null;
		pdbx_power_acentric = null;
		pdbx_power_centric = null;
		pdbx_reflns = null;
		pdbx_reflns_acentric = null;
		pdbx_reflns_centric = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Phasing_MAD)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:phasing_MAD>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			if (pdbx_R_cullis != null) ow.write(indent + " <PDBx:pdbx_R_cullis>" + pdbx_R_cullis + "</PDBx:pdbx_R_cullis>\n");
			if (pdbx_R_cullis_acentric != null) ow.write(indent + " <PDBx:pdbx_R_cullis_acentric>" + pdbx_R_cullis_acentric + "</PDBx:pdbx_R_cullis_acentric>\n");
			if (pdbx_R_cullis_centric != null) ow.write(indent + " <PDBx:pdbx_R_cullis_centric>" + pdbx_R_cullis_centric + "</PDBx:pdbx_R_cullis_centric>\n");
			if (pdbx_R_kraut != null) ow.write(indent + " <PDBx:pdbx_R_kraut>" + pdbx_R_kraut + "</PDBx:pdbx_R_kraut>\n");
			if (pdbx_R_kraut_acentric != null) ow.write(indent + " <PDBx:pdbx_R_kraut_acentric>" + pdbx_R_kraut_acentric + "</PDBx:pdbx_R_kraut_acentric>\n");
			if (pdbx_R_kraut_centric != null) ow.write(indent + " <PDBx:pdbx_R_kraut_centric>" + pdbx_R_kraut_centric + "</PDBx:pdbx_R_kraut_centric>\n");
			if (pdbx_anom_scat_method != null) ow.write(indent + " <PDBx:pdbx_anom_scat_method>" + pdbx_anom_scat_method + "</PDBx:pdbx_anom_scat_method>\n");
			if (pdbx_d_res_high != null) ow.write(indent + " <PDBx:pdbx_d_res_high>" + pdbx_d_res_high + "</PDBx:pdbx_d_res_high>\n");
			if (pdbx_d_res_low != null) ow.write(indent + " <PDBx:pdbx_d_res_low>" + pdbx_d_res_low + "</PDBx:pdbx_d_res_low>\n");
			if (pdbx_fom != null) ow.write(indent + " <PDBx:pdbx_fom>" + pdbx_fom + "</PDBx:pdbx_fom>\n");
			if (pdbx_fom_acentric != null) ow.write(indent + " <PDBx:pdbx_fom_acentric>" + pdbx_fom_acentric + "</PDBx:pdbx_fom_acentric>\n");
			if (pdbx_fom_centric != null) ow.write(indent + " <PDBx:pdbx_fom_centric>" + pdbx_fom_centric + "</PDBx:pdbx_fom_centric>\n");
			if (pdbx_loc != null) ow.write(indent + " <PDBx:pdbx_loc>" + pdbx_loc + "</PDBx:pdbx_loc>\n");
			if (pdbx_loc_acentric != null) ow.write(indent + " <PDBx:pdbx_loc_acentric>" + pdbx_loc_acentric + "</PDBx:pdbx_loc_acentric>\n");
			if (pdbx_loc_centric != null) ow.write(indent + " <PDBx:pdbx_loc_centric>" + pdbx_loc_centric + "</PDBx:pdbx_loc_centric>\n");
			if (pdbx_number_data_sets != null) ow.write(indent + " <PDBx:pdbx_number_data_sets>" + pdbx_number_data_sets + "</PDBx:pdbx_number_data_sets>\n");
			if (pdbx_power != null) ow.write(indent + " <PDBx:pdbx_power>" + pdbx_power + "</PDBx:pdbx_power>\n");
			if (pdbx_power_acentric != null) ow.write(indent + " <PDBx:pdbx_power_acentric>" + pdbx_power_acentric + "</PDBx:pdbx_power_acentric>\n");
			if (pdbx_power_centric != null) ow.write(indent + " <PDBx:pdbx_power_centric>" + pdbx_power_centric + "</PDBx:pdbx_power_centric>\n");
			if (pdbx_reflns != null) ow.write(indent + " <PDBx:pdbx_reflns>" + pdbx_reflns + "</PDBx:pdbx_reflns>\n");
			if (pdbx_reflns_acentric != null) ow.write(indent + " <PDBx:pdbx_reflns_acentric>" + pdbx_reflns_acentric + "</PDBx:pdbx_reflns_acentric>\n");
			if (pdbx_reflns_centric != null) ow.write(indent + " <PDBx:pdbx_reflns_centric>" + pdbx_reflns_centric + "</PDBx:pdbx_reflns_centric>\n");
			ow.write(indent + "</PDBx:phasing_MAD>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
